!*************************************************************************
!   Declare arrays for use in ice shelf model

    MODULE shelf_arrays

!**************************************************************************
      USE global_param
      IMPLICIT NONE
      SAVE

!*********************************************************************
      INTEGER, ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 ioutlet,&       ! Floating outlet? (0/1)
                 nfront,&        ! Ice front geometry, coded
                 ifloatrt,&      ! Floating E-W interfaces? (0/1)
                 ifloathi        ! Floating N-S interfaces? (0/1)

      INTEGER, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 icefront        ! Ice front geometry, faces (0/1)

      REAL(dp), ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 strinv          ! Strain-rate second invariant (a^-2)

      REAL(dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 taubed,&        ! Basal shear stress (Pa)
                 taumar          ! Marginal stress (Pa)

!**************************************************************************
   END MODULE shelf_arrays
!**************************************************************************
