!**********************************************************************
!   Calculate ice shelf geometry and velocities

    SUBROUTINE shelf_front(ub,vb,ubk,vbk,Hice,fpshtk,ftshtk,Bbar,pice,&
                           thinice,ifloating,time)

!**********************************************************************
      USE shelf_arrays
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: time
      INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: ifloating
      REAL(dp), INTENT(IN) :: thinice
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: Hice,Bbar,pice
      REAL(dp), INTENT(IN), DIMENSION(nlon-1,nlatp) :: fpshtk,ubk
      REAL(dp), INTENT(IN), DIMENSION(nlonp,nlat-1) :: ftshtk,vbk
      REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub
      REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb

      ! Local variables
      INTEGER :: i,ij,j,jj,ip,jp
      REAL(dp) :: uwest,ueast,vnorth,vsouth

!********************************************************
      DO j=3,nlatp
        jj = j-1
        jp = j+1
        DO i=3,nlonp
          ij = i-1
          ip = i+1

          IF ((ifloating(i,j)==1) .and. (Hice(i,j) > thinice)) THEN

            ! Find floating outlet position, geometry
            IF (Hice(ip,j) < zerop) THEN        ! Eastern front
              icefront(1,i,j) = 1
              IF (Hice(i,jp) < zerop) THEN          ! Northern front
                icefront(2,i,j) = 1
                IF (Hice(ij,j) < zerop) THEN            ! Western front
                  icefront(3,i,j) = 1
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 1234          ! Isolated cell, all fronts
                  ELSE
                    nfront(i,j) = 123     ! Three calving fronts, ENW
                  END IF
                ELSE
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 124     ! Three calving fronts, ENS
                  ELSE
                    nfront(i,j) = 12      ! Two calving fronts, EN
                  END IF
                END IF
              ELSE
                IF (Hice(ij,j) < zerop) THEN            ! Western front
                  icefront(3,i,j) = 1
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 134          ! Three calving fronts, EWS
                  ELSE
                    nfront(i,j) = 13      ! Two calving fronts, EW
                  END IF
                ELSE
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 14      ! Two calving fronts, ES
                  ELSE
                    nfront(i,j) = 1       ! One calving front, E
                  END IF
                END IF
              END IF

!********************************************************
            ELSE                        ! No Eastern front
              IF (Hice(i,jp) < zerop) THEN          ! Northern front
                icefront(2,i,j) = 1
                IF (Hice(ij,j) < zerop) THEN            ! Western front
                  icefront(3,i,j) = 1
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 234          ! Three calving fronts, NWS
                  ELSE
                    nfront(i,j) = 23      ! Two calving fronts, NW
                  END IF
                ELSE
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 24      ! Two calving fronts, NS
                  ELSE
                    nfront(i,j) = 2       ! One calving fronts, N
                  END IF
                END IF
              ELSE
                IF (Hice(ij,j) < zerop) THEN            ! Western front
                  icefront(3,i,j) = 1
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 34          ! Two calving fronts, WS
                  ELSE
                    nfront(i,j) = 3       ! One calving fronts, W
                  END IF
                ELSE
                  IF (Hice(i,jj) < zerop) THEN              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 4       ! One calving fronts, S
                  ELSE
                    nfront(i,j) = 0       ! No calving fronts
                  END IF
                END IF
              END IF

            END IF

!************************************************************
            ! Calculate outlet velocities for floating front
            IF (nfront(i,j) > 0)  THEN
              ioutlet(i,j) = 1

!*******************************************
              ! Assign east-west velocities
              SELECT CASE (nfront(i,j))
              CASE(1,12,14,124)                ! simple eastern outlet
                IF (ifloating(ij,j) == 0) THEN
                  ! western neighbour grounded
                  uwest = -fpshtk(ij,jj)*c2/(Hice(i,j)+Hice(ij,j))
                ELSE
                  uwest = ubk(ij,jj)
                END IF
                ub(i,jj) = uwest + delx(j)/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))

              CASE(13,123,134,1234)        ! E-W outlets
                ub(i,jj) =   delx(j)/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))
                ub(ij,jj) = -delx(j)/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))

              CASE(3,23,34,234)                ! simple western outlet
                IF (ifloating(ip,j) == 0) THEN
                  ! eastern neighbour grounded
                  ueast = -fpshtk(i,jj)*c2/(Hice(i,j)+Hice(ip,j))
                ELSE
                  ueast = ubk(i,jj)
                END IF
                ub(ij,jj) = ueast - delx(j)/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))

              CASE(2,4,24)                        ! N-S outlets only
                ub(ij,jj) = c0
                ub(i,jj) = c0

              CASE DEFAULT
                WRITE(45,*) 'Improper case, nfront = ', nfront(i,j)
                WRITE(45,*) '  point ', i,j, 'time = ', time
                STOP
              END SELECT

!*******************************************
              ! Assign north-south velocities
              SELECT CASE (nfront(i,j))
              CASE(2,12,23,123)                ! simple northern outlet
                IF (ifloating(i,jj) == 0) THEN
                  ! southern neighbour grounded
                  vsouth = -ftshtk(ij,jj)*c2/(Hice(i,j)+Hice(i,jj))
                ELSE
                  vsouth = vbk(ij,jj)
                END IF
                vb(ij,j) = vsouth - dy/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))

              CASE(24,124,234,1234)                ! N-S outlets
                vb(ij,j) =  -dy/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))
                vb(ij,jj) =  dy/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))

              CASE(4,14,34,134)                        ! simple southern outlet
                IF (ifloating(i,jp) == 0) THEN
                  ! northern neighbour grounded
                  vnorth = -ftshtk(ij,j)*c2/(Hice(i,j)+Hice(i,jp))
                ELSE
                  vnorth = vbk(ij,j)
                END IF
                vb(ij,jj) = vnorth + dy/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))

              CASE(1,3,13)                        ! E-W outlets only
                vb(ij,jj) = c0
                vb(ij,j) = c0

              CASE DEFAULT
                WRITE(45,*) 'Improper case, nfront = ', nfront(i,j)
                WRITE(45,*) '  point ', i,j, 'time = ', time
                STOP
              END SELECT

!***************************************************************************
             END IF                ! nfront ifblock

!***************************************************************************
          END IF              ! ifloating ifblock

        END DO
      END DO

!***************************************************************************
    END SUBROUTINE shelf_front
!***************************************************************************
