!**********************************************************************
! Calculate ice shelf geometry and velocities

  SUBROUTINE shelf_vel(ub,vb,Hice,thinice,ifloating,time)

!**********************************************************************
    USE shelf_arrays
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: time
    INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: ifloating
    REAL(dp), INTENT(IN) :: thinice
    REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: Hice
    REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub
    REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb

    ! Local variables
    INTEGER :: i,ij,j,jj,ip,jp,k,kp,ioute,ioutw,joutn,jouts,&
               iheade,iheadw,jheadn,jheads,imid,length,iseek,jseek
    REAL(dp) :: Hrt,Hhi

!**********************************************************************
    ! Interpolate floating velocites for interior shelf points
    ! Assign eastern and northern interface velocities here

    DO j=3,nlatp
      jj = j-1
      jp = j+1
      DO i=3,nlonp
        ij = i-1
        ip = i+1

        IF ((ifloating(i,j)==1).and.(ioutlet(i,j)==0)) THEN
          ! Search for outlet and head
          ioute = 0 ; ioutw = 0 ; joutn = 0 ; jouts = 0
          iheade = 0 ; iheadw = 0 ; jheadn = 0 ; jheads = 0
          Hrt = r2*(Hice(i,j) + Hice(ip,j))
          Hhi = r2*(Hice(i,j) + Hice(i,jp))

!************************************************************
          IF (Hice(i,j) < thinice) THEN
            ! If ice is thin, assign zero flux
            ub(i,jj) = c0
            vb(ij,j) = c0
            CYCLE

          ELSE

!************************************************************
            ! EW sweep and zonal velocity assignment
            DO iseek = ip,nlon-1        ! sweep east
              IF ((icefront(1,iseek,j)==1).or.(Hice(iseek,j) < zerop)) THEN
                ! Outlet cell
                ioute = iseek
                EXIT
              ELSE IF (ifloating(iseek,j) == 0) THEN
                ! Grounded ice cell: head of shelf
                iheade = iseek
                EXIT
              END IF
            END DO
            IF (iseek == nlon) THEN                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, eastward'
              STOP
            END IF

            DO iseek = ij,2,-1               ! sweep west
              IF ((icefront(3,iseek,j)==1).or.(Hice(iseek,j) < zerop)) THEN
                ! Outlet cell
                ioutw = iseek
                EXIT
              ELSE IF (ifloating(iseek,j) == 0) THEN
                ! Grounded ice cell: head of shelf
                iheadw = iseek
                EXIT
              END IF
            END DO
            IF (iseek == 1) THEN                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, westward'
              STOP
            END IF

!***************************************************
            ! Assign E-W velocities
            IF (ioute > 0) THEN  ! Eastern outlet
              IF (ioutw > 0) THEN        ! spreading E-W
                length = INT((ioute-ioutw)/2)
                imid = ioutw + length
                IF (i >= imid) THEN
                  ub(i,jj) = ub(ioute,jj)*(c1-DBLE(ioute-i)/DBLE(length))
                  IF ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) THEN
                    ub(ij,jj) = ub(ioute,jj)*(c1-DBLE(ioute-ij)/DBLE(length))
                  END IF
                ELSE
                  ub(i,jj) = ub(ioutw-1,jj)*(c1-DBLE(i-ioutw)/DBLE(length))
                  IF ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) THEN
                    ub(ij,jj) = ub(ioutw-1,jj)*(c1-DBLE(ij-ioutw)/DBLE(length))
                  END IF
                END IF
              ELSE                         ! simple eastward flow
                length = ioute - iheadw
                ub(i,jj) = ub(ioute,jj)*(c1-DBLE(ioute-i)/DBLE(length))
                IF ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) THEN
                  ub(ij,jj) = ub(ioute,jj)*(c1-DBLE(ioute-ij)/DBLE(length))
                END IF
              END IF

            ELSE             ! Eastern head
              IF (ioutw > 0) THEN        ! western outlet
                length = iheade - ioutw
                ub(i,jj) = ub(ioutw-1,jj)*(c1-DBLE(i-ioutw)/DBLE(length))
                IF ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) THEN
                  ub(ij,jj) = ub(ioutw-1,jj)*(c1-DBLE(ij-ioutw)/DBLE(length))
                END IF
              ELSE                        ! grounded on both sides
                ub(i,jj) = c0
                ub(ij,jj) = c0
              END IF
            END IF

!******************************************************************
            ! NS sweep and zonal velocity assignment
            DO jseek = jp,nlat-1           ! sweep north
              IF ((icefront(2,i,jseek)==1).or.(Hice(i,jseek) < zerop)) THEN
                ! Outlet cell
                joutn = jseek
                EXIT
              ELSE IF (ifloating(i,jseek) == 0) THEN
                ! Grounded ice cell: head of shelf
                jheadn = jseek
                EXIT
              END IF
            END DO
            IF (jseek == nlat) THEN                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, northward'
              STOP
            END IF

            DO jseek = jj,2,-1               ! sweep south
              IF ((icefront(4,i,jseek)==1).or.(Hice(i,jseek) < zerop)) THEN
                ! Outlet cell
                jouts = jseek
                EXIT
              ELSE IF (ifloating(i,jseek) == 0) THEN
                ! Grounded ice cell: head of shelf
                jheads = jseek
                EXIT
              END IF
            END DO
            IF (jseek == 1) THEN                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, southward'
              STOP
            END IF

!***************************************************
            ! Assign N-S velocities
            IF (joutn > 0) THEN     ! northern outlet
              IF (jouts > 0) THEN        ! spreading N-S
                length = INT((joutn-jouts)/2)
                imid = jouts + length
                IF (j >= imid) THEN
                  vb(ij,j) = vb(ij,joutn)*(c1-DBLE(joutn-j)/DBLE(length))
                  IF ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) THEN
                    vb(ij,jj) = vb(ij,joutn)*(c1-DBLE(joutn-jj)/DBLE(length))
                  END IF
                ELSE
                  vb(ij,j) = vb(ij,jouts-1)*(c1-DBLE(j-jouts)/DBLE(length))
                  IF ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) THEN
                    vb(ij,jj) = vb(ij,jouts-1)*(c1-DBLE(jj-jouts)/DBLE(length))
                  END IF
                END IF
              ELSE                         ! simple northward flow
                length = joutn - jheads
                vb(ij,j) = vb(ij,joutn)*(c1-DBLE(joutn-j)/DBLE(length))
                IF ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) THEN
                  vb(ij,jj) = vb(ij,joutn)*(c1-DBLE(joutn-jj)/DBLE(length))
                END IF
              END IF

            ELSE             ! northern head
              IF (jouts > 0) THEN                ! southern outlet
                length = jheadn - jouts
                vb(ij,j) = vb(ij,jouts-1)*(c1-DBLE(j-jouts)/DBLE(length))
                IF ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) THEN
                  vb(ij,jj) = vb(ij,jouts-1)*(c1-DBLE(jj-jouts)/DBLE(length))
                END IF
              ELSE                                ! grounded to N and S
                vb(ij,jj) = c0
                vb(ij,j) = c0
              END IF
            END IF

!**************************************************************************
          END IF                !! Velocity assignment

!**************************************************************************
        END IF                ! ifloating ifblock

      END DO
    END DO

!**********************************************************************
    DO jj=1,nlatp
      ub(1,jj) = c0
      ub(nlon-1,jj) = c0
    END DO

    DO ij=1,nlonp
      vb(ij,1) = c0
      vb(ij,nlat-1) = c0
    END DO

!***************************************************************************
  END SUBROUTINE shelf_vel
!***************************************************************************
