!**********************************************************************
!   Calculate full field of sliding velocites
!   Specify velocities at right and upper cell interfaces

    SUBROUTINE slidxy(ub,vb,iub,ivb,hivectk,hivimp,Hvectk,Hvimp,&
                      Bslid,time)

!**********************************************************************
      USE shelf_arrays
      USE icetd_arrays
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: time
      INTEGER, INTENT(OUT), DIMENSION(nlon-1,nlatp) :: iub
      INTEGER, INTENT(OUT), DIMENSION(nlonp,nlat-1) :: ivb
      REAL(dp), INTENT(IN) :: Bslid
      REAL(dp), INTENT(IN), DIMENSION(ndsys) :: hivectk,hivimp,Hvectk,Hvimp
      REAL(dp), INTENT(OUT), DIMENSION(nlon-1,nlatp) :: ub
      REAL(dp), INTENT(OUT), DIMENSION(nlonp,nlat-1) :: vb

      ! Local variables
      INTEGER :: i,ij,j,jj,k
      REAL(dp) :: tmelt,tmeltrt,ttest,testrt,Hrt,Hhi,tmelthi,&
                  testhi,meltcrit
      LOGICAL :: lfloatrt,lfloathi

!**********************************************************************
      ! Basic EISMINT sliding law tests
      meltcrit = 0.001_dp        ! Melt point activation criteria
      lfloatrt = .false.
      lfloathi = .false.
      iub = 0                        ! Initialize
      ivb = 0

      DO j=2,nlatp
        jj = j-1
        DO i=2,nlonp
         ij = i-1
         k = i + nlon*jj

         ! Cycle if ice interfaces are floating
         IF (ishelf > 2) THEN
           lfloatrt = .false.
           lfloathi = .false.
           IF (ifloatrt(i,jj) == 1)  lfloatrt = .true.
           IF (ifloathi(ij,j) == 1)  lfloathi = .true.
         END IF

         tmelt = triplept - fptdep*Hvectk(k)
         ttest = tice(nvertp,ij,jj) - tmelt

         IF ((tice(nvertp,ij,jj) >= tmelt).or.(ABS(ttest) < meltcrit)) THEN
              ! Melting point activation

           IF (.not.lfloatrt) THEN      ! Assign eastern interface velocity
             tmeltrt = triplept - fptdep*Hvectk(k+1)
             testrt = tice(nvertp,i,jj) - tmeltrt
             IF ((tice(nvertp,i,jj)>= tmeltrt).or.(ABS(testrt)< meltcrit)) THEN
                ! E-W sliding
               Hrt = r2*(Hvimp(k)+Hvimp(k+1))
               ub(i,jj) = Bslid*Hrt*(hivimp(k+1)-hivimp(k))/delx(j)
               iub(i,jj) = 1
             ELSE
               ub(i,jj) = c0
             END IF
           END IF

           IF (.not.lfloathi) THEN      ! Assign eastern interface velocity
               tmelthi = triplept - fptdep*Hvectk(k+nlon)
             testhi = tice(nvertp,ij,j) - tmelthi
             IF ((tice(nvertp,ij,j)>= tmelthi).or.(ABS(testhi)< meltcrit)) THEN
                     ! N-S sliding
               Hhi = r2*(Hvimp(k)+Hvimp(k+nlon))
               vb(ij,j) = Bslid*Hhi*(hivimp(k)-hivimp(k+nlon))/dy
               ivb(ij,j) = 1
             ELSE
               vb(ij,j) = c0
             END IF
           END IF

         ELSE                 ! Frozen
           IF (.not.lfloatrt)  ub(i,jj) = c0
           IF (.not.lfloathi)  vb(ij,j) = c0
         END IF

       END DO
     END DO

     DO jj=1,nlatp
        ub(1,jj) = c0
        ub(nlon-1,jj) = c0
     END DO

     DO ij=1,nlonp
        vb(ij,1) = c0
        vb(ij,nlat-1) = c0
     END DO

!***************************************************************************
   END SUBROUTINE slidxy
!***************************************************************************
