!*************************************************************************
!   Function called by Numerical Recipes linbcg to calculate residual norm.
!   Modified from the NR code, p. 81.
!   Computes vector magnitude norm (itol.le.3) or largest
!   component norm (itol.eq.4)

    FUNCTION snrm(bvec,njac,itol)

!*************************************************************************
      USE global_param
      IMPLICIT NONE
      REAL(KIND=dp) :: snrm
      INTEGER, INTENT(IN) :: njac,itol
      REAL(KIND=dp), INTENT(IN) :: bvec(njac)

      ! Local variables
      INTEGER :: i,ibmax

!*************************************************************************
      IF (itol <= 3) THEN                  ! L_2 norm
         snrm = 0.d0
         DO i=1,njac
           snrm = snrm + bvec(i)**2
         END DO
         snrm = SQRT(snrm)

      ELSE IF (itol == 4) THEN             ! L_1 norm
         ibmax = 1
         DO i=1,njac
           IF (ABS(bvec(i)) > ABS(bvec(ibmax))) ibmax = i
         END DO
         snrm = ABS(bvec(ibmax))

      END IF

!***************************************************************************
    END FUNCTION snrm
!***************************************************************************
