!****************************************************************************
! Assign  cell interface temperatures for the strain heating calculation.
! This version bases interface assignment on upstream direction.
! Incorporate correction for the pressure-softening de facto here
! (the flow law has no pressure effects in it).

  SUBROUTINE strain_int(tice,ttt,tpt,vtt,vpt,hi,Hice)

!****************************************************************************
    USE global_param
    IMPLICIT NONE
    REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) ::  Hice,hi
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlatp) :: tice
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlat-1) :: vtt
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlon-1,nlatp) :: vpt

    REAL(dp), INTENT(OUT), DIMENSION(2:nvertp,nlonp,nlat-1) :: ttt
    REAL(dp), INTENT(OUT), DIMENSION(2:nvertp,nlon-1,nlatp) :: tpt

    ! Local
    INTEGER :: i,j,ij,jj,k
    REAL(dp) :: tmcorr,Hlt,Hlo

!****************************************************************************
    ! Assign lower and left interfaces
    DO jj=2,nlatp
      j = jj+1
      DO ij=2,nlonp
        i = ij+1

!***************************************
        ! Left interface
        Hlt = r2*(Hice(i,j) + Hice(ij,j))

        IF (Hice(i,j) < zerop) THEN        !! No ice, assign upstream T or null

          IF (Hlt < zerop) THEN           ! No zonal flux
            DO k=2,nvertp
              tpt(k,ij,jj) = tnoice
            END DO
          ELSE                                   ! Default Eward
            DO k=2,nvertp
              tmcorr = fptdep*Hlt*xi(k)
              tpt(k,ij,jj) = MIN(tice(k,ij-1,jj) + tmcorr, triplept)
            END DO
          END IF

        ELSE                                !! Ice present; look for upstream

          IF (ij == nlonp) THEN            ! Default Eward
            DO k=2,nvertp
              tmcorr = fptdep*Hlt*xi(k)
              tpt(k,ij,jj) = MIN(tice(k,ij-1,jj) + tmcorr, triplept)
            END DO

          ELSE                                   ! Interior
            IF (hi(i,j) < hi(ij,j)) THEN               ! Eastward flow
              DO k=2,nvertp
                tmcorr = fptdep*Hlt*xi(k)
                tpt(k,ij,jj) = MIN(tice(k,ij-1,jj) + tmcorr, triplept)
              END DO
            ELSE IF (hi(i,j) > hi(ij,j)) THEN          ! Westward flow
              DO k=2,nvertp
                tmcorr = fptdep*Hlt*xi(k)
                tpt(k,ij,jj) = MIN(tice(k,ij,jj) + tmcorr, triplept)
              END DO
            ELSE                                               ! No flow
                 DO k=2,nvertp
                tmcorr = fptdep*Hlt*xi(k)
                tpt(k,ij,jj) = MIN(r2*(tice(k,ij,jj) + tice(k,ij-1,jj)) &
                                               + tmcorr, triplept)
              END DO
            END IF
          END IF          ! Boundary block
        END IF                ! If ice block

!***************************************
        ! Lower interface
        Hlo = r2*(Hice(i,j) + Hice(i,jj))

        IF (Hice(i,j) < zerop) THEN        !! No ice here
                                        !! Assign upstream or null T

          IF (Hlo < zerop) THEN           ! No meridional flux
            DO k=2,nvertp
              ttt(k,ij,jj) = tnoice
            END DO
          ELSE                                   ! Default Northward
            DO k=2,nvertp
              tmcorr = fptdep*Hlo*xi(k)
              ttt(k,ij,jj) = MIN(tice(k,ij,jj-1) + tmcorr, triplept)
            END DO
          END IF

        ELSE                                !! Ice present; look for upstream

          IF (jj == nlatp) THEN           ! Default Northward
            DO k=2,nvertp
              tmcorr = fptdep*Hlo*xi(k)
              ttt(k,ij,jj) = MIN(tice(k,ij,jj-1) + tmcorr, triplept)
            END DO

          ELSE                                  ! Interior
            IF (hi(i,j) > hi(i,jj)) THEN                ! Southward flow
              DO k=2,nvertp
                tmcorr = fptdep*Hlo*xi(k)
                ttt(k,ij,jj) = MIN(tice(k,ij,jj) + tmcorr, triplept)
              END DO
            ELSE IF (hi(i,j) < hi(i,jj)) THEN                ! Northward flow
              DO k=2,nvertp
                tmcorr = fptdep*Hlo*xi(k)
                ttt(k,ij,jj) = MIN(tice(k,ij,jj-1) + tmcorr, triplept)
              END DO
            ELSE
              DO k=2,nvertp
                tmcorr = fptdep*Hlo*xi(k)
                ttt(k,ij,jj) = MIN(r2*(tice(k,ij,jj) + tice(k,ij,jj-1)) &
                                             + tmcorr, triplept)
              END DO
            END IF
          END IF          ! Boundary block
        END IF                ! If ice block

      END DO
    END DO

!****************************************************************************
  END SUBROUTINE strain_int
!****************************************************************************
