!**************************************************************************
!   Calculate variables of the moment as required in the
!   nested time loop in tfield.  Generic: for sheet or stream
!   ice calculations.  Uses linear rates of change calculated
!   in setnest.

    SUBROUTINE varnest(hi,hikt,Hice,Hicekt,nestt,timeinc,Hsij,Hicecur,&
                       Hiceprev,hipijcur,hitijcur,hipijk,hitijk,dhhdt,&
                       dhndt,dhsdt,dhedt,dhwdt,dhipijdt,dhitijdt,dhidt,&
                       dhtndt,dhtsdt,dhtedt,dhtwdt,Hhi,Hlo,Hrt,Hlt,hipij,&
                       hitij,gradij,htij,htrt,htlt,hthi,htlo,dhtnedt,&
                       dhtnwdt,dhtsedt,dhtswdt,gradrt,gradlt,&
                       gradhi,gradlo,i,j,ij,jj)

!***************************************************************************
      USE global_param
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: nestt,i,j,ij,jj
      REAL(dp), INTENT(IN) :: hi(nlon,nlat),hikt(nlon,nlat),&
                              Hice(nlon,nlat),Hicekt(nlon,nlat),&
                              Hicecur,Hiceprev,timeinc,hipijcur,&
                              hitijcur,dhhdt,dhidt,dhndt,dhsdt,dhedt,&
                              dhwdt,dhipijdt,dhitijdt,dhtndt,dhtsdt,&
                              dhtedt,dhtwdt,hipijk,hitijk,dhtnedt,dhtnwdt,&
                              dhtsedt,dhtswdt
      REAL(dp), INTENT(INOUT) :: Hsij,Hhi,Hlo,Hrt,Hlt,hipij,hitij,&
                                 gradij,htij,htrt,htlt,hthi,htlo,&
                                 gradrt,gradlt,gradhi,gradlo
      ! Local variables
      REAL(dp) :: Hicen,Hices,Hicew,Hicee,htn,hts,hte,htw,dhdxrt,dhdyrt,&
                  dhdxlt,dhdylt,dhdxhi,dhdyhi,dhdxlo,dhdylo,htne,htnw,&
                  htse,htsw

!**************************************************************************

      IF (nestt == 1) THEN    ! Cell area/thickness/dynamic values:
         Hsij = Hicecur       !  constant for internal time loop
         Hicen = Hice(i,j+1)
         Hices = Hice(i,jj)
         Hicee = Hice(i+1,j)
         Hicew = Hice(ij,j)
         htij = hi(i,j)
         htn = hi(i,j+1)
         hts = hi(i,jj)
         hte = hi(i+1,j)
         htw = hi(ij,j)
         htne = hi(i+1,j+1)
         htnw = hi(ij,j+1)
         htse = hi(i+1,jj)
         htsw = hi(ij,jj)
         hipij = hipijcur
         hitij = hitijcur

      ELSE                   ! Update each internal step
         Hsij = Hiceprev + dhhdt*timeinc
         Hicen = Hicekt(i,j+1)  + dhndt*timeinc
         Hices = Hicekt(i,jj)  + dhsdt*timeinc
         Hicee = Hicekt(i+1,j)  + dhedt*timeinc
         Hicew = Hicekt(ij,j)  + dhwdt*timeinc
         htij = hikt(i,j)  + dhidt*timeinc
         htn = hikt(i,j+1) + dhtndt*timeinc
         hts = hikt(i,jj) + dhtsdt*timeinc
         hte = hikt(i+1,j) + dhtedt*timeinc
         htw = hikt(ij,j) + dhtwdt*timeinc
         htne = hikt(i+1,j+1) + dhtnedt*timeinc
         htnw = hikt(ij,j+1) + dhtnwdt*timeinc
         htse = hikt(i+1,jj) + dhtsedt*timeinc
         htsw = hikt(ij,jj) + dhtswdt*timeinc
         hipij = hipijk + dhipijdt*timeinc
         hitij = hitijk + dhitijdt*timeinc
      END IF

      Hrt = r2*(Hsij + Hicee)
      Hlt = r2*(Hsij + Hicew)
      Hhi = r2*(Hsij + Hicen)
      Hlo = r2*(Hsij + Hices)
      htrt = r2*(hte + htij)
      htlt = r2*(htw + htij)
      hthi = r2*(htn + htij)
      htlo = r2*(hts + htij)
      gradij = hipij**2 + hitij**2

      dhdxrt = (hte - htij)/delx(j)
      dhdxlt = (htij - htw)/delx(j)
      dhdxhi = p25*(hte + htne - htw - htnw)/delxhi(j)
      dhdxlo = p25*(hte + htse - htw - htsw)/delxhi(jj)

      dhdyrt = p25*(hts + htse - htn - htne)/dy
      dhdylt = p25*(hts + htsw - htn - htnw)/dy
      dhdyhi = (htij - htn)/dy
      dhdylo = (hts - htij)/dy

      gradrt = dhdxrt**2 + dhdyrt**2
      gradlt = dhdxlt**2 + dhdylt**2
      gradhi = dhdxhi**2 + dhdyhi**2
      gradlo = dhdxlo**2 + dhdylo**2

!***************************************************************************
    END SUBROUTINE varnest
!***************************************************************************
