#if defined time_mean_sbc_data && defined restorst && !defined uvic_replacst
      subroutine atmos

!----------------------------------------------------------------------
!     simple data atmosphere
!----------------------------------------------------------------------

      implicit none

# include "param.h"
# include "csbc.h"
# include "mapsbc.h"
# if defined uvic_save_flxadj && defined uvic_embm
#  include "atm.h"
# endif

      character(32) :: stamp

      integer i, j

      real damp1, damp2, sss, sst
      common /catmos/ sst(imt,jmt), sss(imt,jmt)

!----------------------------------------------------------------------
!       restore surface tracers to prescribed data using a newtonian
!       damping term with a restoring time scale of "dampts" (days)
!       (converted to a surface tracer flux by factor "damp").
!----------------------------------------------------------------------

      damp1 = dampdz(1)*secday/dampts(1)
      damp2 = dampdz(1)*secday/dampts(1)
      if (isst .ne. 0 .and. ihflx .ne. 0) then
        do j=1,jmt
          do i=2,imtm1
            sbcocn(i,j,ihflx) = damp1*(sst(i,j) - sbcocn(i,j,isst))
#  if defined uvic_save_flxadj && defined uvic_embm
            flxadj(i,j,1) = sbcocn(i,j,ihflx)
#  endif
          enddo
        enddo
      endif
      if (isss .ne. 0 .and. ipme .ne. 0) then
        do j=1,jmt
          do i=2,imtm1
            sbcocn(i,j,ipme) = damp2*(sss(i,j) - sbcocn(i,j,isss))
#  if defined uvic_save_flxadj && defined uvic_embm
            flxadj(i,j,2) = sbcocn(i,j,ipme)
#  endif
          enddo
        enddo
      endif

      return
      end
#elif defined time_varying_sbc_data
      subroutine atmos

!----------------------------------------------------------------------
!     simple data atmosphere
!----------------------------------------------------------------------

      implicit none

# include "param.h"
# include "csbc.h"
# include "ctdbc.h"
# include "tmngr.h"
# include "switch.h"
# include "mapsbc.h"
# include "ndcon.h"
# if defined uvic_save_flxadj && defined uvic_embm &&  defined  restorst
#  include "atm.h"
# endif

      integer i, iou, j, je, js, m, n, ntrec

      real damp1, damp2, realdays, wnext

!-----------------------------------------------------------------------
!     determine the disk pointers, time weight interpolation factor,
!     and whether or not it is time to bring in new S.B.C. from disk
!     based on the time (days) in MOM since dec 31, 1899 midnight.

!     express model time in days after start of S.B.C. by adding time
!     of I.C. to current model time then subtract time at start of
!     S.B.C.. Note that "itemptime" was allocated in settmngr and is
!     only needed as a temporary.
!     need to add "dt" to the model time because the call to
!     atmos precedes the time stepping loop which calls mom, so the
!     model time has not yet been incremented when atmos executes.
!-----------------------------------------------------------------------

      do n=1,ntdbc
        call addtime (initial, imodeltime, itemptime)
        call addtime (itemptime, idt, itemptime)
        call subtime (itemptime, isbcstart(n), itemptime)
        daysbc(n) = realdays(itemptime)
      enddo

!-----------------------------------------------------------------------
!     determine the disk pointers, time weight interpolation factor,
!     and whether or not it is time to bring in new S.B.C. from disk
!     based on the time (days) in MOM since dec 31, 1899 midnight.
!-----------------------------------------------------------------------

      do n=1,ntdbc
        call timeinterp (daysbc(n), n, tdrec(1,n), aprec(1,n)
     &,    ntdrec(n), period(n), method, inextd(n), iprevd(n)
     &,    wprev(n), rdtdbc(n), inextm(n), iprevm(n))
# if defined uvic_sbc_in_memory
        rdtdbc(n) = .false.
        iprevm(n) = iprevd(n)
        inextm(n) = inextd(n)
# endif
      enddo

!-----------------------------------------------------------------------
!     read in data for each S.B.C. when necessary
!-----------------------------------------------------------------------

      n = 1
      do m=1,numsbc

        if ( m .eq. itaux ) then
!         x component of windstress
          call get_tdsbc (n, 'data/taux_mth.nc', 'taux', itaux
     &,     rdtdbc(n), 0.1, 0.)

        elseif ( m .eq. itauy ) then
!         y component of windstress
          call get_tdsbc (n, 'data/tauy_mth.nc', 'tauy', itauy
     &,     rdtdbc(n), 0.1, 0.)

# if defined uvic_read_my_stf
        elseif ( m .eq. ihflx ) then
!         heat flux
          call get_tdsbc (n, 'data/hflx_mth.nc', 'hflx', ihflx
     &,     rdtdbc(n), 1., 0.)

          elseif ( m .eq. ipme ) then
!         fresh water flux
          call get_tdsbc (n, 'data/pme_mth.nc', 'pme', ipme
     &,     rdtdbc(n), 1., 0.)
# elif defined uvic_replacst
        elseif ( m .eq. isst ) then
!         replace sst and let model calculate fluxes
          call get_tdsbc (n, 'data/sst_mth.nc', 'sst', isst
     &,     rdtdbc(n), 1., 273.15)

        elseif ( m .eq. isss ) then
!         replace sss and let model calculate fluxes
          call get_tdsbc (n, 'data/sss_mth.nc', 'sss', isss
     &,     rdtdbc(n), 1000., 35.)
# elif defined  restorst
        elseif ( m .eq. ihflx ) then
!         set fluxes for restoring sst
          call get_tdsbc (n, 'data/sst_mth.nc', 'sst', ihflx
     &,     rdtdbc(n), 1., 273.15)

        elseif ( m .eq. ipme ) then
!         set fluxes for restoring sss
          call get_tdsbc (n, 'data/sss_mth.nc', 'sss', ipme
     &,     rdtdbc(n), 1000., 35.)

          damp1 = dampdz(1)*secday/dampts(1)
          damp2 = dampdz(2)*secday/dampts(2)
          do j=1,jmt
            do i=1,imt
              sbcocn(i,j,ihflx) =  damp1*(sbcocn(i,j,ihflx)
     &                          - sbcocn(i,j,isst))
              sbcocn(i,j,ipme) = damp2*(sbcocn(i,j,ipme)
     &                         - sbcocn(i,j,isss))
#  if defined uvic_save_flxadj && defined uvic_embm
              flxadj(i,j,1) = sbcocn(i,j,ihflx)
              flxadj(i,j,2) = sbcocn(i,j,ipme)
#  endif
            enddo
          enddo

# endif
# if defined uvic_embm
        elseif ( m .eq. iws ) then
!         surface wind speed
          call get_tdsbc (n, 'data/ws_mth.nc', 'ws', iws
     &,     rdtdbc(n), 0.01, 0.)
# endif
# if defined uvic_embm_astress &&  defined uvic_embm
        elseif ( m .eq. iwa ) then
!         surface wind angle
          call get_tdsbc (n, 'data/wa_mth.nc', 'wa', iwa
     &,     rdtdbc(n), 0.01, 0.)

# endif
# if defined uvic_embm_adv_q &&  defined uvic_embm
        elseif ( m .eq. iwx ) then
!         x component of advecting wind
          call get_tdsbc (n, 'data/wx_mth.nc', 'wx', iwx
     &,     rdtdbc(n), 0.01, 0.)

        elseif ( m .eq. iwy ) then
!         y component of advecting wind
          call get_tdsbc (n, 'data/wy_mth.nc', 'wy', iwy
     &,     rdtdbc(n), 0.01, 0.)

# endif
# if defined shortwave
        elseif ( m .eq. ipsw ) then
!         penetrating shortwave radiation
          call get_tdsbc (n, 'data/psw_mth.nc', 'psw', ipsw
     &,     rdtdbc(n), 1., 0.)
# endif
        endif
# if defined show_details

        if (rdtdbc(n)) then
          write (stdout,'(/tr1,a,i2,a,i6,a,a,a,i3,a,a,a,a32)')
     &      '==> Reading S.B.C. #',n, ' from rec ',inextd(n)
     &,     '[ending at ', rstamp2,'] into index ',inextm(n),'  for '
     &,     ftmp(1:len_trim(ftmp)), ' at MOM time',stamp
        endif
# endif

      enddo

      return
      end

      subroutine get_tdsbc (n, file, name, index, read, scalar, offset)

      implicit none

# include "param.h"
# include "csbc.h"
# include "ctdbc.h"
# include "mapsbc.h"

      character (*) :: file, name
      integer i, index, iou, j, ntrec, n
      logical read
      real offset, scalar, time, wnext

      if (read) then
        time = 0.
        ntrec = 1
        call openfile (file, time, ntrec, iou)
        call getvara (name, iou, imt*jmt, (/1,1,inextd(n)/)
     &,   (/imt,jmt,1/), obc(1,1,n,inextm(n)), scalar, offset)
        call closefile (iou)
      endif
      wnext = c1-wprev(n)
      do j=1,jmt
        do i=1,imt
          sbcocn(i,j,index) = wprev(n)*obc(i,j,n,iprevm(n))
     &                      + wnext*obc(i,j,n,inextm(n))
        enddo
      enddo
      n = n + 1

      return
      end
#else
      subroutine atmos

      return
      end
#endif
