!====================== include file "csbc.h" ==========================

!                    surface boundary conditions (S.B.C.)

!     numsbc  = total number of S.B.C. this is the sum of the
!               atmosphere S.B.C. and ocean S.B.C. fields.

!     sbcocn  = S.B.C. fields.

!     dampts  = time scale for damping surface tracers (days) to data
!     dampdz  = ocean level thickness for converting newtonian damping
!               to a surface flux

!     ntspos  = number of time steps per ocean segment

!     sbcname  = S.B.C. character string names (eg: "SST", "taux", etc)
!               note that these character strings should be changed with
!               care since they are used to identify fields for special
!               treatment

!     dunits  = dimensional units for S.B.C. (eg: "deg C")

!     mapsbc  = indices for relating how S.B.C. fields are stored
!               within arrays "sbcocn" and "sbcatm"
!               eg: m = mapsbc(n) where sbcocn(,,m) is S.B.C. "n"

!     author:      r. c. pacanowski      e-mail=> rcp@gfdl.gov

      integer numsbc
      parameter (numsbc = 7
#if defined uvic_embm_astress
     &                   + 1
#endif
#if defined uvic_embm_adv_q
     &                   + 2
#endif
#if defined shortwave
     &                   + 1
#endif
#if defined uvic_ice_evp
     &                   + 4
#endif
     &                      )

      integer mapsbc, numpas, ntspos, ntspas
      common /csbc_i/ mapsbc(numsbc), numpas, ntspos, ntspas

      real sbcocn, dampts, dampdz, subflux, subz
      common /csbc_r/ sbcocn(imt,jmt,numsbc)
      common /csbc_r/ dampts(nt), dampdz(nt)
#if defined llnl_plume
      common /csbc_r/ subflux(imt,jmt,nt), subz(imt,jmt)
#endif
