      subroutine gasbc
#if defined uvic_embm

!=======================================================================
!     calculate boundary conditions for the atmospheric model

!     inputs:
!     ncall = number of times this routine was called

!     author:      m.eby                 e-mail=> eby@uvic.ca
!=======================================================================

      implicit none

# include "param.h"
# include "coord.h"
# include "csbc.h"
# include "ice.h"
# include "levind.h"
# include "mapsbc.h"
# include "scalar.h"
# include "switch.h"
# include "tmngr.h"
# include "cembm.h"
# include "atm.h"
# if defined rot_grid
#  include "grdvar.h"
# endif
# if defined uvic_embm_adv_q
#  include "solve.h"
# endif

      integer i, j

      real slb, sss

      slb = 3.80116e3/ssp

      avetime = 0.0
# if defined uvic_embm_adv_q

!-----------------------------------------------------------------------
!     average precipitaion and zero accumulator
!-----------------------------------------------------------------------

      avgp(:,:) = accp(:,:)/(segtim*86400.0)
      accp(:,:) = 0.0
# endif

!-----------------------------------------------------------------------
!     zero flux totals for new accumulation
!-----------------------------------------------------------------------

      flux(:,:,:) = 0.0
# if defined llnl_plume
      subflux(:,:,:) = 0.0
# endif
# if defined uvic_convect_brine
      cbf(:,:,:) = 0.0
      cba(:,:,:) = 0.0
# endif

      do j=2,jmtm1
        do i=2,imtm1

          if (kmt(i,j) .gt. 0) then

!-----------------------------------------------------------------------
!           set sea surface temperature and surface humidity
!-----------------------------------------------------------------------

            surf(i,j,1) = sbcocn(i,j,isst)
            surf(i,j,2) = slb*exp(17.67*surf(i,j,1)/
     &                    (surf(i,j,1) + 243.5))

!-----------------------------------------------------------------------
!           calculate freezing point of sea water using UNESCO (1983)
!-----------------------------------------------------------------------

            sss = 1000.0*sbcocn(i,j,isss) + 35.0
            frzpt(i,j) = -.0575*sss + 1.710523e-3*sss**1.5
     &                   - 2.154996e-4*sss**2

          endif
        enddo
# if !defined uvic_embm_annual

!-----------------------------------------------------------------------
!     update insolation for the current day
!-----------------------------------------------------------------------

#  if defined rot_grid
        do i=2,imtm1
          call insolation (dayoyr, tlat(i,j), solins(i,j))
        enddo
#  else
        call insolation (dayoyr, yt(j), solins(j))
#  endif

# endif
      enddo

!-----------------------------------------------------------------------
!     update any atmospheric data
!-----------------------------------------------------------------------

# if defined time_mean_sbc_data
      if (pcfactor .gt. 0.001) call albedo
#  if defined uvic_ice_evp || defined uvic_embm_astress
      sbcocn(:,:,itaux) = taux(:,:)
      sbcocn(:,:,itauy) = tauy(:,:)
#  endif
#  if defined uvic_embm_adv_q && defined uvic_embm_astress
      sbcocn(:,:,iwx) = wx(:,:)
      sbcocn(:,:,iwy) = wy(:,:)
#  endif
#  if defined uvic_embm_astress
      sbcocn(:,:,iws) = ws(:,:)
#  endif
# elif defined time_varying_sbc_data
      call atmos
      call albedo
# endif

# if defined uvic_embm_astress
!-----------------------------------------------------------------------
!     calculate winds with new feedback
!-----------------------------------------------------------------------

      call add_astress (1, imt, 1, jmt)

# endif
# if defined uvic_old_ws
      call windspd

# endif
!-----------------------------------------------------------------------
!     calcualte CO2 forcing
!-----------------------------------------------------------------------

      call co2forc
# if defined uvic_embm_adv_q

!-----------------------------------------------------------------------
!     set flags to calcualte new coefficients
!-----------------------------------------------------------------------

      newcoef(1,1) = .true.
      newcoef(2,1) = .true.
      newcoef(1,2) = .true.
      newcoef(2,2) = .true.
# endif
# if defined time_averages

!-----------------------------------------------------------------------
!     zero time average accumulators
!-----------------------------------------------------------------------

      if (.not. timavgperts) call ta_atm_snap (1, imt, 1, jmt, 0)
# endif
# if defined time_step_monitor

!-----------------------------------------------------------------------
!     zero time average integral accumulators
!-----------------------------------------------------------------------

      if (.not. tsiperts) call ta_atm_tsi (0)
# endif
#endif

      return
      end
