      subroutine globalsum (index)

!=======================================================================
!     calculate the global sums of heat and fresh water

!     input:
!       index = index for calculation (1=initial, 2=current, 3=final)

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================
#if defined uvic_global_sums
# if !defined uvic_mom

      implicit none
# endif

# include "param.h"
# if defined uvic_embm
#  include "atm.h"
#  include "cembm.h"
# endif
# if defined uvic_ice && defined uvic_embm
#  include "ice.h"
# endif
# include "coord.h"
# include "grdvar.h"
# include "levind.h"
# if defined uvic_mom
#  include "iounit.h"
#  include "mw.h"
# endif
# include "tmngr.h"

      integer i, index, j, k, n, nc

      real area, cstdyt, dtah1, dtah2, dtaf1, dtaf2, dtih1, dtih2
      real dtif1, dtif2, dtlh1, dtlh2, dtlf1, dtlf2, dtoh1, dtof1
      real dtoh2, dtof2, dtoih1, dtoih2, dtsh1, dtsh2, dtsf1, dtsf2
      real dtf1, dth1, dtf2, dth2, tah, taf, tf, tsh, tsf, th, tih
      real tif, tlh, tlf, toh, tof

      common /global_r/ tah(3), taf(3), tsh(3), tsf(3), tih(3), tif(3)
      common /global_r/ tlh(3), tlf(3), toh(3), tof(3), dtoih1

!-----------------------------------------------------------------------
!     sum heat and fresh water in the atmosphere, snow, ice and ocean
!-----------------------------------------------------------------------

      if (index .eq. 1) dtoih1 = 0.0

!     zero accumulators

      do n=min(3,index*2-1),3
        tah(n) = 0.
        taf(n) = 0.
        tsh(n) = 0.
        tsf(n) = 0.
        tih(n) = 0.
        tif(n) = 0.
        tlh(n) = 0.
        tlf(n) = 0.
        toh(n) = 0.
        tof(n) = 0.
      enddo

# if !defined uvic_embm
      dtoih = 0.0
# endif

!     calculate totals

      do j=2,jmtm1
# if defined uvic_mom
        call getrow (latdisk(taup1disk), nslab, j
     &,   u(1,1,jmw,1,taup1), t(1,1,jmw,1,taup1))

# endif
        cstdyt = cst(j)*dyt(j)
        do i=2,imtm1
          area = cstdyt*dxt(i)
# if defined uvic_embm
          tah(3) = tah(3) + at(i,j,2,1)*area
          taf(3) = taf(3) + at(i,j,2,2)*area
# endif
# if defined uvic_ice && defined uvic_embm
#  if defined uvic_ice_cpts
          do nc=1,ncat
            tsf(3) = tsf(3) + hseff(i,j,2,nc)*area
            tif(3) = tif(3) + heff(i,j,2,nc)*area
          enddo
          do layer=1,ntilay
            tih(3) = tih(3) + E(i,j,2,layer)*area
          enddo
#  else
          tsf(3) = tsf(3) + hsno(i,j,2)*area
          tif(3) = tif(3) + hice(i,j,2)*area
#  endif
# endif
# if defined uvic_embm_land && defined uvic_embm
          tlf(3) = tlf(3) + soilm(i,j,2)*area
# endif
# if defined uvic_mom
          do k=1,km
            vol = dzt(k)*area
            toh(3) = toh(3) + t(i,k,jmw,1,taup1)*vol
            tof(3) = tof(3) + t(i,k,jmw,2,taup1)*vol
          enddo
# endif
        enddo
      enddo

!     convert units to Joules and kilograms

# if defined uvic_embm
      tah(3) = (taf(3)*rhoatm*hq*vlocn + tah(3)*cpatm*rhoatm*ht)*1.0e-7
      taf(3) = taf(3)*rhoatm*hq*1.0e-3
# endif
# if defined uvic_ice && defined uvic_embm
      tsh(3) = -tsf(3)*rhosno*flice*1.0e-7
      tsf(3) = tsf(3)*rhosno*1.0e-3
#  if defined uvic_ice_cpts
      tih(3) = tih(3)*1.0e-7   ! cpts ice energy of melting is negative
#  else
      tih(3) = -tif(3)*rhoice*flice*1.0e-7
#  endif
      tif(3) = tif(3)*rhoice*1.0e-3
# endif
# if defined uvic_embm_land && defined uvic_embm
      tlh(3) = tlh(3)
      tlf(3) = tlf(3)*1.0e-3
# endif
      toh(3) = toh(3)/0.2389
      tof(3) = -tof(3)/34.9

!     calculate differences from start of run

      dtah1 = tah(3) - tah(1)
      dtaf1 = taf(3) - taf(1)
      dtsf1 = tsf(3) - tsf(1)
      dtsh1 = tsh(3) - tsh(1)
      dtih1 = tih(3) - tih(1)
      dtif1 = tif(3) - tif(1)
      dtlh1 = tlh(3) - tlh(1)
      dtlf1 = tlf(3) - tlf(1)
      dtoh1 = toh(3) - toh(1)
      dtof1 = tof(3) - tof(1)
      dtoih1 = dtoih1 + dtoih

!     calculate differences from last time step

      dtah2 = tah(3) - tah(2)
      dtaf2 = taf(3) - taf(2)
      dtsf2 = tsf(3) - tsf(2)
      dtsh2 = tsh(3) - tsh(2)
      dtih2 = tih(3) - tih(2)
      dtif2 = tif(3) - tif(2)
      dtlh2 = tlh(3) - tlh(2)
      dtlf2 = tlf(3) - tlf(2)
      dtoh2 = toh(3) - toh(2)
      dtof2 = tof(3) - tof(2)
      dtoih2 = dtoih

      dtoih = 0.0
      do n=index,2
        tah(n) = tah(3)
        taf(n) = taf(3)
        tsh(n) = tsh(3)
        tsf(n) = tsf(3)
        tih(n) = tih(3)
        tif(n) = tif(3)
        tlh(n) = tlh(3)
        tlf(n) = tlf(3)
        toh(n) = toh(3)
        tof(n) = tof(3)
      enddo

!     write differences or totals

      if (index .eq. 2) then

        dtf1 = dtaf1 + dtsf1 + dtif1 + dtlf1 + dtof1
        dth1 = dtah1 + dtsh1 + dtih1 + dtlh1 + dtoh1 + dtoih1
        dtf2 = dtaf2 + dtsf2 + dtif2 + dtlf2 + dtof2
        dth2 = dtah2 + dtsh2 + dtih2 + dtlh2 + dtoh2 + dtoih2
        write (*,'(a,a,14x,a,15x,a)') 'Changes in heat and fresh water'
     &,   ' from start of run', 'and', 'last calculation'
        write (*,'(a,e22.14,a,e22.14,a,e22.14,a,e22.14,a)')
     &    ' d atm    ', dtah1, ' (J) ', dtaf1, ' (kg)'
     &,                 dtah2, ' (J) ', dtaf2, ' (kg)'
     &,   ' d snow   ', dtsh1, ' (J) ', dtsf1, ' (kg)'
     &,                 dtsh2, ' (J) ', dtsf2, ' (kg)'
     &,   ' d ice    ', dtih1, ' (J) ', dtif1, ' (kg)'
     &,                 dtih2, ' (J) ', dtif2, ' (kg)'
     &,   ' d lnd    ', dtlh1, ' (J) ', dtlf1, ' (kg)'
     &,                 dtlh2, ' (J) ', dtlf2, ' (kg)'
     &,   ' d ocn    ', dtoh1, ' (J) ', dtof1, ' (kg)'
     &,                 dtoh2, ' (J) ', dtof2, ' (kg)'
     &,   ' d out-in ', dtoih1,' (J) ', 0.0,   ' (kg)'
     &,                 dtoih2,' (J) ', 0.0,   ' (kg)'
     &,   ' d total  ', dth1,  ' (J) ', dtf1,  ' (kg)'
     &,                 dth2,  ' (J) ', dtf2,  ' (kg)'

      else

        th = tah(index) +tsh(index) +tih(index) +tlh(index) +toh(index)
        tf = taf(index) +tsf(index) +tif(index) +tlf(index) +tof(index)
        write (*,'(/,a,a)') 'Total heat (in Joules referenced to 0 C'
     &,   ' and no ice or snow) and fresh water (in kg)'
        write (*,'(a,a)') 'Total ocean fresh water is the equivalent'
     &,   ' difference from the ocean volume referenced to 34.9 ppt'
        write (*,'(a,e22.14,a,e22.14,a)')
     &    ' t atm    ', tah(index), ' (J) ', taf(index), ' (kg)'
     &,   ' t snow   ', tsh(index), ' (J) ', tsf(index), ' (kg)'
     &,   ' t ice    ', tih(index), ' (J) ', tif(index), ' (kg)'
     &,   ' t lnd    ', tlh(index), ' (J) ', tlf(index), ' (kg)'
     &,   ' t ocn    ', toh(index), ' (J) ', tof(index), ' (kg)'
     &,   ' t total  ', th,         ' (J) ', tf,         ' (kg)'

      endif
#endif

      return
      end
