      subroutine gosbc

!=======================================================================
!     calculate the average fluxes for next ocean time step
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

#if defined uvic_embm
# include "param.h"
# include "cembm.h"
# include "atm.h"
# include "levind.h"
# include "csbc.h"
# include "mapsbc.h"
# if defined uvic_convect_brine
#  include "ice.h"
# endif

      integer i, j, nc, num

      real fa, fb, fc

!-----------------------------------------------------------------------
!     calculate average net fluxes. convert heat flux to cal/cm**2/s
!     from kW/m**2 and fresh water flux (cm/s) to an apparent salt
!     flux (g/cm**2/s) using global ocean average salinity, socn
!-----------------------------------------------------------------------

      fa = 2.389e-8/avetime
      fb = -socn/avetime
      fc = 1.0/avetime
      num = 0
      do j=2,jmtm1
        do i=2,imtm1
          if (kmt(i,j) .gt. 0) then
# if defined llnl_plume
#  if defined llnl_plume_heat
            subflux(i,j,1) = flux(i,j,1)
#  endif
#  if defined llnl_plume_salt
            subflux(i,j,2) = flux(i,j,2)
#  endif
            if (subflux(i,j,1) .gt. c0) subflux(i,j,1) = c0
            if (subflux(i,j,2) .gt. c0) subflux(i,j,2) = c0
#  if defined llnl_plume_all_heat
            subflux(i,j,1) = flux(i,j,1)
#  endif
#  if defined llnl_plume_all_salt
            subflux(i,j,2) = flux(i,j,2)
#  endif
            flux(i,j,1) = flux(i,j,1) - subflux(i,j,1)
            subflux(i,j,1) = fa*subflux(i,j,1)
            flux(i,j,2) = flux(i,j,2) - subflux(i,j,2)
            subflux(i,j,2) = fb*subflux(i,j,2)
# endif
# if defined uvic_convect_brine
            cba0(i,j) = 0.0
            do nc=0,ncat
              cba(i,j,nc) = fc*cba(i,j,nc)
              if (cba(i,j,nc) .gt. 0.0) then
                cbf(i,j,nc) = fb*cbf(i,j,nc)/cba(i,j,nc)
                cba0(i,j) = cba0(i,j) + cba(i,j,nc)
              else
                cbf(i,j,nc) = 0.0
                cba(i,j,nc) = 0.0
              endif
            enddo
            if (cba0(i,j) .gt. 1.0) then
              if (cba0(i,j) .gt. 1.000001) then
                print*, "==> Warning: ice area > 1: ", cba0(i,j)
                endif
              cba0(i,j) = 1.0
            endif
            cba0(i,j) = 1.0 - cba0(i,j)
# endif
# if defined uvic_read_my_stf || defined restorst
            sbcocn(i,j,ihflx) = sbcocn(i,j,ihflx) + fa*flux(i,j,1)
            sbcocn(i,j,ipme) = sbcocn(i,j,ipme) + fb*flux(i,j,2)
# else
            sbcocn(i,j,ihflx) = fa*flux(i,j,1)
            sbcocn(i,j,ipme) = fb*flux(i,j,2)
# endif
# if defined uvic_ice_evp || defined uvic_embm_astress
            sbcocn(i,j,itaux) = fc*flux(i,j,nat+1)
            sbcocn(i,j,itauy) = fc*flux(i,j,nat+2)
# endif
          endif
        enddo
      enddo
      call setbcx (sbcocn(1,1,ihflx), imt, jmt)
      call setbcx (sbcocn(1,1,ipme), imt, jmt)
      call setbcx (sbcocn(1,1,itaux), imt, jmt)
      call setbcx (sbcocn(1,1,itauy), imt, jmt)
# if defined uvic_convect_brine
      do nc=0,ncat
        call setbcx (cbf(1,1,nc), imt, jmt)
        call setbcx (cba(1,1,nc), imt, jmt)
      enddo
      call setbcx (cba0, imt, jmt)
# endif

#endif
      return
      end
