#if defined time_mean_sbc_data
      subroutine setatm

!-----------------------------------------------------------------------
!     set up for simple data atmosphere (just for sbcocn)
!-----------------------------------------------------------------------

      implicit none

!     before adding a surface boundary condition
!      1. check numsbc is large enough (in csbc.h)
!      2. add index definition to driver and mapsbc.h (eq. itaux)
!      3. add code below

      integer i, iou, j, k, m, n, ntrec

# include "param.h"
# include "csbc.h"
# include "mapsbc.h"
# if defined uvic_embm
#  include "atm.h"
# endif
# if defined restorst
      real sst, sss
      common /catmos/ sst(imt,jmt), sss(imt,jmt)
# endif

      do n=1,numsbc

        if ( n .eq. itaux ) then
          print*, 'x component of windstress'
          call get_sbc ('data/taux_ann.nc', 'taux', itaux, 0.1, 0.)
# if defined uvic_ice_evp || defined uvic_embm_astress
          taux(:,:) = sbcocn(:,:,itaux)
# endif

        elseif ( n .eq. itauy ) then
          print*, 'y component of windstress'
          call get_sbc ('data/tauy_ann.nc', 'tauy', itauy, 0.1, 0.)
# if defined uvic_ice_evp || defined uvic_embm_astress
          tauy(:,:) = sbcocn(:,:,itauy)
# endif

# if defined uvic_read_my_stf
        elseif ( n .eq. ihflx ) then
          print*, 'heat flux'
          call get_sbc ('data/hflx_ann.nc', 'hflx', ihflx, 1., 0.)

        elseif ( n .eq. ipme ) then
          print*, 'fresh water flux'
          call get_sbc ('data/pme_ann.nc', 'pme', ipme, 1., 0.)

# elif defined uvic_replacst
        elseif ( n .eq. isst ) then
          print*, 'sea surface temperature'
          call get_sbc ('data/sst_ann.nc', 'sst', isst, 1., 273.15)

        elseif ( n .eq. isss ) then
          print*, 'sea surface salinity'
          call get_sbc ('data/sss_ann.nc', 'sss', isss, 1000., 35.)

# elif defined restorst
        elseif ( n .eq. ihflx ) then
          print*, 'data for restoring sst'
          call get_sbc ('data/sst_ann.nc', 'sst', ihflx, 1., 273.15)
          sst(:,:) = sbcocn(:,:,ihflx)
          sbcocn(:,:,ihflx) = 0.0

        elseif ( n .eq. ipme ) then
          print*, 'data for restoring sss'
          call get_sbc ('data/sss_ann.nc', 'sss', ipme, 1000., 35.)
          sss(:,:) = sbcocn(:,:,ipme)
          sbcocn(:,:,ipme) = 0.0

# endif
# if defined uvic_embm
        elseif ( n .eq. iws ) then
          print*, 'surface wind speed'
          call get_sbc ('data/ws_ann.nc', 'ws', iws, 0.01, 0.)

# endif
# if defined uvic_embm_astress &&  defined uvic_embm
        elseif ( n .eq. iwa ) then
          print*, 'surface wind angle'
          call get_sbc ('data/ws_ann.nc', 'wa', iwa, 0.01, 0.)

# endif
# if defined uvic_embm_adv_q &&  defined uvic_embm
        elseif ( n .eq. iwx ) then
          print*, 'x component of advecting wind'
          call get_sbc ('data/wx_ann.nc', 'wx', iwx, 0.01, 0.)

        elseif ( n .eq. iwy ) then
          print*, 'y component of advecting wind'
          call get_sbc ('data/wy_ann.nc', 'wy', iwy, 0.01, 0.)

# endif
# if defined shortwave
        elseif ( n .eq. ipsw ) then
          print*, 'penetrating shortwave radiation'
          call get_sbc ('data/psw_ann.nc', 'psw', ipsw, 1., 0.)

# endif
        endif

      enddo

      return
      end

      subroutine get_sbc (file, name, index, scalar, offset)

      implicit none

# include "param.h"
# include "csbc.h"
# include "mapsbc.h"

      character (*) :: file, name
      integer index, iou, ntrec
      real offset, scalar, time

      time = 0.
      ntrec = 1
      call openfile (file, time, ntrec, iou)
      call getvara (name, iou, imt*jmt, (/1,1/)
     &, (/imt,jmt/), sbcocn(1,1,index), scalar, offset)
      call closefile (iou)

      return
      end

#elif defined time_varying_sbc_data
      subroutine setatm

!-----------------------------------------------------------------------
!     set up for simple time varying data atmosphere (just for sbcocn)
!-----------------------------------------------------------------------

!      implicit none

!     this is set up only for periodic monthly data.

!     before adding a surface boundary condition
!      1. check numsbc and ntdbc are large enough (in csbc.h & ctdbc.h)
!      2. add index definition to driver and mapsbc.h (eq. itaux)
!      3. add code below and to atmos.f

      integer i, iou, j, k, m, n, ntrec

# include "param.h"
# include "csbc.h"
# include "mapsbc.h"
# if defined uvic_embm
#  include "atm.h"
# endif
# include "calendar.h"
# include "ctdbc.h"
# include "tmngr.h"
# include "switch.h"

      do n=1,ntdbc
        ntdrec(n) = 12
        period(n) = .true.
        do m=1, ntdrec(n)
          k = m + 1
          aprec(m,n) = daypm(m)
          if (.not. eqyear .and. nint(aprec(m,n)) .eq. 28) then
            aprec(m,n) = aprec(m,n) + 0.2425
            print*, '=>Warning: adding 0.2425 days to feb for leap year'
          endif
!         create time stamp for the end of each month
          if (k .gt. 12) then
            call mkstmp (dstamp(m,n), 2, 1, 1, 0, 0, 0)
          else
            call mkstmp (dstamp(m,n), 1, k, 1, 0, 0, 0)
          endif
        enddo

        call timeinterpi (ntdrec(n), dstamp(1,n), aprec(1,n), tdrec(1,n)
     &,                  isbcstart(n), period(n))

        call addtime (initial, imodeltime, itemptime)
        call subtime (itemptime, isbcstart(n), itemptime)
        daysbc(n) = realdays(itemptime)
        iprevm(n) = 1
        inextm(n) = 2
        method    = 3
        call timeinterp (daysbc(n), n, tdrec(1,n), aprec(1,n), ntdrec(n)
     &,      period(n), method, inextd(n), iprevd(n), wprev(n)
     &,      rdtdbc(n), inextm(n), iprevm(n))
      enddo

      euler2 = .false.

!     load previous and next data for all boundary conditions
# if defined uvic_sbc_in_memory
!     this is set up only for monthly data.
      do k=1,12
# else
      do k=1,2
# endif
        n = 1
        do m=1,numsbc

          if (n .le. ntdbc) then

            rdtdbc(n) = .true.
# if defined uvic_sbc_in_memory
            id = k
            im = k
# else
            id = iprevd(n)
            im = iprevm(n)
            if (k .eq. 2) then
              id = inextd(n)
              im = inextm(n)
           endif
# endif

            if ( m .eq. itaux ) then
              if (k .eq. 1) print*, 'x component of windstress'
              call get_sbc (n, 'data/taux_mth.nc', 'taux', id, im
     &,         0.1, 0.)

            elseif ( m .eq. itauy ) then
              if (k .eq. 1) print*, 'y component of windstress'
              call get_sbc (n, 'data/tauy_mth.nc', 'tauy', id, im
     &,         0.1, 0.)

# if defined uvic_read_my_stf
              if (k .eq. 1) print*, 'heat flux'
            elseif ( m .eq. ihflx ) then
              call get_sbc (n, 'data/hflx_mth.nc', 'hflx', id, im
     &,         1., 0.)

            elseif ( m .eq. ipme ) then
              if (k .eq. 1) print*, 'fresh water flux'
              call get_sbc (n, 'data/pme_mth.nc', 'pme', id, im
     &,         1., 0.)

# elif defined uvic_replacst
            elseif ( m .eq. isst ) then
              if (k .eq. 1) print*, 'sea surface temperature'
              call get_sbc (n, 'data/sst_mth.nc', 'sst', id, im
     &,         1., 273.15)

            elseif ( m .eq. isss ) then
              if (k .eq. 1) print*, 'sea surface salinity'
              call get_sbc (n, 'data/sss_mth.nc', 'sss', id, im
     &,         1000., 35.)

# elif defined restorst
            elseif ( m .eq. ihflx ) then
              if (k .eq. 1) print*, 'data for restoring sst'
              call get_sbc (n, 'data/sst_mth.nc', 'sst', id, im
     &,         1., 273.15)

            elseif ( m .eq. ipme ) then
              if (k .eq. 1) print*, 'data for restoring sss'
              call get_sbc (n, 'data/sss_mth.nc', 'sss', id, im
     &,         1000., 35.)

# endif
# if defined uvic_embm
            elseif ( m .eq. iws ) then
              if (k .eq. 1) print*, 'surface wind speed'
              call get_sbc (n, 'data/ws_mth.nc', 'ws', id, im
     &,         0.01, 0.)

# endif
# if defined uvic_embm_astress &&  defined uvic_embm
            elseif ( m .eq. iwa ) then
              if (k .eq. 1) print*, 'surface wind angle'
              call get_sbc (n, 'data/wa_mth.nc', 'wa', id, im
     &,         0.01, 0.)

# endif
# if defined uvic_embm_adv_q &&  defined uvic_embm
            elseif ( m .eq. iwx ) then
              if (k .eq. 1) print*, 'x component of advecting wind'
              call get_sbc (n, 'data/wx_mth.nc', 'wx', id, im
     &,         0.01, 0.)

            elseif ( m .eq. iwy ) then
              if (k .eq. 1) print*, 'y component of advecting wind'
              call get_sbc (n, 'data/wy_mth.nc', 'wy', id, im
     &,         0.01, 0.)

# endif
# if defined shortwave
            elseif ( m .eq. ipsw ) then
              if (k .eq. 1) print*, 'penetrating shortwave radiation'
              call get_sbc (n, 'data/psw_mth.nc', 'psw', id, im
     &,         1., 0.)

# endif
            endif

          endif

        enddo
      enddo

      return
      end

      subroutine get_sbc (n, file, name, id, im, scalar, offset)

      implicit none

# include "param.h"
# include "csbc.h"
# include "ctdbc.h"

      character (*) :: file, name
      integer id, im, iou, n, ntrec
      real offset, scalar, time

      time = 0.
      ntrec = 1
      call openfile (file, time, ntrec, iou)
      call getvara (name, iou, imt*jmt, (/1,1,id/)
     &, (/imt,jmt,1/), obc(1,1,n,im), scalar, offset)
      call closefile (iou)
      n = n + 1

      return
      end

#else
      subroutine setatm
      return
      end

#endif
