      subroutine embm

!=======================================================================

!     The atmospheric energy mositure balance model (EMBM) is based
!     primarily on the work of Augustus Fanning.

!     Fanning, A.F. and A.J. Weaver, An atmospheric energy-moisture
!       balance model: climatology, interpentadal climate change,
!       and coupling to an ocean general circulation model,
!       J. Geophys. Res., 101, 15,111-15,128, 1996

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================

      implicit none

#if defined uvic_embm
# include "size.h"
# include "cembm.h"
# if !defined uvic_mom
#  include "tmngr.h"
# endif

      integer n

# if !defined uvic_mom
!-----------------------------------------------------------------------
!     update timestep counter, set corresponding model time, and set
!     time dependent logical switches which determine program flow.
!-----------------------------------------------------------------------

        itt = itt + 1
        call increment_time (dtatm)
        call set_time_switches

# endif
!-----------------------------------------------------------------------
!     increment counter and set the time step type
!-----------------------------------------------------------------------

      nats = nats + 1
      if (nats .gt. namix) then
        lf = 2
        dts = dtatm
        nats = 1
      else
        lf = 1
        dts = 2.0*dtatm
      endif

# if defined uvic_ice_cpts

!-----------------------------------------------------------------------
!     initialize a few things before each call to embm and ice
!-----------------------------------------------------------------------

      call init_ice_cpts (1, imt, 1, jmt)
# endif

      addflux = .true.
# if defined uvic_embm_even_fluxes && defined uvic_mom
      if (mod(nats,2) .ne. 0) addflux = .false.
# endif

!-----------------------------------------------------------------------
!     calculate fluxes at tau
!-----------------------------------------------------------------------

      call fluxes (1, imt, 1, jmt)
# if defined uvic_ice

!-----------------------------------------------------------------------
!     compute ice fluxes at tau and ice thickness and area at tau+1
!-----------------------------------------------------------------------

      call ice (1, imt, 1, jmt)
# endif

!-----------------------------------------------------------------------
!     compute atmospheric tracers at tau+1. start with humidity so that
!     the precipitation flux can be calculated for latent heat
!-----------------------------------------------------------------------

      call solve (2)
      call precipitate (1, imt, 1, jmt)
      call solve (1)
      do n=3,nat
        call solve (n)
      enddo

!-----------------------------------------------------------------------
!     calculate the total atmospheric fluxes for coupling
!-----------------------------------------------------------------------

      if (addflux) call sum_flux (1, imt, 1, jmt)
# if time_averages

!-----------------------------------------------------------------------
!     accumulate time average atmospheric data
!-----------------------------------------------------------------------

      if (addflux) call ta_atm_snap (1, imt, 1, jmt, 1)
# endif
# if defined time_step_monitor

!-----------------------------------------------------------------------
!     accumulate time average integral atmospheric data
!-----------------------------------------------------------------------

      if (addflux) call ta_atm_tsi (1)
# endif
# if !defined uvic_mom

!-----------------------------------------------------------------------
!     write output
!-----------------------------------------------------------------------

      call embmout (1, imt, 1, jmt)
# endif
#endif

      return
      end

      subroutine sum_flux (is, ie, js, je)

!=======================================================================
!     sum fluxes over atmospheric time steps
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================
#if defined uvic_embm

      implicit none

# include "param.h"
# include "cembm.h"
# include "atm.h"
# include "levind.h"
# if defined uvic_global_sums
#  include "coord.h"
#  include "grdvar.h"
# endif
# if defined uvic_ice_evp || defined uvic_old_albedo
#  include "ice.h"
# endif
# if defined uvic_ice_evp || defined uvic_embm_astress
#  include "csbc.h"
#  include "mapsbc.h"
# endif
# if defined ubc_cidm
#  include "subgrid.h"
# endif

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1

      real fa

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

      do j=jsp1,jem1
# if defined uvic_global_sums
        fa = dts*cst(j)*dyt(j)*1.0e-7
# endif
        do i=isp1,iem1
          if (kmt(i,j) .gt. 0) then
            flux(i,j,1) = flux(i,j,1) + dts*(dnswr(i,j) - uplwr(i,j)
     &                  - upltnt(i,j) - upsens(i,j))
# if defined ubc_cidm
     &                  - dts*avg_ltnt(i,j)
# endif
            flux(i,j,2) = flux(i,j,2) + dts*(precip(i,j) - evap(i,j))
# if defined ubc_cidm
     &                  + dts*avg_calv(i,j)
# endif
# if defined  uvic_ice_evp || defined uvic_embm_astress
            flux(i,j,nat+1) = flux(i,j,nat+1) + dts*sbcocn(i,j,itaux)
            flux(i,j,nat+2) = flux(i,j,nat+2) + dts*sbcocn(i,j,itauy)
# endif
# if defined uvic_ice_evp
            flux(i,j,nat+1) = flux(i,j,nat+1) + dts*xint(i,j)
            flux(i,j,nat+2) = flux(i,j,nat+2) + dts*yint(i,j)
# endif
          endif
# if defined uvic_embm_running_average || defined uvic_embm_astress
          atbar(i,j) = atbar(i,j) + dts*at(i,j,2,1)
# endif
# if defined uvic_global_sums
          dtoih = dtoih + fa*dxt(i)*(outlwr(i,j) - dnswr(i,j)
#  if defined uvic_old_albedo
#   if defined rot_grid
     &          - solins(i,j)*scatter*(a_calb(i,j) - 0.18*aice(i,j,1)))
#   else
     &          - solins(j)*scatter*(a_calb(i,j) - 0.18*aice(i,j,1)))
#   endif
#  else
#   if defined rot_grid
     &          - solins(i,j)*scatter*a_calb(i,j))
#   else
     &          - solins(j)*scatter*a_calb(i,j))
#   endif
#  endif
# endif
# if defined uvic_embm_adv_q
          accp(i,j) = accp(i,j) + dts*precip(i,j)
# endif
        enddo
      enddo

      totaltime = totaltime + dts
      avetime = avetime + dts
#endif

      return
      end
