      subroutine calc_astress (is, ie, js, je)

!=======================================================================
!     calculate anomolous pressure and geostrophic wind
!     based on code by a.fanning

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================
#if defined uvic_embm_astress && defined uvic_embm

      implicit none

# include "param.h"
# include "atm.h"
# if defined rot_grid
#  include "grdvar.h"
# else
#  include "coord.h"
# endif

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1, n

      real b, bc(11), press(is:ie,js:je), rd, s, sc(11), tc, tm

!     fit to ECMWF data
      data bc/  2.59709E-03, -5.76312E-06,  1.10314E-07,  9.27774E-09
     &,        -1.77340E-10, -3.05476E-12,  6.56141E-14,  3.68229E-16
     &,        -8.69663E-18, -1.51366E-20,  3.88660E-22 /

      data sc/ -4.74336E-06,  2.03583E-08, -3.47492E-10, -3.30436E-11
     &,         5.88653E-13,  1.10427E-14, -2.24471E-16, -1.34262E-18
     &,         3.01447E-20,  5.54779E-23, -1.35603E-24 /

!     fit to NCEP data
!      data bc/  2.55395e-03, -5.62127e-06,  2.31210e-07,  8.82642e-09
!     &,        -2.94558e-10, -2.89406e-12,  1.05941e-13,  3.29985e-16
!     &,        -1.39957e-17, -1.25170e-20,  6.27082e-22 /

!      data sc/ -4.60028e-06,  1.97907e-08, -7.63178e-10, -3.13384e-11
!     &,         9.97370e-13,  1.04143e-14, -3.65328e-16, -1.19479e-18
!     &,         4.85947e-20,  4.54453e-23, -2.18230e-24 /

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

!-----------------------------------------------------------------------
!     calculate sea level pressure (slp) from temperature
!     use the equation of state for an ideal gas, P=rho*R*T, and
!     assume a linear relationship between density and temperature
!     rho = s*T_c + b, where s in g/cm3/K, b in g/cm3 are latitudinal
!     dependent parameters and T_c is the temperature in Celsius
!     for the pressure anomoly use dP = R*(s*d(T**2) + b*dT)
!-----------------------------------------------------------------------

      rd = 287.0e4              ! ideal gas constant in cm^2/K/s^2
      do j=jsp1,jem1
        do i=isp1,iem1
          s = 0.
          b = 0.
          do n=1,11
# if defined rot_grid
            s = s + sc(n)*tlat(i,j)**(n-1)
            b = b + bc(n)*tlat(i,j)**(n-1)
# else
            s = s + sc(n)*yt(j)**(n-1)
            b = b + bc(n)*yt(j)**(n-1)
# endif
          enddo
          tm = rtbar(i,j) + 273.15
          tc = tbar(i,j) + 273.15
          press(i,j) = rd*(s*(tm**2 - tc**2) + b*(tm - tc))
        enddo
      enddo
      call embmbc (press)
      call geowind (0.8, press, awx, awy, is, ie, js, je)
#endif

      return
      end

      subroutine add_astress (is, ie, js, je)

!=======================================================================
!     update winds

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================
#if defined uvic_embm_astress && defined uvic_embm

      implicit none

# include "param.h"
# include "atm.h"
# include "cembm.h"
# include "csbc.h"
# include "mapsbc.h"

      integer i, ie, is, j, je, js

      real drag, tmag, x, y, s

      drag = cdatm*rhoatm
      do j=js,je
        do i=is,ie
!         advection winds
          sbcocn(i,j,iwx) = sbcocn(i,j,iwx) + awx(i,j)
          sbcocn(i,j,iwy) = sbcocn(i,j,iwy) + awy(i,j)
!         wind speed
          x = cos(sbcocn(i,j,iwa))*sbcocn(i,j,iws) + awx(i,j)
          y = sin(sbcocn(i,j,iwa))*sbcocn(i,j,iws) + awy(i,j)
          sbcocn(i,j,iws) = sqrt(x**2 + y**2)
!         wind stress
          tmag = sqrt(sqrt(sbcocn(i,j,itaux)**2
     &         + sbcocn(i,j,itauy)**2)/drag) + epsln
          x = sbcocn(i,j,itaux)/drag/tmag + awx(i,j)
          y = sbcocn(i,j,itauy)/drag/tmag + awy(i,j)
          s = sqrt(x**2 + y**2)
          sbcocn(i,j,itaux) = drag*x*s
          sbcocn(i,j,itauy) = drag*y*s
        enddo
      enddo
#endif

      return
      end

      subroutine geowind (contr, press, ugr, vgr, is, ie, js, je)

!=======================================================================
!     calculate the geostrophic velocities on uv grid (cm/s)

!     author:   m.eby   e-mail: eby@uvic.ca
!=======================================================================
#if defined uvic_embm_astress && defined uvic_embm

      implicit none

# include "param.h"
# include "coord.h"
# include "grdvar.h"
# include "scalar.h"
# include "cembm.h"
# include "atm.h"

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1

      real adpdx, adpdy, angle, const, contr, cosa, diag0, diag1
      real rlat, rnot, sina, ug, vg
      real press(is:ie,js:je), ugr(is:ie,js:je), vgr(is:ie,js:je)

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

      angle = 20.0/radian   ! turning angle (from Gill 1982 p.328)
      rnot = 1.0/3600.0     ! time scale for equatorial damping (1 hr)

      cosa = cos(angle)
      sina = sin(angle)

      do j=jsp1,jem1
# if !defined rot_grid
        rlat = rnot*exp(-((yu(j)/15.0)**2.0))
        const = contr/(rhoatm*(rlat**2 + fcor(j)**2))
           sina = sign(sina, yu(j))
# endif
        do i=isp1,iem1
            diag1 = 0.
            diag0 = 0.
            diag1 = diag1 + press(i+1,j+1) - press(i,j)
            diag0 = diag0 + press(i,j+1) - press(i+1,j)
            adpdy  = (diag1 + diag0)*dyu2r(j)
            adpdx  = (diag1 - diag0)*dxu2r(i)*cstr(j)
# if defined rot_grid
            rlat = rnot*exp(-((ulat(i,j)/15.0)**2.0))
            const = contr/(rhoatm*(rlat**2 + fcor(i,j)**2))
            sina = sign(sina, ulat(i,j))
            vg =  const*(fcor(i,j)*adpdx - rlat*adpdy)
            ug = -const*(rlat*adpdx + fcor(i,j)*adpdy)
# else
            vg =  const*(fcor(j)*adpdx - rlat*adpdy)
            ug = -const*(rlat*adpdx + fcor(j)*adpdy)
# endif
            ugr(i,j) = ug*cosa - vg*sina
            vgr(i,j) = ug*sina + vg*cosa
        enddo
      enddo

      call embmbc (ugr)
      call embmbc (vgr)

#endif

      return
      end
