      subroutine convect_brine (joff, js, je, is, ie)

!-----------------------------------------------------------------------
!     solve for brine rejection for each ice category and mix S & T.
!     the brine is first rejected to some depth, defined by
!     potential density difference from the previous time step
!     between the surface and the depth. then convective mixing
!     is applied under each category to both T & S.

!     input:
!       joff = offset relating "j" in the MW to latitude "jrow"
!       js   = starting row in the MW
!       je   = ending row in the MW
!       is   = starting longitude index in the MW
!       ie   = ending longitude index in the MW
!-----------------------------------------------------------------------

#if defined uvic_convect_brine
# include "param.h"
# include "levind.h"
# include "mw.h"
# include "cembm.h"
# include "ice.h"
# include "coord.h"
# include "accel.h"
# include "scalar.h"
# include "state.h"
#if !defined uvic_no_statfunc
# include "dens.h"
#endif

      dimension tr(km,nt), trs(km,nt)

      cont = 0.  ! density contrast to mix brine over (g/cm^3)

      do j=js,je
        jrow = j + joff
        do i=is,ie

          if (cba0(i,jrow) .eq. 1.0) then
!           if no brine flux at all convect entire cell
            call convct2 (t(i,:,j,:,taup1), joff, j, j, i, i, kmt)
          else

            if (cba0(i,jrow) .ne. 0.0) then
!             convect the area with no brine flux
              tr(:,:) = t(i,:,j,:,taup1)
              call convct2 (ts, joff, 1, 1, 1, 1, kmt)
              trs(:,:) = tr(:,:)*cba0(i,jrow)
            else
              trs(:,:) = 0.0
            endif

            do nc=0,ncat
              if (cba(i,jrow,nc) .ne. 0.) then
!               convect areas with brine flux
                tr(:,:) = t(i,:,j,:,taup1)
                kl = 1
                if (cont .gt. 0) then
!                 find level over which to spread the flux
                    tq = tr(kl,1) - to(1)
                    sq = tr(kl,2) - so(1)
                    r1 = dens (tr(kl,1)-to(1), tr(kl,2)-so(1), 1)
                  dr = 0.
                  do while (dr .le. cont .and. kl .lt. kmt(i,jrow))
                    kl = kl + 1
                    dr = dens (tr(kl,1)-to(1), tr(kl,2)-so(1), 1) - r1
                  enddo
                endif
                dtcbfdzw = c2dtts*cbf(i,jrow,nc)/zw(kl)
                tr(1:kl,2) = tr(1:kl,2) + dtxcel(1:kl)*dtcbfdzw

                call convct2 (ts, joff, j, j, i, i, kmt)
                trs(:,:) = trs(:,:) + tr(:,:)*cba(i,jrow,nc)
              endif
            enddo
            t(i,:,j,:,taup1) = trs(:,:)

          endif

        enddo
        do n=1,nt
          call setbcx (t(1,1,j,n,taup1), imt, km)
        enddo
      enddo

#endif
      return
      end
