      subroutine diag (joff, js, je, is, ie)

!=======================================================================
!     calculate diagnostics

!     input:

!      joff   = offset between row j in the MW and latitude jrow on disk
!      js     = starting row for calculations
!      je     = ending row for calculations
!      is     = starting longitude index for calculations
!      ie     = ending longitude index for calculations
!=======================================================================

#include "param.h"
#include "coord.h"
#if defined matrix_sections
# include "cprnts.h"
#endif
#include "cregin.h"
#include "diag.h"
#include "diaga.h"
#include "docnam.h"
#include "grdvar.h"
#include "iounit.h"
#include "isopyc.h"
#include "mw.h"
#include "scalar.h"
#include "switch.h"
#include "tmngr.h"
#include "vmixc.h"
# include "levind.h"
# include "emode.h"

      character(80) :: fsnap, file_stamp
      save fsnap
      data fsnap /' '/

      integer ntrec

#if defined meridional_overturning
# if defined uvic_regional_overturning
      dimension vbarx(km,0:nhreg)
# else
      dimension vbarx(km)
# endif
#endif
#if defined isopycmix
      dimension aibuf(imt,km)
#endif

!-----------------------------------------------------------------------
!     bail out if starting row exceeds ending row
!-----------------------------------------------------------------------

      if (js .gt. je) return

!-----------------------------------------------------------------------
!     limit longitudes
!-----------------------------------------------------------------------

      istrt  = max(2,is)
      iend   = min(imt-1,ie)

      do j=js,je
        jrow = joff + j

#if defined time_averages

!-----------------------------------------------------------------------
!       diagnostic: accumulate "tau" data for time means
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (timavgperts .and. .not. euler2) then
          if (istrt .ne. 2 .and. iend .ne. imt-1) then
            write (stdout,*) '=>Error: istrt = ',istrt,' and iend ='
     &,     iend,' are not allowed when calling "avgvar"'
            stop '=>diag'
          else
            call avgvar (j, jrow, adv_vbt(1,1,j), u(1,1,1,1,tau)
     &,                  t(1,1,1,1,tau), stf, smf)
          endif
        endif
#endif

#if defined snapshots

!-----------------------------------------------------------------------
!       diagnostic: write instantaneous sample of MOM data
!       author:    r.c.pacanowski   e-mail  rcp@gfdl.gov
!                  a. rosati        e-mail  ar@gfdl.gov
!-----------------------------------------------------------------------

        if (snapts .and. .not. euler2) then
          ntrec = 1
          if (jrow .eq. 2) then
            if (fsnap .eq. ' ') ntrec = 0
# if defined uvic_io_multiple_files
            fsnap = file_stamp('socn',stamp,'.nc')
# elif defined uvic_io_single_file
            fsnap = 'snapshots.nc'
# else
            if (fsnap .eq. ' ')
     &        fsnap = file_stamp('snapshots',stamp,'.nc')
# endif
          endif
          avgper = 0.
          is = 1
          ie = imt
          call ocn_snap_out (fsnap, is, ie, jrow, jrow, imt, jmt, km, nt
     &,                      xt, yt, zt, xu, yu, zw, dxt, dyt, dzt, dxu
     &,                      dyu, dzw, ntrec, timunit, expnam, avgper
     &,                      relyr, stamp, t(is:ie,1:km,j,1:nt,tau)
     &,                      u(is:ie,1:km,j,1,tau)
     &,                      u(is:ie,1:km,j,2,tau)
     &,                      adv_vbt(is:ie,1:km,j), stf(is:ie,j,1:nt)
     &,                      smf(is:ie,j,1), smf(is:ie,j,2)
# if defined isopycmix && defined gent_mcwilliams
     &,                      adv_vetiso(is:ie,1:km,j)
     &,                      adv_vntiso(is:ie,1:km,j)
     &,                      adv_vbtiso(is:ie,1:km,j)
# endif
# if defined rigid_lid_surface_pressure || defined implicit_free_surface
     &,                      ps(is:ie,jrow,1)
# endif
# if defined stream_function
     &,                      psi(is:ie,jrow,1)
# endif
# if defined rot_grid
     &,                      tlat(is:ie,js:je), tlon(is:ie,js:je)
     &,                      ulat(is:ie,js:je), ulon(is:ie,js:je)
# endif
     &,                      kmt(is:ie,jrow), mskhr(is:ie,jrow)
     &,                      tmask(is:ie,1:km,j), umask(is:ie,1:km,j))

          if (jrow .eq. 2)
     &      write (*,'(a,i4,a,a,a,i10,a,a)') '=> Ocn snapshot #', ntrec
     &,        ' written to ',trim(fsnap),' on ts = ',itt, ', ', stamp
        endif
#endif

#if defined stability_tests

!-----------------------------------------------------------------------
!       diagnostic: compute stability diagnostics
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (stabts .and. eots) then
          if (istrt .ne. 2 .and. iend .ne. imt-1) then
            write (stdout,*) '=>Error: istrt = ',istrt,' and iend ='
     &,     iend,' are not allowed when calling "stab"'
            stop '=>diag'
          else
            call stab (j, jrow)
          endif
        endif
#endif

#if defined trajectories

!-----------------------------------------------------------------------
!       diagnostic: integrate particle trajectories
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (eots) then
          if (istrt .ne. 2 .and. iend .ne. imt-1) then
            write (stdout,*) '=>Error: istrt = ',istrt,' and iend ='
     &,     iend,' are not allowed when calling "ptraj"'
            stop '=>diag'
          else
            call ptraj (j, jrow)
          endif
        endif
#endif

#if defined meridional_overturning

!-----------------------------------------------------------------------
!       construct meridional overturning of mass
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (jrow .lt. jmtm1 .and. vmsfts .and. eots) then
# if defined uvic_regional_overturning && defined time_averages
#  if defined uvic_regional_overturning_timavgper && defined time_averages
          if (timavgperts) then
!         calculate mot streamfunction only for time averaging period
#  endif
          do nr=0,nhreg
            do k=1,km
              vbarx(k,nr) = c0
            enddo
          enddo

          do k=1,km
            do i=istrt,iend
              nr = mskhr(i,jrow)
              vx = u(i,k,j,2,tau)*csu(jrow)*dxu(i)
              vbarx(k,0) = vbarx(k,0) + vx
              if (nr .gt. 0) vbarx(k,nr) = vbarx(k,nr) + vx
            enddo
            do nr=0,nhreg
              vx = vbarx(k,nr)*dzt(k)
              if (k .eq. 1) then
                vmsf(jrow,k,nr) = vx
              else
                vmsf(jrow,k,nr) = vmsf(jrow,k-1,nr) + vx
              endif
            enddo
          enddo
#  if defined uvic_regional_overturning_timavgper && defined time_averages
          endif
#  endif
# else
          do k=1,km
            vbarx(k) = c0
          enddo

          do k=1,km
            do i=istrt,iend
              vbarx(k) = vbarx(k) + u(i,k,j,2,tau)*csu(jrow)*dxu(i)
            enddo
            if (k .eq. 1) then
              vmsf(jrow,k) = vbarx(k)*dzt(k)
            else
              vmsf(jrow,k) = vmsf(jrow,k-1) + vbarx(k)*dzt(k)
            endif
          enddo
# endif
        endif
#endif

#if defined show_zonal_mean_of_sbc

!-----------------------------------------------------------------------
!       construct zonal mean of surface b.c. and related items
!       author:  r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

        if (zmbcts .and. eots) then
          zmau(jrow) = c0
          zmat(jrow) = c0
          do i=istrt,iend
            zma1            = umask(i,1,j)*csu(jrow)*dxu(i)*dyu(jrow)
            zmau(jrow)      = zmau(jrow)    + zma1
            zmsmf(jrow,1)   = zmsmf(jrow,1) + zma1*smf(i,j,1)
            zmsmf(jrow,2)   = zmsmf(jrow,2) + zma1*smf(i,j,2)
            zmsm(jrow,1)    = zmsm(jrow,1)  + zma1*u(i,1,j,1,tau)
            zmsm(jrow,2)    = zmsm(jrow,2)  + zma1*u(i,1,j,2,tau)
            zma2            = tmask(i,1,j)*cst(jrow)*dxt(i)*dyt(jrow)
            zmat(jrow)      = zmat(jrow) + zma2
            do n=1,nt
              zmstf(jrow,n) = zmstf(jrow,n) + zma2*stf(i,j,n)
              zmst(jrow,n)  = zmst(jrow,n)  + zma2*t(i,1,j,n,tau)
            enddo
          enddo
        endif
#endif

#if defined matrix_sections

!-----------------------------------------------------------------------
!       print "tau" (not "tau+1") variables  at specified latitudes

!       author:    r.c.pacanowski   e-mail  rcp@gfdl.gov
!                  a. rosati        e-mail  ar@gfdl.gov
!       based on previous code by M. Cox
!-----------------------------------------------------------------------

        if (prxzts .and. eots) then
          reltim = relyr
          do jlat=1,nlatpr
            jj = indp (prlat(jlat), yt, jmt)
            if (jj .eq. jrow .and. prlat(jlat) .le. yt(jmt))
     &        then
              is = indp (prslon(jlat), xt, imt)
              ie = indp (prelon(jlat), xt, imt)
              ks = indp (prsdpt(jlat), zt, km)
              ke = indp (predpt(jlat), zt, km)
              fx = 1.0e-2
              if (jlat .eq. 1) write(stdout,9000)
              do m=1,nt
                scl = c1
                if (m .eq. 2) scl=1.e-3
                if (ioprxz .eq. stdout .or. ioprxz .lt. 0) then
                  write (stdout,9100) trname(m), itt, jrow
     &,           yt(jrow), xt(is), xt(ie), fx*zt(ks), fx*zt(ke), scl
                  call matrix (t(1,1,j,m,tau), imt, is, ie, ks, ke, scl)
                endif
                if (ioprxz .ne. stdout .or. ioprxz .lt. 0) then

                  call getunit (io, 'sections.dta'
     &,                        'unformatted sequential append ieee')

                  write (stdout,*) ' =>Zonal ',trname(m), ' slice: lat='
     &,           yt(jrow), ' written unformatted to file sections.dta'
     &,           ' on ts=', itt, stamp
                  write (stdout,'(///)')
                  iotext = ' read (ioprxz) imt, km, m, nt, reltim'
                  write (io) stamp, iotext, expnam
                  write (io) imt, km, m, nt, reltim
                  write(iotext,'(a10,i4,a4,i2)') ' for jrow=',jrow
     &,           '  m=',m
                  iotext(18:)=':read(ioprxz)((t(i,k,m),i=1,imt),k=1,km)'
                  write (io) stamp, iotext, expnam
                  call wrufio (io, t(1,1,j,m,tau), imt*km)

                  call relunit (io)

                endif
              enddo
              scl = 1.e-3
              if (ioprxz .eq. stdout .or. ioprxz .lt. 0) then
                i1 = max(is,2)
                i2 = min(ie,imtm1)
                write (stdout,9100)  'adv_vbu ', itt, jrow
     &,         yt(jrow), xt(i1), xt(i2), fx*zw(ks), fx*zw(ke), scl
                call matrix (adv_vbu(1,1,j), imt, i1, i2, ks, ke, scl)
                write (stdout,9100)  'adv_vbt ', itt, jrow
     &,         yt(jrow), xt(i1), xt(i2), fx*zw(ks), fx*zw(ke), scl
                call matrix (adv_vbt(1,1,j), imt, i1, i2, ks, ke, scl)
              endif
              if (ioprxz .ne. stdout .or. ioprxz .lt. 0) then

                call getunit (io, 'sections.dta'
     &,                      'unformatted sequential append ieee')

                write (stdout,*) ' => Zonal adv_vbu slice: lat='
     &,         yt(jrow), ' written unformatted to file sections.dta'
     &,         ' on ts=', itt, stamp
                write (stdout,'(///)')
                iotext = ' read (ioprxz) imt, km, reltim'
                write (io) stamp, iotext, expnam
                write (io) imt, km, reltim
                write(iotext,'(a10,i4)') ' for jrow=',jrow
                iotext(12:)=
     &          ': read(ioprxz)((adv_vbu(i,k),i=1,imt),k=0,km)'
                write (io) stamp, iotext, expnam
                call wrufio (io, adv_vbu(1,0,j), imt*(km+1))

                write (stdout,*) ' => Zonal adv_vbt slice: lat='
     &,         yt(jrow), ' written unformatted to file sections.dta'
     &,         ' on ts=', itt, stamp
                write (stdout,'(///)')
                iotext = ' read (ioprxz) imt, km, reltim'
                write (io) stamp, iotext, expnam
                write (io) imt, km, reltim
                write(iotext,'(a10,i4)') ' for jrow=',jrow
                iotext(12:)=
     &          ': read(ioprxz)((adv_vbt(i,k),i=1,imt),k=1,km)'
                write (io) stamp, iotext, expnam
                call wrufio (io, adv_vbt(1,0,j), imt*(km+1))

                call relunit (io)

              endif

              scl = c1
              if (ioprxz .eq. stdout .or. ioprxz .lt. 0) then
                write (stdout,9100) 'u velocity', itt
     &,        jrow, yt(jrow), xt(is), xt(ie), fx*zt(ks), fx*zt(ke), scl
                call matrix (u(1,1,j,1,tau), imt, is, ie, ks, ke, scl)
              endif
              if (ioprxz .ne. stdout .or. ioprxz .lt. 0) then

                call getunit (io, 'sections.dta'
     &,                      'unformatted sequential append ieee')

                write (stdout,*) ' => Zonal u velocity slice: lat='
     &,         yt(jrow), ' written unformatted to file sections.dta'
     &,         ' on ts=', itt, stamp
                write (stdout,'(///)')
                iotext = ' read (ioprxz) imt, km, reltim'
                write (io) stamp, iotext, expnam
                write (io) imt, km, reltim
                write(iotext,'(a10,i4)') ' for jrow=',jrow
                iotext(12:) = ': read (ioprxz)((u(i,k),i=1,imt),k=1,km)'
                write (io) stamp, iotext, expnam
                call wrufio (io, u(1,1,j,1,tau), imt*km)

                call relunit (io)

              endif

              scl = c1
              if (ioprxz .eq. stdout .or. ioprxz .lt. 0) then
                write (stdout,9100) 'v velocity', itt, jrow
     &,         yt(jrow), xt(is), xt(ie), fx*zt(ks), fx*zt(ke), scl
                call matrix (u(1,1,j,2,tau), imt, is, ie, ks, ke, scl)
              endif
              if (ioprxz .ne. stdout .or. ioprxz .lt. 0) then

                call getunit (io, 'sections.dta'
     &,                      'unformatted sequential append ieee')

                write (stdout,*) ' => Meridional v velocity slice: lat='
     &,         yt(jrow),' written unformatted to file sections.dta'
     &,          ' on ts=', itt, stamp
                write (stdout,'(///)')
                iotext = ' read (ioprxz) imt, km, reltim'
                write (io) stamp, iotext, expnam
                write (io) imt, km, reltim
                write(iotext,'(a10,i4)') ' for jrow=',jrow
                iotext(12:) = ': read (ioprxz)((v(i,k),i=1,imt),k=1,km)'
                write (io) stamp, iotext, expnam
                call wrufio (io, u(1,1,j,2,tau), imt*km)

                call relunit (io)

              endif
            endif
          enddo
        endif
9000    format(/' Zonal section printouts at specified latitudes:'/)
9100    format(1x,a12,1x,'ts=',i10,1x,',j=',i3,', lat=',f6.2
     &,', lon:',f6.2,' ==> ',f6.2,', depth(m):',f6.1,' ==> ',f6.1
     &,', scaling=',1pg10.3)
#endif
      enddo

#if defined save_mixing_coeff

!-----------------------------------------------------------------------
!     diagnostic: save estimated mixing coefficients on east, north, and
!                 bottom face of T and U cells

!     author:   R. C. Pacanowski       e-mail rcp@gfdl.gov
!-----------------------------------------------------------------------

      if (cmixts .and. eots) then

        reltim = relyr
        if (joff + js .eq. 2) then
          write (stdout,*) ' =>Writing mixing coefficients at ts=',itt
     &  , ' ',stamp
          call getunit (iocm, 'cmix.dta'
     &,                'unformatted sequential append ieee')

          period = 0.0
          iotext = 'read(iocm) reltim, period, imt, jmt, km'
          write (iocm) stamp, iotext, expnam
          write (iocm) reltim, period, imt, jmt, km

          iotext = 'read(iocm) (xt(i),i=1,imt)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, xt, imt)

          iotext = 'read(iocm) (yt(j),j=1,jmt)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, yt, jmt)

          iotext = 'read(iocm) (zt(k),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, zt, km)

          iotext = 'read(iocm) (xu(i),i=1,imt)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, xu, imt)

          iotext = 'read(iocm) (yu(j),j=1,jmt)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, yu, jmt)

          iotext = 'read(iocm) (zw(k),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, zw, km)

          call relunit (iocm)
        endif

        call getunit (iocm, 'cmix.dta'
     &,               'unformatted sequential append ieee')

        do j=js,je
          jrow = j+joff

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (diff_ceu(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, ce(1,1,j,1), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (diff_cnu(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, cn(1,1,j,1), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (diff_cbu(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, cb(1,1,j,1), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (diff_cet(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, ce(1,1,j,2), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (diff_cnt(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, cn(1,1,j,2), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (diff_cbt(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          call wrufio (iocm, cb(1,1,j,2), imt*km)

# if defined isopycmix

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (Ai_ez(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          do k=1,km
            do i=1,imt
              aibuf(i,k) = 0.25*(Ai_ez(i,k,j,0,1) + Ai_ez(i,k,j,0,0)
     &                         + Ai_ez(i,k,j,1,1) + Ai_ez(i,k,j,1,0))
            enddo
          enddo
          call wrufio (iocm, aibuf(1,1), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (Ai_nz(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          do k=1,km
            do i=1,imt
              aibuf(i,k) = 0.25*(Ai_nz(i,k,j,0,1) + Ai_nz(i,k,j,0,0)
     &                         + Ai_nz(i,k,j,1,1) + Ai_nz(i,k,j,1,0))
            enddo
          enddo
          call wrufio (iocm, aibuf(1,1), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (Ai_bx(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          do k=1,km
            do i=1,imt
              aibuf(i,k) = 0.25*(Ai_bx(i,k,j,0,0) + Ai_bx(i,k,j,1,0)
     &                         + Ai_bx(i,k,j,0,1) + Ai_bx(i,k,j,1,1))
            enddo
          enddo
          call wrufio (iocm, aibuf(1,1), imt*km)

          write(iotext,'(a10,i4)') ' for jrow=',jrow
          iotext(15:) = ': read (iocm) (Ai_by(i,k),i=1,imt),k=1,km)'
          write (iocm) stamp, iotext, expnam
          do k=1,km
            do i=1,imt
              aibuf(i,k) = 0.25*(Ai_by(i,k,j,0,0) + Ai_by(i,k,j,1,0)
     &                         + Ai_by(i,k,j,0,1) + Ai_by(i,k,j,1,1))
            enddo
          enddo
          call wrufio (iocm, aibuf(1,1), imt*km)
# endif
        enddo
        call relunit(iocm)
      endif
#endif

#if defined save_cross_flow

!-----------------------------------------------------------------------
!     diagnostic: compute diapycnal and isopycnal components of flow

!     author:    r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

!      if (crossts .and. .not. euler2) then
!        reltim = relyr
!        call flow_comp (joff, js, je, 'cross.dta.nc'
!     &,                    reltim, itt, pstamp)
!      endif
#endif

#if defined save_density

!-----------------------------------------------------------------------
!       diagnostic: write instantaneous density data
!       author:    r.c.pacanowski   e-mail  rcp@gfdl.gov
!-----------------------------------------------------------------------

!      if (densityts .and. .not. euler2) then
!        reltim = relyr
!        call save_density (joff, js, je, 'density.dta.nc'
!     &,                    reltim, itt, pstamp)
!      endif
#endif

      return
      end
