!=======================================================================
!     finite difference numerics for momentum
!=======================================================================
#if defined  uvic_no_statfunc

!-----------------------------------------------------------------------
!     advective terms
!-----------------------------------------------------------------------

      function ADV_Ux (i,k,j)
# include "param.h"
# include "mw.h"
# if defined linearized_advection
      ADV_Ux = 0.0
# else
      ADV_Ux = (adv_fe(i,k,j) - adv_fe(i-1,k,j))*csudxu2r(i,j)
# endif
      return
      end

      function ADV_Uy (i,k,j,jrow,n)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# if defined linearized_advection
      ADV_Uy = 0.0
# else
      ADV_Uy = (adv_vnu(i,k,j)*(u(i,k,j,n,tau) + u(i,k,j+1,n,tau))
     &       - adv_vnu(i,k,j-1)*(u(i,k,j-1,n,tau) + u(i,k,j,n,tau))
     &         )*csudyu2r(jrow)
# endif
      return
      end

      function ADV_Uz (i,k,j)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# if defined linearized_advection
      ADV_Uz = 0.0
# else
      ADV_Uz = (adv_fb(i,k-1,j) - adv_fb(i,k,j))*dzt2r(k)
# endif
      return
      end

      function ADV_metric (i,k,j,jrow,n)
# include "param.h"
# include "mw.h"
# if defined linearized_advection
      ADV_metric = 0.0
# else
      ADV_metric = advmet(jrow,n)*u(i,k,j,1,tau)*u(i,k,j,3-n,tau)
# endif
      return
      end

!-----------------------------------------------------------------------
!     diffusive terms
!-----------------------------------------------------------------------

      function DIFF_Ux (i,k,j)
# include "param.h"
# include "mw.h"
      DIFF_Ux = (diff_fe(i,k,j) - diff_fe(i-1,k,j))*csudxur(i,j)
      return
      end

      function DIFF_Uz(i,k,j)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# include "vmixc.h"
      DIFF_Uz = (diff_fb(i,k-1,j) - diff_fb(i,k,j))*dztr(k)
# if defined implicitvmix
     &          *(c1-aidif)
# endif
      return
      end

      function DIFF_Uy (i,k,j,jrow,n)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# include "hmixc.h"
# include "cnep.h"
# if defined consthmix && !defined biharmonic
#  if defined neptune
      DIFF_Uy = amc_north(jrow)*(u(i,k,j+1,n,taum1) - u(i,k,j,n,taum1)
     $        - unep(i,jrow+1,n)*umask(i,k,j+1)
     $        + unep(i,jrow,n)*umask(i,k,j))
     &        - amc_south(jrow)*(u(i,k,j,n,taum1) - u(i,k,j-1,n,taum1)
     $        - unep(i,jrow,n)*umask(i,k,j)
     $        + unep(i,jrow-1,n)*umask(i,k,j-1))
#  else
      DIFF_Uy = amc_north(jrow)*(u(i,k,j+1,n,taum1) - u(i,k,j,n,taum1))
     &        - amc_south(jrow)*(u(i,k,j,n,taum1) - u(i,k,j-1,n,taum1))
#  endif
# else
      DIFF_Uy = (diff_fn(i,k,j) - diff_fn(i,k,j-1))*csudyur(jrow)
# endif
      return
      end

      function DIFF_metric (i,k,j,jrow,n)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# include "hmixc.h"
# include "cnep.h"
# if defined consthmix
#  if defined  biharmonic
      DIFF_metric = am3(jrow)*del2(i,k,j,n) + am4(jrow,n)*
     &              (del2(i+1,k,j,3-n) - del2(i-1,k,j,3-n))*dxmetr(i)
#  else
#   if defined neptune
      DIFF_metric = am3(jrow)*(u(i,k,j,n,taum1) -
     $            - unep(i,jrow,n)*umask(i,k,j))
     &            + am4(jrow,n)*dxmetr(i)*
     &             (u(i+1,k,j,3-n,taum1) - u(i-1,k,j,3-n,taum1)
     $            - unep(i+1,jrow,3-n)*umask(i+1,k,j)
     $            + unep(i-1,jrow,3-n)*umask(i-1,k,j))
#   else
      DIFF_metric = am3(jrow)*u(i,k,j,n,taum1)
     &            + am4(jrow,n)*dxmetr(i)
     &              *(u(i+1,k,j,3-n,taum1) - u(i-1,k,j,3-n,taum1))
#   endif
#  endif
# endif
# if defined smagnlmix
      DIFF_metric = smag_metric(i,k,j)
# endif
      return
      end

!-----------------------------------------------------------------------
!     coriolis term
!-----------------------------------------------------------------------

      function CORIOLIS (i,k,j,jrow,n)
# include "param.h"
# include "mw.h"
# include "scalar.h"
# if defined rot_grid
#  if defined stream_function
#   if defined damp_inertial_oscillation
      CORIOLIS = (c1-acor)*cori(i,jrow,n)*u(i,k,j,3-n,taum1)
#   else
      CORIOLIS = cori(i,jrow,n)*u(i,k,j,3-n,tau)
#   endif
#  else
      CORIOLIS = cori(i,jrow,n)*(gcor*u(i,k,j,3-n,tau)
     &         + (c1-gcor)*u(i,k,j,3-n,taum1))
#  endif
# else
#  if defined stream_function
#   if defined damp_inertial_oscillation
      CORIOLIS = (c1-acor)*cori(jrow,n)*u(i,k,j,3-n,taum1)
#   else
      CORIOLIS = cori(jrow,n)*u(i,k,j,3-n,tau)
#   endif
#  else
      CORIOLIS = cori(jrow,n)*(gcor*u(i,k,j,3-n,tau)
     &         + (c1-gcor)*u(i,k,j,3-n,taum1))
#  endif
# endif
#else
      subroutine fdifm
#endif
      return
      end
