!=======================================================================
!     finite difference numerics for tracers
!=======================================================================
#if defined uvic_no_statfunc

!-----------------------------------------------------------------------
!     advective terms
!-----------------------------------------------------------------------

      function ADV_Tx (i,k,j)
# include "param.h"
# include "mw.h"
# if defined linearized_advection
      ADV_Tx = 0.0
# else
      ADV_Tx = (adv_fe(i,k,j) - adv_fe(i-1,k,j))*cstdxt2r(i,j)
# endif
      return
      end

      function ADV_Ty (i,k,j,jrow,n)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# if defined linearized_advection
      ADV_Ty = 0.0
# else
#  if defined fourth_order_tracer_advection || defined quicker
      ADV_Ty =(adv_f4n(i,k,j,n) - adv_f4n(i,k,j-1,n))*cstdyt2r(jrow)
#  else
#   if defined fct
      ADV_Ty = (adv_fn(i,k,j) - adv_fn(i,k,j-1))*cstdyt2r(jrow)
#   else
      ADV_Ty = (adv_vnt(i,k,j)*(t(i,k,j,n,tau)+t(i,k,j+1,n,tau))
     &       - adv_vnt(i,k,j-1)*(t(i,k,j-1,n,tau)+t(i,k,j,n,tau))
     &         )*cstdyt2r(jrow)
#   endif
#  endif
# endif
      return
      end

      function ADV_Tz(i,k,j)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
      ADV_Tz = (adv_fb(i,k-1,j) - adv_fb(i,k,j))*dzt2r(k)
      return
      end

# if defined gent_mcwilliams
!     gent_mcwilliams isopycnal advective terms simulating the effect
!     of eddies on the isopycnals

      function ADV_Txiso(i,k,j,n)
#  include "param.h"
#  include "mw.h"
#  include "isopyc.h"
      ADV_Txiso = cstdxt2r(i,j)*(adv_vetiso(i,k,j)*(t(i+1,k,j,n,taum1)
     &          + t(i,k,j,n,taum1)) - adv_vetiso(i-1,k,j)*
     &           (t(i,k,j,n,taum1) + t(i-1,k,j,n,taum1)))
      return
      end

      function ADV_Tyiso(i,k,j,jrow,n)
#  include "param.h"
#  include "mw.h"
#  include "isopyc.h"
#  include "grdvar.h"
      ADV_Tyiso = cstdyt2r(jrow)*(adv_vntiso(i,k,j)*(t(i,k,j+1,n,taum1)
     &          + t(i,k,j,n,taum1)) - adv_vntiso(i,k,j-1)*
     &                   (t(i,k,j,n,taum1) + t(i,k,j-1,n,taum1)))
      return
      end

      function ADV_Tziso(i,k,j)
#  include "param.h"
#  include "mw.h"
#  include "isopyc.h"
#  include "grdvar.h"
      ADV_Tziso = dzt2r(k)*(adv_fbiso(i,k-1,j) - adv_fbiso(i,k,j))
      return
      end

# endif
!-----------------------------------------------------------------------
!     diffusive terms
!-----------------------------------------------------------------------

!     zonal component

      function DIFF_Tx(i,k,j)
# include "param.h"
# include "mw.h"
      DIFF_Tx = (diff_fe(i,  k,j)*tmask(i+1,k,j)
     &        - diff_fe(i-1,k,j)*tmask(i-1,k,j))*cstdxtr(i,j)
      return
      end

!     meridional component

      function DIFF_Ty(i,k,j,jrow,n)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# include "hmixc.h"
# if defined consthmix && !defined biharmonic && !defined isopycmix
#  if defined bryan_lewis_horizontal
      DIFF_Ty = ahc_north(jrow,k)*tmask(i,k,j+1)*
     &         (t(i,k,j+1,n,taum1) - t(i,k,j,n,taum1))
     &        - ahc_south(jrow,k)*tmask(i,k,j-1)*
     &         (t(i,k,j,n,taum1) - t(i,k,j-1,n,taum1))
#  else
      DIFF_Ty = ahc_north(jrow)*tmask(i,k,j+1)*
     &         (t(i,k,j+1,n,taum1) - t(i,k,j,n,taum1))
     &        - ahc_south(jrow)*tmask(i,k,j-1)*
     &         (t(i,k,j,n,taum1) - t(i,k,j-1,n,taum1))
#  endif
# else
      DIFF_Ty = (diff_fn(i,k,j  )*tmask(i,k,j+1)
     &        - diff_fn(i,k,j-1)*tmask(i,k,j-1))*cstdytr(jrow)
# endif
      return
      end

!     vertical component

      function DIFF_Tz(i,k,j)
# include "param.h"
# include "mw.h"
# include "grdvar.h"
# if defined implicitvmix || defined isopycmix
#  include "vmixc.h"
# endif
      DIFF_Tz = (diff_fb(i,k-1,j) - diff_fb(i,k,j))*dztr(k)
# if defined implicitvmix || defined isopycmix
     &          *(c1-aidif)
# endif
# if defined isopycmix
     &        + (diff_fbiso(i,k-1,j) - diff_fbiso(i,k,j))*dztr(k)
# endif
#else
      subroutine fdift
#endif
      return
      end
