      program diff_nc

!=======================================================================
!     creates diffusion file diff.nc
!=======================================================================

      implicit none

      integer nat
      parameter (nat=2)

      real, allocatable :: var(:,:,:), elev(:,:)
      real, allocatable :: xt(:), yt(:), xu(:), yu(:)

      integer id, jd
      parameter (id=361, jd=181)
      real data(id,jd,2,nat), xd(id), yd(jd)

      integer i, imt, iou, j, jmt, k, n, ntrec
      integer id_xt, id_yt, id_xu, id_yu, id_time
      real psi, theta, phi, rad, radius, syd, s2yd, d, time

      logical exists
      
      character(3) :: a3

      rad = acos(-1.)/180.
      radius = 6370.0e3

!=======================================================================
!     read grid data
!=======================================================================

      time = 0.
      call openfile ("../grid.nc", time, ntrec, iou)
      call getdimlen ('xt', iou, imt)
      call getdimlen ('yt', iou, jmt)
      allocate ( xt(imt) )
      allocate ( yt(jmt) )
      allocate ( xu(imt) )
      allocate ( yu(jmt) )
      allocate ( var(imt,jmt,2) )
      allocate ( elev(imt,jmt) )
      call getvara ('xt', iou, imt, (/1/), (/imt/), xt, 1., 0.)
      call getvara ('yt', iou, jmt, (/1/), (/jmt/), yt, 1., 0.)
      call getvara ('xu', iou, imt, (/1/), (/imt/), xu, 1., 0.)
      call getvara ('yu', iou, jmt, (/1/), (/jmt/), yu, 1., 0.)
      call getvars ('psi', iou, 1, psi, 1., 0.)
      call getvars ('theta', iou, 1, theta, 1., 0.)
      call getvars ('phi', iou, 1, phi, 1., 0.)
      call closefile (iou)

!=======================================================================
!     read elev data for mountain blocking
!=======================================================================

      inquire (file='../salinity_mth.nc', exist=exists)
      if (exists) then
        call openfile ("../elev.nc", time, ntrec, iou)
        call getvara ('elev', iou, imt*jmt, (/1,1/), (/imt,jmt/)
     &,   elev(:,:), 1., 0.)
        call closefile (iou)
        where (elev(:,:) .lt. 0.) elev(:,:) = 0.
      endif

!=======================================================================
!     set diffusion on "data" grid
!=======================================================================

      do j=1,jd
        yd(j) = float(j-1) - 90.
        syd = sin(yd(j)*rad)
        s2yd = sin(2.*yd(j)*rad)
        do i=1,id
          xd(i) = float(i-1)
!         heat (e-w = 1,1, n-s = 2,1)
          data(i,j,1,1) = 3.e10*(1.3 - 1.1*syd**2 + 0.15*syd)
          data(i,j,2,1) = 3.e10*(1.3 - 1.1*syd**2 + 0.15*syd)
!         moisture (e-w = 1,2, n-s = 2,2)
          data(i,j,1,2) = 1.e10
          data(i,j,2,2) = 1.e10
          if (yd(j) .lt. 0.) then
!           add extra n-s moisture diffusion south of the Equator
            data(i,j,2,2) = data(i,j,2,2) + 3.e10*s2yd**2
          endif
        enddo
      enddo

!=======================================================================
!     define diffusion file
!=======================================================================

      call opennew ("../diff.nc", ntrec, iou)
      call redef (iou)
      call defdim ('xt', iou, imt, id_xt)
      call defdim ('yt', iou, jmt, id_yt)
      call defdim ('xu', iou, imt, id_xu)
      call defdim ('yu', iou, jmt, id_yu)
      call defvar ('xt', iou, 1, (/id_xt/), 0., 0., 'X', 'F'
     &, 'longitude of the t grid', 'longitude', 'degrees_east')
      call defvar ('yt', iou, 1, (/id_yt/), 0., 0., 'Y', 'F'
     &, 'latitude of the t grid', 'latitude', 'degrees_north')
      call defvar ('xu', iou, 1, (/id_xu/), 0., 0., 'X', 'F'
     &, 'longitude of the u grid', 'longitude', 'degrees_east')
      call defvar ('yu', iou, 1, (/id_yu/), 0., 0., 'Y', 'F'
     &, 'latitude of the u grid', 'latitude', 'degrees_north')
      do n=1,nat
        if (n .lt. 1000) write(a3,'(i3)') n
        if (n .lt. 100) write(a3,'(i2)') n
        if (n .lt. 10) write(a3,'(i1)') n
        call defvar ('dn_'//trim(a3), iou ,2, (/id_xt,id_yu/), 0., 1.e15
     &, ' ', 'F', 'northward diffusion for tracer '//trim(a3), '', '')
        call defvar ('de_'//trim(a3), iou ,2, (/id_xu,id_yt/), 0., 1.e15
     &, ' ', 'F', 'eastward diffusion for tracer '//trim(a3), '', '')
      enddo
      call enddef (iou)
      call putvara ('xt', iou, imt, (/1/), (/imt/), xt, 1., 0.)
      call putvara ('yt', iou, jmt, (/1/), (/jmt/), yt, 1., 0.)
      call putvara ('xu', iou, imt, (/1/), (/imt/), xu, 1., 0.)
      call putvara ('yu', iou, jmt, (/1/), (/jmt/), yu, 1., 0.)

      do n=1,nat
        if (n .lt. 1000) write(a3,'(i3)') n
        if (n .lt. 100) write(a3,'(i2)') n
        if (n .lt. 10) write(a3,'(i1)') n

!=======================================================================
!       rotate and interpolate east-west diffusion
!=======================================================================

        call rot_intrp_vctr (data(:,:,1:2,n), xd, yd, id, jd
     &,   var(:,:,1:2), xu, yt, imt, jmt, phi, theta, psi, -1.e20, 0)
        var(:,:,:) = abs(var(:,:,:))

!=======================================================================
!       apply mountain blocking
!=======================================================================

        exists = .false.  ! mountain blocking turned off
        if (exists) then
          if (n .eq. 2) then
            do j=1,jmt
               do i=1,imt-1
                d = (xt(i+1) - xt(i))*cos(yt(j)*rad)*radius*rad + 1.e-10
                d = 200.*abs((elev(i+1,j) - elev(i,j))/d)
!               roll off blocking at high latitudes
                d = d*cos(yt(j)*rad)
                var(i,j,1) = var(i,j,1)*max (0.01, 1.-d)
              enddo
            enddo
          endif
        endif

!=======================================================================
!       set boundary conditions
!=======================================================================

        var(1,:,:) = var(imt-1,:,:)
        var(imt,:,:) = var(2,:,:)
        var(:,1,:) = var(:,2,:)
        var(:,jmt,:) = var(:,jmt-1,:)

!=======================================================================
!       write east-west diffusion
!=======================================================================

        call putvara ('de_'//trim(a3), iou, imt*jmt, (/1,1/)
     &, (/imt,jmt/), var(:,:,1), 1., 0.)

!=======================================================================
!       rotate and interpolate north-south diffusion
!=======================================================================

        call rot_intrp_vctr (data(:,:,1:2,n), xd, yd, id, jd
     &,   var(:,:,1:2), xt, yu, imt, jmt, phi, theta, psi, -1.e20, 0)
        var(:,:,:) = abs(var(:,:,:))

!=======================================================================
!       apply mountain blocking
!=======================================================================

        exists = .false.  ! mountain blocking turned off
        if (exists) then
          if (n .eq. 2) then
            do j=1,jmt-1
              do i=1,imt
                d = (yt(j+1) - yt(j))*radius*rad
                d = 200.*abs((elev(i,j+1) - elev(i,j))/d)
!               roll off blocking at high latitudes
                d = d*cos(yt(j)*rad)
                var(i,j,2) = var(i,j,2)*max (0.01, 1.-d)
              enddo
            enddo
          endif
        endif

!=======================================================================
!       set boundary conditions
!=======================================================================

        var(1,:,:) = var(imt-1,:,:)
        var(imt,:,:) = var(2,:,:)
        var(:,1,:) = var(:,2,:)
        var(:,jmt,:) = var(:,jmt-1,:)

!=======================================================================
!       write north-south diffusion
!=======================================================================

        call putvara ('dn_'//trim(a3), iou, imt*jmt, (/1,1/)
     &, (/imt,jmt/), var(:,:,2), 1., 0.)

      enddo
      call closefile (iou)

      end
