      program wind_adv_nc

!=======================================================================
!     creates wind data files wind_adv_mth.nc and wind_adv_ann.nc
!=======================================================================

      implicit none

      real, allocatable :: avar(:,:,:), var(:,:,:,:)
      real, allocatable :: xu(:), yu(:)

      integer id, jd, kd
      parameter (id=144, jd=73, kd=17)
      real data(id,jd,kd,5), xd(id), yd(jd)
      real z(kd), dz(kd), twt

      integer i, imt, iou, j, jmt, k, n, ntrec, id_xu, id_yu, id_time
      real psi, theta, phi, wt, time

      logical exists
      
      character(120) :: path
      
!=======================================================================
!     set path and read path file if it exists
!=======================================================================

      path = '/usr/local/models/UVic_ESCM/data_source'
      inquire (file='../path', exist=exists)
      if (exists) then
        open (10,file='../path')
        read (10,'(a)') path
      endif
      path = trim(path)//'/ncep/pressure/'

!=======================================================================
!     read grid data
!=======================================================================

      time = 0.
      call openfile ("../grid.nc", time, ntrec, iou)
      call getdimlen ('xu', iou, imt)
      call getdimlen ('yu', iou, jmt)
      allocate ( xu(imt) )
      allocate ( yu(jmt) )
      allocate ( var(imt,jmt,2,12) )
      allocate ( avar(imt,jmt,2) )
      call getvara ('xu', iou, imt, (/1/), (/imt/), xu, 1., 0.)
      call getvara ('yu', iou, jmt, (/1/), (/jmt/), yu, 1., 0.)
      call getvars ('psi', iou, 1, psi, 1., 0.)
      call getvars ('theta', iou, 1, theta, 1., 0.)
      call getvars ('phi', iou, 1, phi, 1., 0.)
      call closefile (iou)

!=======================================================================
!     read data grid
!=======================================================================

      call openfile (trim(path)//'uwnd.mon.ltm.nc', time, ntrec, iou)
      call getvara ('lon', iou, id, (/1/), (/id/), xd, 1., 0.)
      call getvara ('lat', iou, jd, (/1/), (/jd/), yd, 1., 0.)
!     flip latitude
      yd(1:jd) = yd(jd:1:-1)
      call closefile (iou)

      avar(:,:,:) = 0.0
      do n=1,12

!=======================================================================
!       read data
!=======================================================================

        call openfile (trim(path)//'uwnd.mon.ltm.nc', time, ntrec, iou)
        call getvara ('uwnd', iou, id*jd*kd, (/1,1,1,n/), (/id,jd,kd,1/)
     &,   data(:,:,:,1), 1., 0.)
!       flip data in latitude
        data(:,1:jd,:,1) = data(:,jd:1:-1,:,1)
        call closefile (iou)

        call openfile (trim(path)//'vwnd.mon.ltm.nc', time, ntrec, iou)
        call getvara ('vwnd', iou, id*jd*kd, (/1,1,1,n/), (/id,jd,kd,1/)
     &,   data(:,:,:,2), 1., 0.)
!       flip data in latitude
        data(:,1:jd,:,2) = data(:,jd:1:-1,:,2)
        call closefile (iou)

        call openfile (trim(path)//'hgt.mon.ltm.nc', time, ntrec, iou)
        call getvara ('hgt', iou, id*jd*kd, (/1,1,1,n/), (/id,jd,kd,1/)
     &,   data(:,:,:,3), 1., 0.)
!       flip data in latitude
        data(:,1:jd,:,3) = data(:,jd:1:-1,:,3)
        call closefile (iou)

!       only 8 levels of humidity instead of 17
        call openfile (trim(path)//'shum.mon.ltm.nc', time, ntrec, iou)
        call getvara ('shum', iou, id*jd*8, (/1,1,1,n/), (/id,jd,8,1/)
     &,   data(:,:,1:8,4), 1., 0.)
        data(:,:,9:kd,4) = 0.
!       flip data in latitude
        data(:,1:jd,:,4) = data(:,jd:1:-1,:,4)
        call closefile (iou)

!       to get back to Damon's method
!        z = (/0.,750.,1500.,3000.,4200.,5500.,7200.,9150.,9150.,9150.
!     &,      9150.,9150.,9150.,9150.,9150.,9150.,9150./)
!        data(:,:,:,3) = 0.0
!        data(:,:,:,4) = 0.0
!        do k=1,kd
!          data(:,:,k,3) = z(k)
!          data(:,:,k,4) = exp(-z(k)/1800.)
!        enddo
!        data(:,:,9:kd,4) = 0.

!=======================================================================
!       calculate advecting wind from weighted data
!=======================================================================

        do j=1,jd
          do i=1,id

            dz(1) = (data(i,j,2,3) - data(i,j,1,3))/2. + data(i,j,1,3)
            do k=2,kd-1
              dz(k) = (data(i,j,k+1,3) - data(i,j,k,3))/2.
     &              + (data(i,j,k,3) - data(i,j,k-1,3))/2.
            enddo
            dz(kd) = (data(i,j,kd,3) - data(i,j,kd-1,3))/2.

            twt = data(i,j,kd,4)*dz(kd)
            data(i,j,kd,1) = data(i,j,kd,1)*data(i,j,kd,4)*dz(kd)
            do k=1,kd-1
              data(i,j,kd,1) = data(i,j,kd,1)
     &                       + data(i,j,k,1)*data(i,j,k,4)*dz(k)
              twt = twt + data(i,j,k,4)*dz(k)
            enddo
            if (twt .ne. 0.) data(i,j,kd,1) = data(i,j,kd,1)/twt

            twt = data(i,j,kd,4)*dz(kd)
            data(i,j,kd,2) = data(i,j,kd,2)*data(i,j,kd,4)*dz(kd)
            do k=1,kd-1
              data(i,j,kd,2) = data(i,j,kd,2)
     &                       + data(i,j,k,2)*data(i,j,k,4)*dz(k)
              twt = twt + data(i,j,k,4)*dz(k)
            enddo
            if (twt .ne. 0.) data(i,j,kd,2) = data(i,j,kd,2)/twt

          enddo
        enddo

!=======================================================================
!       set wt to 1. for surface winds 0. for height integrated
!=======================================================================

        wt = 0.
        data(:,:,1,1) = data(:,:,1,1)*wt + data(:,:,kd,1)*(1.-wt)
        data(:,:,1,2) = data(:,:,1,2)*wt + data(:,:,kd,2)*(1.-wt)

!=======================================================================
!       rotate and interpolate data
!=======================================================================

        call rot_intrp_vctr (data(:,:,1,1:2), xd, yd, id, jd
     &,   var(:,:,1:2,n), xu, yu, imt, jmt, phi, theta, psi, -1.e20, 0)

!=======================================================================
!       set cyclic boundary condition
!=======================================================================

        var(1,:,:,n) = var(imt-1,:,:,n)
        var(imt,:,:,n) = var(2,:,:,n)

        avar(:,:,:) = avar(:,:,:) + var(:,:,:,n)
      enddo
      avar(:,:,:) = avar(:,:,:)/12.


!=======================================================================
!     write monthly netcdf data
!=======================================================================

      call opennew ("../wind_adv_mth.nc", ntrec, iou)
      call redef (iou)
      call defdim ('time', iou, 0, id_time)
      call defdim ('xu', iou, imt, id_xu)
      call defdim ('yu', iou, jmt, id_yu)
      call defvar ('time', iou, 1, (/id_time/), 0., 0., 'T', 'D'
     &, 'time', 'time', 'months')
      call defvar ('xu', iou, 1, (/id_xu/), 0., 0., 'X', 'F'
     &, 'longitude of the u grid', 'longitude', 'degrees_east')
      call defvar ('yu', iou, 1, (/id_yu/), 0., 0., 'Y', 'F'
     &, 'latitude of the u grid', 'latitude', 'degrees_north')
      call defvar ('wx', iou, 3, (/id_xu,id_yu,id_time/), -1000.
     &,  1000., ' ', 'F', 'eastward wind for advection of humidity'
     &, 'eastward_wind', 'm s-1')
      call defvar ('wy', iou, 3, (/id_xu,id_yu,id_time/), -1000.
     &,  1000., ' ', 'F', 'northward wind for advection of humidity'
     &, 'northward_wind', 'm s-1')
      call enddef (iou)
      call putvara ('xu', iou, imt, (/1/), (/imt/), xu, 1., 0.)
      call putvara ('yu', iou, jmt, (/1/), (/jmt/), yu, 1., 0.)
      do n=1,12
        call putvars ('time', iou, n, real(n), 1., 0.)
        call putvara ('wx', iou, imt*jmt, (/1,1,n/), (/imt,jmt,1/)
     &,   var(1,1,1,n), 1., 0.)
        call putvara ('wy', iou, imt*jmt, (/1,1,n/), (/imt,jmt,1/)
     &,   var(:,:,2,n), 1., 0.)
      enddo
      call closefile (iou)

!=======================================================================
!     write annual netcdf data
!=======================================================================

      call opennew ("../wind_adv_ann.nc", ntrec, iou)
      call redef (iou)
      call defdim ('xu', iou, imt, id_xu)
      call defdim ('yu', iou, jmt, id_yu)
      call defvar ('xu', iou, 1, (/id_xu/), 0., 0., 'X', 'F'
     &, 'longitude of the u grid', 'longitude', 'degrees_east')
      call defvar ('yu', iou, 1, (/id_yu/), 0., 0., 'Y', 'F'
     &, 'latitude of the u grid', 'latitude', 'degrees_north')
      call defvar ('wx', iou, 2, (/id_xu,id_yu/), -1000.
     &, 1000., ' ', 'F', 'eastward wind for advection of humidity'
     &, 'eastward_wind', 'm s-1')
      call defvar ('wy', iou, 2, (/id_xu,id_yu/), -1000.
     &, 1000., ' ', 'F', 'northward wind for advection of humidity'
     &, 'northward_wind', 'm s-1')
      call enddef (iou)
      call putvara ('xu', iou, imt, (/1/), (/imt/), xu, 1., 0.)
      call putvara ('yu', iou, jmt, (/1/), (/jmt/), yu, 1., 0.)
      call putvara ('wx', iou, imt*jmt, (/1,1/), (/imt,jmt/)
     &, avar(:,:,1), 1., 0.)
      call putvara ('wy', iou, imt*jmt, (/1,1/), (/imt,jmt/)
     &, avar(:,:,2), 1., 0.)
      call closefile (iou)

      end
