! source file: /usr/local/models/UVic_ESCM/2.7/source/common/gasbc.F
      subroutine gasbc (is, ie, js, je)

!=======================================================================
!     calculate boundary conditions for the atmospheric model

!     based on code by: A. Fanning and M. Eby
!=======================================================================

      implicit none

      include "param.h"
      include "coord.h"
      include "csbc.h"
      include "ice.h"
      include "switch.h"
      include "tmngr.h"
      include "cembm.h"
      include "atm.h"
      include "insolation.h"
      include "calendar.h"
      include "grdvar.h"

      include "solve.h"

      include "mtlm.h"

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1, l

      real sss, phlo, phhi, sit_in, pt_in, atmpres, xconv, ta_in
      real ph, co2_in, co2star, dco2star, dco2surf, dpco2, pco2surf
      real scco2, piston_vel, avgflxc, fa, calday

      real cosz(is:ie,js:je)

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

      phlo = 6.
      phhi = 9.
      sit_in = 7.6875e-03 !mol/m^3
      pt_in = 0.5125e-3   !mol/m^3
      atmpres = 1.0       !atm
      xconv = 31.5/3.6e+05
      co2flx = 0.
!     fa is used in converting g carbon cm-2 => ppmv CO2
!     4.138e-7 => 12e-6 g/umol carbon / 29 g/mol air
      fa = 1./(4.138e-7*rhoatm*shc)

!-----------------------------------------------------------------------
!     average precipitaion and zero accumulator
!-----------------------------------------------------------------------
      avgp(:,:) = accp(:,:)/(segtim*daylen)
      accp(:,:) = 0.0

!-----------------------------------------------------------------------
!     zero totals for new accumulation
!-----------------------------------------------------------------------
      atatm = 0.
      flux(:,:,:) = 0.

      sbc(:,:,iro) = 0.

      sbc(:,:,iat) = 0.
      sbc(:,:,irh) = 0.
      sbc(:,:,ipr) = 0.
      sbc(:,:,ips) = 0.
      sbc(:,:,iaws) = 0.
      sbc(:,:,iswr) = 0.

      sbc(:,:,icflx) = 0.

      do j=jsp1,jem1
        do i=isp1,iem1

          if (tmsk(i,j) .ge. 0.5) then

!-----------------------------------------------------------------------
!           calculate freezing point of sea water using UNESCO (1983)
!-----------------------------------------------------------------------
            sss = 1000.0*sbc(i,j,isss) + 35.0
            frzpt(i,j) = -.0575*sss + 1.710523e-3*sss**1.5
     &                   - 2.154996e-4*sss**2

!-----------------------------------------------------------------------
!           calculate ocean surface flux of carbon
!-----------------------------------------------------------------------
            ta_in = sss*2.36775/(socn*1000.)   !surface ref alk

            co2_in = co2ccn

            call co2calc (sbc(i,j,isst), sss, sbc(i,j,issc)
     &,       ta_in, pt_in, sit_in, phlo, phhi, ph, co2_in, atmpres
     &,       co2star, dco2star, pCO2surf, dpco2)

!           calculate Schmidt number (of co2 = 660 at t = 20 in sea water)
!           based on SST. from Wanninkhof:  Sc = A - Bt + Ct^2 - Dt^3
            scco2 = 2073.1 - 125.62*sbc(i,j,isst)
     &            + 3.6276*sbc(i,j,isst)**2.0
     &            - 0.043219*sbc(i,j,isst)**3.0

!           xconv is constant to convert piston_vel from cm/hr -> cm/s
!           wind speed spd(i,j) is converted from cm/s -> m/s
            piston_vel = xconv*((sbc(i,j,iws)*0.01)**2.)
     &                  *((scco2/660.)**(-0.5))*(1.0 - aice(i,j,1))

!           dic in umol cm-3 or (mol m-3) => flux in umol cm-2 s-1
            sbc(i,j,icflx) = piston_vel*dco2star

          endif
        enddo
      enddo

!-----------------------------------------------------------------------
!     update insolation for the current day
!-----------------------------------------------------------------------
!     subroutine decl is expecting a 365.25 day year
      calday = dayoyr*365.25/yrlen
      call decl (calday, eccen, obliq, mvelp, lambm0, sindec, eccf)
      i = (ie-is+1)*(je-js+1)
      call zenith (i, c0, daylen, daylen, tlat, tlon, sindec, cosz)
      solins(:,:) = solarconst*eccf*cosz(:,:)

!-----------------------------------------------------------------------
!     update any atmospheric data
!-----------------------------------------------------------------------

      call atmos
      call albedo

!-----------------------------------------------------------------------
!     set boundary conditions for carbon
!-----------------------------------------------------------------------
      call setbcx (sbc(1,1,icflx), imt, jmt)

!-----------------------------------------------------------------------
!     calcualte CO2 forcing
!-----------------------------------------------------------------------
      call co2forc

!-----------------------------------------------------------------------
!     set flags to calcualte new coefficients
!-----------------------------------------------------------------------
      newcoef(1,1) = .true.
      newcoef(2,1) = .true.
      newcoef(1,2) = .true.
      newcoef(2,2) = .true.

!-----------------------------------------------------------------------
!     zero time averages if not in an averaging period
!-----------------------------------------------------------------------
      if (.not. timavgperts) call ta_embm_snap (is, ie, js, je, 0)

!-----------------------------------------------------------------------
!     zero time step integrals if not in an averaging period
!-----------------------------------------------------------------------
      if (.not. tsiperts) call ta_embm_tsi (0)

      return
      end
