! source file: /usr/local/models/UVic_ESCM/2.7/source/mom/npzd_src.F
      subroutine npzd_src (biota, depth, theta, temp, dnswr, impo
     &,                    dtts, dzt, daylen, dndt, expoout

     &                    )
!=======================================================================
!     computes source terms of the NPZD model
!     code adapted from Xavier Giraud:
!     Giraud et al. 2000, J Mar Res, 58, 609-630
!     original model reference:
!     Oeschlies and Garcon 1999, Global Biogeochem. Cycles 13, 135-160

!     input variables:

!         biota(1:4) = N,P,Z,D [mmol/m^3]
!              depth = depth of grid box boundaries [m]
!              theta = pi/2 minus angle of incidence at noon [radian]
!               temp = temperature [deg C]
!              dnswr = downward shortwave radiation [W/m^2]
!               impo = import of detritus from above [mmol/(m^3 s)]
!               dtts = tracer time step [s]
!                dzt = depth of grid box [m]
!             daylen = day length (fraction: 0 < daylen < 1)

!     output variables:

!               dndt = source terms [mmol/(m^3 s)]
!               impo = import of detritus from above [mmol/(m^3 s)]
!               nppout  = net primary production [mmol/(m^3 s)]
!               grazout = grazing [mmol/(m^3 s)]
!               morpout = mortality of phytoplankton [mmol/(m^3 s)]
!               morzout = mortality of zooplankton [mmol/(m^3 s)]
!               remiout = remineralisation [mmol/(m^3 s)]
!               excrout = excretion [mmol/(m^3 s)]
!               expoout = detrital export [mmol/(m^3 s)]

!     based on code by: A. Schmittner
!=======================================================================

      return

      contains
       function phi(u)
       real phi,u
       phi = (0.555588*u+0.04926*u**2)/(1.+0.188721*u)
       end function phi
      end
