! source file: /usr/local/models/UVic_ESCM/2.7/source/common/size.h
!======================= include file "size.h" =========================

!-----------------------------------------------------------------------
!     USER INPUT:
!-----------------------------------------------------------------------

!     imt    = number of grid points in the longitudinal direction
!              (calculated points are from 2 through imt-1. End points
!               are boundaries)

!     jmt    = number of grid points (latitude rows) in the latitudinal
!              direction (calculated points are from 2 through jmt-1.
!              End points are boundaries)

!     km     = number of grid points in the vertical direction
!              (calculated points are from 1 through km)

!     nt     = number of tracers (temperature, salinity, ...)

!     mnisle = maximum number of islands (unconnected land masses)

!     maxipp = maximum number of all island perimeter points
!-----------------------------------------------------------------------
      include "derived_options.h"

      integer imt, jmt, km, nt, nat, jmz, jmzm1, mnisle, maxipp
      integer nprocessors, jmw, jsmw, jemw, jextra

      parameter (imt=  102, jmt=  102, km= 19)
      parameter (nt=2

     $             +1

     $               )

      parameter (nat=2

     $, jmz=jmt, jmzm1=jmz-1)

      parameter (mnisle=50, maxipp=5000)

      parameter (jmw=jmt)

!-----------------------------------------------------------------------
!     set first and last calculated row within the MW. other rows
!     are used as buffers
!-----------------------------------------------------------------------

!     jsmw   = 1st calculated row within the MW
!     jemw   = last calculated row within the MW

      parameter (jsmw=2, jemw=jmw-1)

!     jextra = extra buffer rows needed for coarse_grained_parallelism.
!              "jextra" rows are added to the top and bottom of the MW
!              so the MW size increases by 2*jextra

          parameter (jextra = 0)

! POINTS = Maximum number of points in grid.
! STEPSM = Maximum number of timesteps in a day.

      integer POINTS, STEPSM
      parameter (POINTS=3639, STEPSM=24)

! NNVG  = Number of non-vegetation surface types.
! NPFT  = Number of plant functional types.
! NTYPE = Number of surface types.
! SOIL  = Index of the surface type 'Soil'
! Land surface types :
!     1 - Broadleaf Tree
!     2 - Needleleaf Tree
!     3 - C3 Grass
!     4 - C4 Grass
!     5 - Shrub
!     6 - Soil

      integer NNVG, NPFT, NTYPE, SOIL
      parameter (NNVG=4, NPFT=5, NTYPE=6, SOIL=6)

