! source file: /usr/local/models/UVic_ESCM/2.7/source/embm/embmio.F
       subroutine embmout (is, ie, js, je)
!=======================================================================
!     output routine for energy-moisture balance model

!     input:
!       is, ie, js, je = starting and ending indicies for i and j

!     based on code by: A. Fanning and M. Eby
!=======================================================================

      implicit none

      include "param.h"
      include "calendar.h"
      include "csbc.h"
      include "atm.h"
      include "solve.h"
      include "coord.h"
      include "grdvar.h"

      include "ice.h"

      include "evp.h"

      include "mtlm.h"

      include "cembm.h"
      include "iounit.h"
      include "scalar.h"
      include "switch.h"
      include "tmngr.h"
      include "riv.h"

      include "cregin.h"

      real tmp_at(imt,jmt,nat)

      real sm(imt,jmt), st(imt,jmt), hs(imt,jmt), ro(imt,jmt)
      real rntatsl, rntatil

      character(120) :: ftsi, ftavg, fsnap, fname, file_stamp
      character(120) :: new_file_name
      save ftsi, ftavg, fsnap
      data ftsi  /' '/
      data ftavg /' '/
      data fsnap /' '/

      integer i, ie, is, id_xt, id_yt, iou, j, je, js, n
      integer ndx, ntrec, it(10), ib(10), ic(10)

      real avgper, ca, calb_ice, time, wt, wtp1
      real p_alb(is:ie,js:je), a_alb(is:ie,js:je), s_alb(is:ie,js:je)
      real sat(is:ie,js:je)
      real c100, c400, C2K

      c100 = 100.
      c400 = 400.
      C2K = 273.15

!-----------------------------------------------------------------------
!     write atmospheric diagnostics
!-----------------------------------------------------------------------

      if (tsits .and. ntatia .ne. 0) then

        call ta_embm_tsi (2)

        if (iotsi .eq. stdout .or. iotsi .lt. 0) then
          write (*,'(1x, a3, i7, 1x, a32, 3(a,1pe13.6))')
     &      'ts=',itt, stamp, ' iterations =', tai_maxit
     &,     ' TAbar=', tai_sat, ' QAbar=', tai_shum
        endif

        if (iotsi .ne. stdout) then
          ntrec = 1
          if (ftsi .eq. ' ') then
            ntrec = 0
            ftsi = file_stamp ('ts_intgrls_embm',stamp,'.nc')
            ftsi = new_file_name (ftsi)
          endif
          avgper = dtatm*ntatia/daylen
          time = relyr + year0

          rntatil = 0.
          if (ntatil .gt. 0) rntatil = 1./float(ntatil)
          tai_hsno = tai_hsno + tai_LYING_SNOW*0.1*rntatil/rhosno

          call embm_tsi_out (ftsi, ntrec, timunit, expnam, avgper, time
     &,                      stamp, tai_sat, tai_shum, tai_precip
     &,                      tai_ohice, tai_oaice, tai_hsno, tai_lhice
     &,                      tai_laice, tai_co2ccn, tai_maxit

     &                      )
        endif

        call ta_embm_tsi (0)

      endif

      if (timavgts .and. ntatsa .ne. 0) then

!-----------------------------------------------------------------------
!       write atmospheric time averaged data
!-----------------------------------------------------------------------

!       calculate average values

        call ta_embm_snap (is, ie, js, je, 2)

!       write time averaged data

        ntrec = 1
        if (ftavg .eq. ' ') then
          ntrec = 0
          ftavg = file_stamp ('time_mean_embm',stamp,'.nc')
          ftavg = new_file_name (ftavg)
        endif

        avgper = dtts*ntatsa/daylen

        rntatsl = 0.
        if (ntatsl .gt. 0) rntatsl = 1./float(ntatsl)
        call unloadland (POINTS, TA_M, imt, jmt, land_map, sm)
        call unloadland (POINTS, TA_TSTAR_GB, imt, jmt, land_map, st)
        call unloadland (POINTS, TA_LYING_SNOW, imt, jmt, land_map, hs)
        call unloadland (POINTS, TA_SURF_ROFF, imt, jmt, land_map, ro)

        do j=js,je
          do i=is,ie
            sat(i,j) =  ta_at(i,j,isat) - elev(i,j)*rlapse

     &                - hicel(i,j,2)*rlapse

            ca = ta_aice(i,j,1)*calb_ice(ta_aice(i,j,1),ta_hsno(i,j,1))
            ca = ca + (1. - ta_aice(i,j,1))*ta_s_calb(i,j)
            s_alb(i,j) = 1. - ca
            a_alb(i,j) = 1. - ta_a_calb(i,j)
            p_alb(i,j) = ta_a_calb(i,j)*pass*s_alb(i,j) + a_alb(i,j)

            if (land_map(i,j) .eq. 0) then

              sm(i,j) = ta_soilm(i,j)
              st(i,j) = ta_surf(i,j)

            else
!             convert from kg m-2 to cm (converted back later)
              sm(i,j) = sm(i,j)*rntatsl*0.1
!             convert from K to C (converted back later)
              st(i,j) = st(i,j)*rntatsl - 273.15
!             convert from kg/m2/s to g/cm2/s (converted back later)
              ta_runoff(i,j) = ro(i,j)*rntatsl*0.1

      !       convert from kg/m2 to cm (converted back later)
              ta_hsno(i,j,1) = hs(i,j)*rntatsl*0.1/rhosno

            endif

          enddo
        enddo

        time = relyr + year0
        call embm_snap_out (ftavg, is, ie, js, je, imt, jmt, km, nat
     &,   ncat, xt, yt, xu, yu, dxt, dyt, dxu, dyu, ntrec, timunit
     &,   expnam, avgper, time, stamp, mapat, ta_at, sat, ta_precip
     &,   ta_evap, ta_outlwr, ta_uplwr, ta_upsens, ta_dnswr, ta_upltnt
     &,   ta_solins, p_alb, a_alb, s_alb, elev, ta_psno, ta_ws
     &,   ta_runoff

     &,   ta_wx, ta_wy

     &,   sm, st

     &,   ta_tice, ta_hice, ta_aice, ta_hsno

     &,   ta_uice, ta_vice, ta_xint, ta_yint

     &,   tlat, tlon, ulat, ulon

     &,   ta_aicel(is,js), ta_hicel(is,js)

     &,   tmsk, mskhr)

        write (*,'(a,i5,a,a,a,a)') '=> Atm time means #'
     &,   ntrec, ' written to ',trim(ftavg),' on ', stamp

!       zero time average accumulators

        call ta_embm_snap (is, ie, js, je, 0)

      endif

      if (snapts) then

!-----------------------------------------------------------------------
!       write atmospheric snapshot
!-----------------------------------------------------------------------

!       write snapshot

        ntrec = 1
        if (fsnap .eq. ' ') then
          ntrec = 0
          fsnap = file_stamp ('snapshots_embm',stamp,'.nc')
          fsnap = new_file_name(fsnap)
        endif

        avgper = 0.

        tmp_at(is:ie,js:je,1:nat) = at(is:ie,js:je,2,1:nat)

        call unloadland (POINTS, M, imt, jmt, land_map, sm)
        call unloadland (POINTS, TSTAR_GB, imt, jmt, land_map, st)
        call unloadland (POINTS, LYING_SNOW, imt, jmt, land_map, hs)
        call unloadland (POINTS, SURF_ROFF, imt, jmt, land_map, ro)

        do j=js,je
          do i=is,ie
            sat(i,j) =  at(i,j,2,isat) - elev(i,j)*rlapse

     &                - hicel(i,j,2)*rlapse

            ca = aice(i,j,2)*calb_ice(aice(i,j,2),hsno(i,j,2))
            ca = ca + (1. - aice(i,j,2))*sbc(i,j,icalb)
            s_alb(i,j) = 1. - ca

            a_alb(i,j) = 1. - a_calb(i,j)
            p_alb(i,j) = a_calb(i,j)*pass*s_alb(i,j) + a_alb(i,j)

            if (land_map(i,j) .eq. 0) then

              sm(i,j) = soilm(i,j,2)
              st(i,j) = surf(i,j)

              hs(i,j) = hsno(i,j,2)

            else
!             convert from kg m-2 to cm (converted back later)
              sm(i,j) = sm(i,j)*0.1
!             convert from K to C (converted back later)
              st(i,j) = st(i,j) - 273.15
!             convert from kg/m2 to cm (converted back later)

              hs(i,j) = hs(i,j)*0.1/rhosno

            endif

          enddo
        enddo

        time = relyr + year0
        call embm_snap_out (fsnap, is, ie, js, je, imt, jmt, km, nat
     &,   ncat, xt, yt, xu, yu, dxt, dyt, dxu, dyu, ntrec, timunit
     &,   expnam, avgper, time, stamp, mapat, tmp_at, sat, precip
     &,   evap, outlwr, uplwr, upsens, dnswr, upltnt, solins, p_alb
     &,   a_alb, s_alb, elev, psno, sbc(is,js,iws), sbc(is,js,iro)

     &,   sbc(is,js,iwx), sbc(is,js,iwy)

     &,   sm, st

     &,   tice(is,js), hice(is,js,2), aice(is,js,2), hs(is,js)

     &,   uice, vice, xint, yint

     &,   tlat, tlon, ulat, ulon

     &,   aicel(is,js,2), hicel(is,js,2)

     &,   tmsk, mskhr)

        write (*,'(a,i5,a,a,a,a)') '=> Atm snapshot #'
     &,   ntrec, ' written to ',trim(fsnap),' on ', stamp

      endif

      if (restrt) then
        fname = new_file_name (file_stamp ("restart_embm",stamp,".nc"))
        if (restts) call embm_rest_out (fname, is, ie, js, je)
        fname = new_file_name ("restart_embm.nc")
        if (eorun) call embm_rest_out (fname, is, ie, js, je)
      endif

      return
      end

      subroutine ta_embm_snap (is, ie, js, je, m)

!=======================================================================
!     atmospheric data time averaging

!     input:
!       is, ie, js, je = starting and ending indicies for i and j
!       m = flag (0 = zero, 1 = accumulate, 2 = write)

!     based on code by: M. Eby
!=======================================================================

      implicit none

      include "param.h"
      include "cembm.h"
      include "atm.h"
      include "riv.h"

      include "ice.h"

      include "csbc.h"

      integer i, ie, is, j, je, js, k, m, n, ndx

      real rntatsa

!-----------------------------------------------------------------------
!     time averaged data
!-----------------------------------------------------------------------

      if (m .eq. 0.) then
!       zero
        ntatsa = 0
        ta_at(:,:,:) = 0.
        ta_precip(:,:) = 0.
        ta_psno(:,:) = 0.
        ta_evap(:,:) = 0.
        ta_outlwr(:,:) = 0.
        ta_uplwr(:,:) = 0.
        ta_upsens(:,:) = 0.
        ta_upltnt(:,:) = 0.
        ta_dnswr(:,:) = 0.
        ta_solins(:,:) = 0.
        ta_s_calb(:,:) = 0.
        ta_a_calb(:,:) = 0.
        ta_ws(:,:) = 0.
        ta_runoff(:,:) = 0.

        ta_wx(:,:) = 0.
        ta_wy(:,:) = 0.

        ta_soilm(:,:) = 0.
        ta_surf(:,:) = 0.

        ta_tice(:,:,:) = 0.
        ta_hice(:,:,:) = 0.
        ta_aice(:,:,:) = 0.
        ta_hsno(:,:,:) = 0.

        ta_uice(:,:) = 0.
        ta_vice(:,:) = 0.
        ta_pice(:,:) = 0.
        ta_xint(:,:) = 0.
        ta_yint(:,:) = 0.

        ta_aicel(:,:) = 0.
        ta_hicel(:,:) = 0.

        ta_psum(:) = 0.
      elseif (m .eq. 1) then
!       accumulate
        ntatsa = ntatsa + 1

        do n=1,nat
          ta_at(:,:,n) = ta_at(:,:,n) + at(:,:,2,n)
        enddo
        ta_precip(:,:) = ta_precip(:,:) + precip(:,:)
        ta_psno(:,:) = ta_psno(:,:) + psno(:,:)
        ta_evap(:,:) = ta_evap(:,:) + evap(:,:)
        ta_outlwr(:,:) = ta_outlwr(:,:) + outlwr(:,:)
        ta_uplwr(:,:) = ta_uplwr(:,:) + uplwr(:,:)
        ta_upsens(:,:) = ta_upsens(:,:) + upsens(:,:)
        ta_upltnt(:,:) = ta_upltnt(:,:) + upltnt(:,:)
        ta_dnswr(:,:) = ta_dnswr(:,:) + dnswr(:,:)
        ta_solins(:,:) = ta_solins(:,:) + solins(:,:)
        ta_s_calb(:,:) = ta_s_calb(:,:) + sbc(:,:,icalb)
        ta_a_calb(:,:) = ta_a_calb(:,:) + a_calb(:,:)
        ta_ws(:,:) = ta_ws(:,:) + sbc(:,:,iws)

        ta_runoff(:,:) = ta_runoff(:,:) + runoff(:,:)

        ta_wx(:,:) = ta_wx(:,:) + sbc(:,:,iwx)
        ta_wy(:,:) = ta_wy(:,:) + sbc(:,:,iwy)

        ta_soilm(:,:) = ta_soilm(:,:) + soilm(:,:,2)
        ta_surf(:,:) = ta_surf(:,:) + surf(:,:)

        ta_tice(:,:,1) = ta_tice(:,:,1) + tice(:,:)
        ta_hice(:,:,1) = ta_hice(:,:,1) + hice(:,:,2)
        ta_aice(:,:,1) = ta_aice(:,:,1) + aice(:,:,2)
        ta_hsno(:,:,1) = ta_hsno(:,:,1) + hsno(:,:,2)

        ta_uice(:,:) = ta_uice(:,:) + uice(:,:)
        ta_vice(:,:) = ta_vice(:,:) + vice(:,:)
        ta_pice(:,:) = ta_pice(:,:) + pice(:,:)
        ta_xint(:,:) = ta_xint(:,:) + xint(:,:)
        ta_yint(:,:) = ta_yint(:,:) + yint(:,:)

        ta_aicel(:,:) = ta_aicel(:,:) + aicel(:,:,2)
        ta_hicel(:,:) = ta_hicel(:,:) + hicel(:,:,2)

        ta_psum(:) = ta_psum(:) + psum(:)
      elseif (m .eq. 2 .and. ntatsa .ne. 0) then
!       average
        rntatsa = 1./float(ntatsa)
        ta_at(:,:,:) = ta_at(:,:,:)*rntatsa
        ta_precip(:,:) = ta_precip(:,:)*rntatsa
        ta_psno(:,:) = ta_psno(:,:)*rntatsa
        ta_evap(:,:) = ta_evap(:,:)*rntatsa
        ta_outlwr(:,:) = ta_outlwr(:,:)*rntatsa
        ta_uplwr(:,:) = ta_uplwr(:,:)*rntatsa
        ta_upsens(:,:) = ta_upsens(:,:)*rntatsa
        ta_upltnt(:,:) = ta_upltnt(:,:)*rntatsa
        ta_dnswr(:,:) = ta_dnswr(:,:)*rntatsa
        ta_solins(:,:) = ta_solins(:,:)*rntatsa
        ta_s_calb(:,:) = ta_s_calb(:,:)*rntatsa
        ta_a_calb(:,:) = ta_a_calb(:,:)*rntatsa
        ta_ws(:,:) = ta_ws(:,:)*rntatsa
        ta_runoff(:,:) = ta_runoff(:,:)*rntatsa

        ta_wx(:,:) = ta_wx(:,:)*rntatsa
        ta_wy(:,:) = ta_wy(:,:)*rntatsa

        ta_soilm(:,:) = ta_soilm(:,:)*rntatsa
        ta_surf(:,:) = ta_surf(:,:)*rntatsa

        ta_hsno(:,:,:) = ta_hsno(:,:,:)*rntatsa
        ta_tice(:,:,:) = ta_tice(:,:,:)*rntatsa
        ta_hice(:,:,:) = ta_hice(:,:,:)*rntatsa
        ta_aice(:,:,:) = ta_aice(:,:,:)*rntatsa

        ta_uice(:,:) = ta_uice(:,:)*rntatsa
        ta_vice(:,:) = ta_vice(:,:)*rntatsa
        ta_pice(:,:) = ta_pice(:,:)*rntatsa
        ta_xint(:,:) = ta_xint(:,:)*rntatsa
        ta_yint(:,:) = ta_yint(:,:)*rntatsa

        ta_aicel(:,:) = ta_aicel(:,:)*rntatsa
        ta_hicel(:,:) = ta_hicel(:,:)*rntatsa

        ta_psum(:) = ta_psum(:)*rntatsa
      endif

      return
      end

      subroutine ta_embm_tsi (m)

!=======================================================================
!     atmospheric data time integral averaging

!     input:
!       m = flag (0 = zero, 1 = accumulate, 2 = write)

!     based on code by: M. Eby
!=======================================================================

      implicit none

      include "param.h"
      include "csbc.h"
      include "grdvar.h"
      include "cembm.h"
      include "atm.h"

      include "ice.h"

      include "solve.h"

      integer  maxit, m, n
      real rntatia, sum, tmp, sat(imt,jmt), dmsk(imt,jmt)

!-----------------------------------------------------------------------
!     time averaged integrated data
!-----------------------------------------------------------------------

       if (m .eq. 0.) then
!       zero
        ntatia = 0
        tai_maxit = 0.
        tai_sat  = 0.
        tai_shum = 0.
        tai_co2ccn = 0.
        tai_precip = 0.
        tai_ohice = 0.
        tai_oaice = 0.
        tai_hsno = 0.
        tai_lhice = 0.
        tai_laice = 0.
        tai_co2ccn = 0.

      elseif (m .eq. 1) then
!       accumulate
        ntatia = ntatia + 1
        maxit = 0
!       set data mask
        dmsk(:,:) = 1.

        do n=1,nat
          if (itout(n) .gt. maxit) maxit = itout(n)
        enddo

        tai_maxit = tai_maxit + maxit
        sat(:,:) = at(:,:,2,isat) - elev(:,:)*rlapse

     &            - hicel(:,:,2)*rlapse

        call areaavg (sat, dmsk, tmp)
        tai_sat  = tai_sat + tmp
        call areaavg (at(1,1,2,ishum), dmsk, tmp)
        tai_shum = tai_shum + tmp

        tai_co2ccn = tai_co2ccn + co2ccn

        call areaavg (precip, dmsk, tmp)
        tai_precip = tai_precip + tmp

        call areatot (hsno(1,1,2), dmsk, tmp)
        tai_hsno = tai_hsno + tmp
!       mask for ocean
        where (tmsk(:,:) .lt. 0.5) dmsk(:,:) = 0.
        call areatot (hice(1,1,2), dmsk, tmp)
        tai_ohice = tai_ohice + tmp
        call areatot (aice(1,1,2), dmsk, tmp)
        tai_oaice = tai_oaice + tmp

!       mask for land
        dmsk(:,:) = 1.
        where (tmsk(:,:) .ge. 0.5) dmsk(:,:) = 0.
        call areatot (hice(1,1,2), dmsk, tmp)
        tai_lhice = tai_lhice + tmp
        call areatot (aice(1,1,2), dmsk, tmp)
        tai_laice = tai_laice + tmp

      elseif (m .eq. 2 .and. ntatia .ne. 0) then
!       average
        rntatia = 1./float(ntatia)
        tai_maxit = tai_maxit*rntatia
        tai_sat  = tai_sat*rntatia
        tai_shum = tai_shum*rntatia
        tai_co2ccn = tai_co2ccn*rntatia
        tai_precip = tai_precip*rntatia
        tai_ohice = tai_ohice*rntatia
        tai_oaice = tai_oaice*rntatia
        tai_hsno = tai_hsno*rntatia
        tai_lhice = tai_lhice*rntatia
        tai_laice = tai_laice*rntatia

      endif

      return
      end

