! source file: /usr/local/models/UVic_ESCM/2.7/source/common/gosbc.F
      subroutine gosbc

!=======================================================================
!     calculate the average fluxes for next ocean time step

!     based on code by: A. Fanning and M. Eby
!=======================================================================

      implicit none

      include "param.h"
      include "csbc.h"

      include "cembm.h"
      include "atm.h"

      include "ice.h"

      include "mtlm.h"

      integer i, j, nc

      real fa, fb, fc, fd

!-----------------------------------------------------------------------
!     calculate average net fluxes. convert heat flux to cal/cm**2/s
!     from kW/m**2 and fresh water flux (cm/s) to an apparent salt
!     flux (g/cm**2/s) using global ocean average salinity, socn
!-----------------------------------------------------------------------

      fa = 2.389e-8/atatm
      fb = -socn/atatm
      fc = 1./atatm
      do j=2,jmtm1
        do i=2,imtm1
          if (tmsk(i,j) .ge. 0.5) then

            sbc(i,j,ihflx) = fa*flux(i,j,isat)
            sbc(i,j,isflx) = fb*flux(i,j,ishum)

          else

            sbc(i,j,ihflx) = 0.
            sbc(i,j,isflx) = 0.
          endif
          if (umsk(i,j) .ge. 0.5) then

            sbc(i,j,itaux) = fc*flux(i,j,nat+1)
            sbc(i,j,itauy) = fc*flux(i,j,nat+2)

          else
            sbc(i,j,itaux) = 0.
            sbc(i,j,itauy) = 0.
          endif
        enddo
      enddo

      call setbcx (sbc(1,1,ihflx), imt, jmt)
      call setbcx (sbc(1,1,isflx), imt, jmt)
      call setbcx (sbc(1,1,itaux), imt, jmt)
      call setbcx (sbc(1,1,itauy), imt, jmt)

!-----------------------------------------------------------------------
!     update boundary conditions from the land model
!     do this now instead of in gasbc so fields can be written out
!-----------------------------------------------------------------------

      fc = 0.
      fd = 0.

      if (atatm .ne. 0.) fd = 1.0/atatm

      if (atlnd .ne. 0.) fc = 1.0/atlnd
      do j=2,jmtm1
        do i=2,imtm1
          if (land_map(i,j) .ne. 0) then
            sbc(i,j,iro) = sbc(i,j,iro)*fc
            sbc(i,j,icalb) = sbc(i,j,icalb)*fc
            sbc(i,j,ievap) = sbc(i,j,ievap)*fc
            sbc(i,j,ilwr) = sbc(i,j,ilwr)*fc
            sbc(i,j,isens) = sbc(i,j,isens)*fc

            sbc(i,j,inpp) =  sbc(i,j,inpp)*fc
            sbc(i,j,isr) =  sbc(i,j,isr)*fc

          else
            sbc(i,j,iro) = sbc(i,j,iro)*fd
            sbc(i,j,ievap) = 0.
            sbc(i,j,ilwr) = 0.
            sbc(i,j,isens) = 0.

            sbc(i,j,inpp) = 0.
            sbc(i,j,isr) = 0.

          endif
        enddo
      enddo
      call setbcx (sbc(1,1,icalb), imt, jmt)
      call setbcx (sbc(1,1,ievap), imt, jmt)
      call setbcx (sbc(1,1,ilwr), imt, jmt)
      call setbcx (sbc(1,1,isens), imt, jmt)

      call setbcx (sbc(1,1,inpp), imt, jmt)
      call setbcx (sbc(1,1,isr), imt, jmt)

      call setbcx (sbc(1,1,iro), imt, jmt)

      call rivmodel

      return
      end
