! source file: /usr/local/models/UVic_ESCM/2.7/source/mom/tracer_adv_flx.F
      subroutine adv_flux_lin (joff, js, je, is, ie, n)

!=======================================================================
!     Linearized advective tracer flux

!     input:
!       joff = offset relating "j" in the MW to latitude "jrow"
!       js   = starting row in the MW
!       je   = ending row in the MW
!       is   = starting longitude index in the MW
!       ie   = ending longitude index in the MW

!     based on code by: R. C. Pacanowski
!=======================================================================

      return
      end

      subroutine adv_flux_2nd (joff, js, je, is, ie, n)

!=======================================================================
!     2nd order advective tracer flux

!     input:
!       joff = offset relating "j" in the MW to latitude "jrow"
!       js   = starting row in the MW
!       je   = ending row in the MW
!       is   = starting longitude index in the MW
!       ie   = ending longitude index in the MW
!        n   = tracer

!     based on code by: R. C. Pacanowski
!=======================================================================

      include "param.h"

      parameter (istrt=2, iend=imt-1)
      include "mw.h"

!-----------------------------------------------------------------------
!     calculate 2*advective flux across eastern face of "T" cells.
!     (It`s done this way for performance issues)
!-----------------------------------------------------------------------

      do j=js,je
        do k=1,km
          do i=istrt-1,iend

            adv_fe(i,k,j) = adv_vet(i,k,j)*(t(i,  k,j,n,tau) +
     &                                      t(i+1,k,j,n,tau))

          enddo
        enddo
      enddo

!-----------------------------------------------------------------------
!     2*advective flux across northern face of "T" cells is built
!     into ADV_Ty. (It`s done this way for performance issues)
!-----------------------------------------------------------------------

!-----------------------------------------------------------------------
!     calculate 2*advective flux across bottom face of "T" cells.
!     (It`s done this way for performance issues)
!-----------------------------------------------------------------------

      do j=js,je
        do k=1,km-1
          do i=istrt,iend

            adv_fb(i,k,j)  = adv_vbt(i,k,j)*(t(i,k,  j,n,tau) +
     &                                       t(i,k+1,j,n,tau))

          enddo
        enddo
      enddo

      return
      end

      subroutine adv_flux_quick (joff, js, je, is, ie, n)

!=======================================================================
!     3rd order advective tracer flux

!     input:
!       joff = offset relating "j" in the MW to latitude "jrow"
!       js   = starting row in the MW
!       je   = ending row in the MW
!       is   = starting longitude index in the MW
!       ie   = ending longitude index in the MW
!        n   = tracer

!     based on code by: R. C. Pacanowski
!=======================================================================

      include "param.h"

      return
      end

      subroutine adv_flux_4th (joff, js, je, is, ie, n)

!=======================================================================
!     4th order advective tracer flux

!     input:
!       joff = offset relating "j" in the MW to latitude "jrow"
!       js   = starting row in the MW
!       je   = ending row in the MW
!       is   = starting longitude index in the MW
!       ie   = ending longitude index in the MW
!        n   = tracer

!     based on code by: R. C. Pacanowski
!=======================================================================

      return
      end

      subroutine adv_flux_fct (joff, js, je, is, ie, n)

!=======================================================================
!     computes advective fluxes using a flux-corrected transport scheme

!        for reference see
!        Gerdes, R., C. Koeberle and J. Willebrandt, 1991
!        the influence of numerical advection schemes on the results of
!        ocean general circulation models. Clim Dynamics 5, 211-226
!        and
!        Zalesak, S. T., 1979: Fully multidimensional flux-corrected
!        transport algorithms for fluids. J. Comp. Phys. 31, 335-362.

!     input:
!       joff  = offset relating "j" in the MW to latitude "jrow"
!       js    = starting row in the MW
!       je    = ending row in the MW
!       jstrt = starting row in the MW for fct
!       jend  = ending row in the MW for fct
!       is    = starting longitude index in the MW
!       ie    = ending longitude index in the MW
!       istrt = max(2,starting longitude index in the MW)
!       iend  = min(imt-1,ending longitude index in the MW)
!       n     = tracer index

!     output: ( via common mw in "mw.h" )
!       adv_fn = 2*advective flux across northern face of T-cell
!       adv_fe = 2*advective flux across eastern face of T-cell
!       adv_fb = 2*advective flux across bottom face of T-cell

!               thanks to  M. Eby who did extensive debugging of a
!               very rough beta version and who also added the
!               Gent_McWilliams portion and netcdf diagnostic to show
!               differences between fct and 2nd order advection

!     based on code by: C. Koeberle
!=======================================================================

      return
      end

