! source file: /usr/local/models/UVic_ESCM/2.7/source/mtlm/mtlm_tsi.F
      subroutine mtlm_tsi_out (fname, ntrec, timunit, expnam, avgper
     &,                        relyr, stamp, CS, RESP_S, CV, NPP, GPP
     &,                        HT, LAI, LYING_SNOW, TSOIL, TSTAR, M, ET)
!=======================================================================
!     output routine for land time step integrals

!   inputs:
!     fname   = file name
!     ntrec   = number of time record (zero if not defined)
!     timunit = time unit
!     expnam  = experiment name
!     avgper  = length of averaging period
!     relyr   = time in years
!     stamp   = time stamp
!     CS, ... = data to be written

!   outputs:
!     ntrec   = number of time record in file

!   local variables
!     iou     = io unit (ncid)

!     based on code by: M. Eby
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(120) :: name, title, new_file_name

      integer id(1), id_time, iou, ntrec
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real CS, RESP_S, CV, NPP, GPP, HT, LAI, LYING_SNOW, TSOIL
      real TSTAR, M, ET
      real avgper, relyr, tmp
      real c0, c1, c100, c400, c1e3, c1e4, c1e6, c1e20, C2K, p1

      logical defined

      c0 = 0.
      c1 = 1.
      c100 = 100.
      c400 = 400.
      c1e3 = 1.e3
      c1e4 = 1.e4
      c1e6 = 1.e6
      c1e20 = 1.e20
      C2K = 273.15
      p1 = 0.1

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      defined = .true.
      name = new_file_name (fname)
      if (ntrec .eq. 0) defined = .false.
      call opennext (name, relyr, ntrec, iou)

      if (.not. defined .or. ntrec .eq. 0) then

        if (ntrec .ne. 1) then
          call closefile (iou)
          call opennew (name, iou)
          ntrec = 1
        endif

!-----------------------------------------------------------------------
!       start definitions
!-----------------------------------------------------------------------
        call redef (iou)

!-----------------------------------------------------------------------
!       set global attributes
!-----------------------------------------------------------------------
        if (avgper .gt. 1.e-6) then
          title = 'Time Average Time Step Integrals'
        else
          title = 'Time Step Integrals'
        endif
        call putglobal (iou, name, title, expnam, timunit)

!-----------------------------------------------------------------------
!       define dimensions
!-----------------------------------------------------------------------
        call defdim ('time', iou, 0, id_time)
        id(1) = id_time

!-----------------------------------------------------------------------
!       define 1d data (t)
!-----------------------------------------------------------------------
        call defvar ('time', iou, 1, id, c0, c0, 'T', 'D'
     &,   'time since initial condition', 'time', trim(timunit))
        call defvar ('year', iou, 1, id, c0, c0, ' ', 'F'
     &,   'year', ' ',' ')
        call defvar ('month', iou, 1, id, c0, c0, ' ', 'F'
     &,   'month', ' ',' ')
        call defvar ('day', iou, 1, id, c0, c0, ' ', 'F'
     &,   'day', ' ',' ')
        call defvar ('hour', iou, 1, id, c0, c0, ' ', 'F'
     &,   'hour', ' ',' ')
        call defvar ('minute', iou, 1, id, c0, c0, ' ', 'F'
     &,   'minute', ' ',' ')
        call defvar ('second', iou, 1, id, c0, c0, ' ', 'F'
     &,   'second', ' ',' ')
        if (avgper .gt. 1.e-6) then
          call defvar ('period', iou, 1, id, c0, c0, ' ', 'F'
     &,     'averaging period', ' ',' ')
        endif
        call defvar ('CS', iou, 1, id, c0, c1e20, ' '
     &,   'F', 'global total soil carbon', ' ', 'kg')
        call defvar ('RESP_S', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global total soil respiration', ' ', 'kg s-1')
        call defvar ('CV', iou, 1, id, c0, c1e20, ' '
     &,   'F', 'global total vegetation carbon', ' ', 'kg')
        call defvar ('NPP', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global total net primary productivity', ' ', 'kg s-1')
        call defvar ('GPP', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global total gross primary productivity', ' ', 'kg s-1')
        call defvar ('HT', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average vegetation hieght', ' ', 'm')
        call defvar ('LAI', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average leaf area index', ' ', '1')
        call defvar ('LYING_SNOW', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global total snow mass', ' ', 'kg')
        call defvar ('TSOIL', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average soil temperature', ' ', 'K')
        call defvar ('TSTAR', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average skin temperature', ' ', 'K')
        call defvar ('M', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average soil moisture', ' ', 'Kg m-2')
        call defvar ('ET', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average evapotranspiration', ' ', 'kg m-2 s-1')

!-----------------------------------------------------------------------
!       end definitions
!-----------------------------------------------------------------------
        call enddef (iou)
        if (ntrec .eq. 0 ) ntrec = 1

      endif

!-----------------------------------------------------------------------
!     write 1d data (t)
!-----------------------------------------------------------------------
      call putvars ('time', iou, ntrec, relyr, c1, c0)
      call rdstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      tmp = nyear
      call putvars ('year', iou, ntrec, tmp, c1, c0)
      tmp = nmonth
      call putvars ('month', iou, ntrec, tmp, c1, c0)
      tmp = nday
      call putvars ('day', iou, ntrec, tmp, c1, c0)
      tmp = nhour
      call putvars ('hour', iou, ntrec, tmp, c1, c0)
      tmp = nmin
      call putvars ('minute', iou, ntrec, tmp, c1, c0)
      tmp = nsec
      call putvars ('second', iou, ntrec, tmp, c1, c0)
      if (avgper .gt. 1.e-6) then
        call putvars ('period', iou, ntrec, avgper, c1, c0)
      endif
      call putvars ('CS', iou, ntrec, CS, c1, c0)
      call putvars ('RESP_S', iou, ntrec, RESP_S, c1, c0)
      call putvars ('CV', iou, ntrec, CV, c1, c0)
      call putvars ('NPP', iou, ntrec, NPP, c1, c0)
      call putvars ('GPP', iou, ntrec, GPP, c1, c0)
      call putvars ('HT', iou, ntrec, HT, c1, c0)
      call putvars ('LAI', iou, ntrec, LAI, c1, c0)
      call putvars ('LYING_SNOW', iou, ntrec, LYING_SNOW, c1, c0)
      call putvars ('TSOIL', iou, ntrec, TSOIL, c1, c0)
      call putvars ('TSTAR', iou, ntrec, TSTAR, c1, c0)
      call putvars ('M', iou, ntrec, M, c1, c0)
      call putvars ('ET', iou, ntrec, ET, c1, c0)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end
