!*************************************************************************
!   Routine called by NR linbcg to multiply x by sparse matrix jac
!   or its transpose.  Modified from the NR code, p. 81.
!   Sparse vector and it's index vector are size njac = nsys*ndep+2

!   Forward calculation of [A]x or [A^T]x to give b

    subroutine atimes(jac,ijac,njac,xvec,bvec,nsys,itrnsp)

!****************************************************************************
      USE global_param
      implicit none
      INTEGER, INTENT(IN) :: nsys,itrnsp,njac
      INTEGER, INTENT(IN) :: ijac(njac)
      REAL(KIND=dp), INTENT(IN) :: xvec(nsys),jac(njac)
      REAL(KIND=dp), INTENT(INOUT) :: bvec(nsys)

      integer :: i,j,k

!*************************************************************************
      if (itrnsp == 0) then                  ! jac \times x
                                    ! NR routine dsprsax
         if (ijac(1) /= nsys+2) pause 'mismatch vector and matrix in sprsax'
         do i=1,nsys
           bvec(i)=jac(i)*xvec(i)
           do k=ijac(i),ijac(i+1)-1
              bvec(i)=bvec(i)+jac(k)*xvec(ijac(k))
           enddo
         enddo

      elseif (itrnsp == 1) then            ! jac^T \times x
                                    ! NR routine dsprstx
         if (ijac(1) /= nsys+2) pause 'mismatch vector and matrix in sprstx'
         do i=1,nsys
           bvec(i)=jac(i)*xvec(i)
         enddo
         do i=1,nsys
           do k=ijac(i),ijac(i+1)-1
             j=ijac(k)
             bvec(j)=bvec(j)+jac(k)*xvec(i)
           enddo
         enddo

      endif

!***************************************************************************
    end subroutine atimes
!***************************************************************************
