!***************************************************************************
! Routine to do the backwards transformation from the dynamical grid to
! the temperature grid xi, linear in this case. Convert all velocities
! to xi grid and interpolate for interface wveltm, wstrtm.  All temperature
! grid arrays have a negative sense (k=1:surf) and all dynamic grid
! counterparts have positive sense (k=1:bed).  Use NMS routines
! pchez and pchev to do a Hermite cubic interpolation between grids.
! I actually work in real (z) space, since it has the proper sense.

  subroutine bktrans(vt,vp,wvel,vtt,vpt,wvelt,hi,Hice,time,iland)

!***************************************************************************
    USE global_param
    implicit none
    INTEGER, INTENT(IN) :: time
    INTEGER, INTENT(IN) :: iland(nlon,nlat)
    REAL(KIND=dp), INTENT(IN) :: hi(nlon,nlat),Hice(nlon,nlat),&
                                 vt(nvertp,nlonp,nlat-1),&
                                 vp(nvertp,nlon-1,nlatp),&
                                 wvel(nvertp,nlonp,nlatp)
    REAL(KIND=dp), INTENT(INOUT) :: vtt(nvertp,nlonp,nlat-1),&
                                    vpt(nvertp,nlon-1,nlatp),&
                                    wvelt(nvertp,nlonp,nlatp)
    ! Local variables
    integer :: ierr,i,j,ij,jj,iseachk,kd,kt,narray
    INTEGER, parameter :: lwk=100
    REAL, DIMENSION(lwk) :: wk
#if defined uvic_ibm
    REAL(dp), DIMENSION(nvertp) :: z,u,v,w,d,ztd,utd,vtd,wtd,dtd,&
                                   ztdlt,ztdlo,zlo,zlt
    REAL(dp), DIMENSION(nvertp-1) :: wtdm,ztdm,dtdm
#else
    REAL, DIMENSION(SIZE(zeta)) :: z,u,v,w,d,ztd,utd,vtd,wtd,dtd,&
                                   ztdlt,ztdlo,zlo,zlt
    REAL, DIMENSION(SIZE(zeta)-1) :: wtdm,ztdm,dtdm
#endif
    REAL(KIND=dp) :: Hlo,Hlt,hlow,hleft
    LOGICAL :: spline

    spline = .false.
#if defined uvic_ibm
    narray = nvertp
#else
    narray = SIZE(zeta)
#endif
!************************************************
    ! Loop over all interior sheet columns
    ! Horizontal velocities must be transformed at cell interfaces.

    do j=2,nlat-1
      jj=j-1
      do i=2,nlon-1
        ij=i-1
        iseachk = iland(i,j) + iland(i,j-1) + iland(i-1,j)
        if (iseachk==0) CYCLE

        Hlo = (Hice(i,j)+Hice(i,jj))/2._dp
        Hlt = (Hice(i,j)+Hice(ij,j))/2._dp
        hlow   = (hi(i,j)+hi(i,jj))/2._dp
        hleft  = (hi(i,j)+hi(ij,j))/2._dp

        ! Map zeta grid to z, put into single precision
        ! Solve at uniform points in real (zreal) space
        do kd=1,nvertp               ! bottom to top
          kt = nvertp - kd + 1       ! top to bottom
#if defined uvic_ibm
          z(kd)   = hi(i,j) - Hice(i,j)/aa*LOG(zeta(kd))
          zlo(kd) = hlow  - Hlo/aa*LOG(zeta(kd))
          zlt(kd) = hleft - Hlt/aa*LOG(zeta(kd))
          u(kd) = vp(kd,ij,jj)
          v(kd) = vt(kd,ij,jj)
          w(kd) = wvel(kd,ij,jj)
#else
          z(kd) = REAL(hi(i,j)-Hice(i,j)/aa*LOG(zeta(kd)))
          zlo(kd) = REAL(hlow-Hlo/aa*LOG(zeta(kd)))
          zlt(kd) = REAL(hleft-Hlt/aa*LOG(zeta(kd)))
          u(kd) = REAL(vp(kd,ij,jj))
          v(kd) = REAL(vt(kd,ij,jj))
          w(kd) = REAL(wvel(kd,ij,jj))
#endif
          ztd(kd) = hi(i,j)-Hice(i,j)*xi(kt)
          ztdlo(kd) = hlow-Hlo*xi(kt)
          ztdlt(kd) = hleft-Hlt*xi(kt)
        enddo
!       do kd=1,nvert
!         kt = nvertp - kd + 1
!         ztdm(kd) = hi(i,j)-Hice(i,j)*(xi(kt)-delxi/2.)
!       enddo

        if (Hlt > zerop) then
          call is_pchez(narray,zlt,u,d,spline,wk,lwk,ierr)
          call is_pchev(narray,zlt,u,d,narray,ztdlt,utd,dtd,ierr)
          do kt=1,nvertp             ! bottom to top
            kd = nvertp - kt + 1
            vpt(kt,ij,jj) = DBLE(utd(kd))
          enddo
        endif

        if (Hlo > zerop) then
          call is_pchez(narray,zlo,v,d,spline,wk,lwk,ierr)
          call is_pchev(narray,zlo,v,d,narray,ztdlo,vtd,dtd,ierr)
          do kt=1,nvertp
            kd = nvertp - kt + 1
            vtt(kt,ij,jj) = DBLE(vtd(kd))
          enddo
        endif

        if (Hice(i,j) > zerop) then
          call is_pchez(narray,z,w,d,spline,wk,lwk,ierr)
          call is_pchev(narray,z,w,d,narray,ztd,wtd,dtd,ierr)
!         call is_pchev(narray,z,w,d,narray,ztdm,wtdm,dtdm,ierr)
          do kt=1,nvertp
            kd = nvertp - kt + 1
            wvelt(kt,ij,jj) = DBLE(wtd(kd))
          enddo
        endif

      enddo
    enddo

!*********************************************************************
    ! Loop over rightmost longitude column (longitudinal vel. only)
    i = nlon
    ij = nlon-1
    do j=2,nlat-1
      jj=j-1
      Hlt = (Hice(i,j)+Hice(ij,j))/2._dp
      if (Hlt > zerop) then
        hleft = (hi(i,j)+hi(ij,j))/2._dp

        ! Map zeta grid to z, put into single precision
        ! Solve at uniform points in real (zreal) space
        do kd=1,nvertp
          kt = nvertp - kd + 1
#if defined uvic_ibm
          zlt(kd) = hleft-Hlt/aa*LOG(zeta(kd))
          u(kd) = vp(kd,ij,jj)
#else
          zlt(kd) = REAL(hleft-Hlt/aa*LOG(zeta(kd)))
          u(kd) = REAL(vp(kd,ij,jj))
#endif
          ztdlt(kd) = hleft-Hlt*xi(kt)
        enddo

        call is_pchez(narray,zlt,u,d,spline,wk,lwk,ierr)
        call is_pchev(narray,zlt,u,d,narray,ztdlt,utd,dtd,ierr)
        do kt=1,nvertp
            kd = nvertp - kt + 1
            vpt(kt,ij,jj) = DBLE(utd(kd))
        enddo
      endif
    enddo

!*******************************************************************
    ! Loop over uppermost latitude row (latitudinal vel. only)
    j = nlat
    jj = nlat-1
    do i=2,nlon-1
      ij=i-1
      Hlo = (Hice(i,j)+Hice(i,jj))/2._dp
      if (Hlo > zerop) then
        hlow  = (hi(i,j)+hi(i,jj))/2._dp

        ! Map zeta grid to z, put into single precision
        ! Solve at uniform points in real (zreal) space
        do kd=1,nvertp
          kt = nvertp - kd + 1
#if defined uvic_ibm
          zlo(kd) = hlow-Hlo/aa*LOG(zeta(kd))
          v(kd) = vt(kd,ij,jj)
#else
          zlo(kd) = REAL(hlow-Hlo/aa*LOG(zeta(kd)))
          v(kd) = REAL(vt(kd,ij,jj))
#endif
          ztdlo(kd) = hlow-Hlo*xi(kt)
        enddo

        call is_pchez(narray,zlo,v,d,spline,wk,lwk,ierr)
        call is_pchev(narray,zlo,v,d,narray,ztdlo,vtd,dtd,ierr)
        do kt=1,nvertp
          kd = nvertp - kt + 1
          vtt(kt,ij,jj) = DBLE(vtd(kd))
        enddo
      endif
    enddo

!***************************************************************************
  end subroutine bktrans
!***************************************************************************
