!**********************************************************************
!   Calculate theoretical maximum time step required for TD update
!   of a column of ice with thickness Hice and surface velocity
!   wsurf.  This is the recommended inner timestep.  Returns the
!   minimum integer factor of outer time step delt (deltn).

    subroutine caldeltn(wsurf,Hicecur,deltn)

!**********************************************************************
      USE global_param
      implicit none
      REAL(KIND=dp), INTENT(IN) :: wsurf,Hicecur
      REAL(KIND=dp), INTENT(INOUT) :: deltn
      ! Local variables
      REAL(KIND=dp) :: advlim,difflim,deltnex,zeroeff

      zeroeff = 1.e-5_dp
      if (ABS(wsurf) > zeroeff) then
        advlim = Hicecur/(ABS(wsurf)*DBLE(nvert))
      else
        advlim = 20.0_dp
      endif
      difflim = (Hicecur/DBLE(nvert))**2/(2.0_dp*tdiffi)
      deltnex = MIN(advlim,difflim)
      if (deltnex >= deltt) then
         deltn = deltt
      elseif ((deltnex>=deltt/2.0_dp).and.(deltnex < deltt)) then
         deltn = deltt/2.0_dp
      elseif ((deltnex>=deltt/5.0_dp).and.(deltnex < deltt/2.0_dp)) then
         deltn = deltt/5.0_dp
      elseif ((deltnex>=deltt/10.0_dp).and.(deltnex < deltt/5.0_dp)) then
         deltn = deltt/10.0_dp
      elseif ((deltnex>=deltt/20.0_dp).and.(deltnex < deltt/10.0_dp)) then
         deltn = deltt/20.0_dp
      elseif ((deltnex>=deltt/40.0_dp).and.(deltnex < deltt/20.0_dp)) then
         deltn = deltt/40.0_dp
      elseif ((deltnex>=deltt/80.0_dp).and.(deltnex < deltt/40.0_dp)) then
         deltn = deltt/80.0_dp
      else
         deltn = deltt/160.0_dp
!         WRITE(45,*) 'Time step requirements too severe'
!         WRITE(45,*) 'deltstab ', REAL(deltnex)
!         WRITE(45,*) 'wsurf,Hice,deltt', wsurf,Hicecur,deltt
      endif

!***************************************************************************
    end subroutine caldeltn
!***************************************************************************
