!=======================================================================
!     This subroutine calculates surface elevation and judges if the ice
!     is floating or not.

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_get_surf(iland,hg,Hice,ifloating,hi)

#if defined ubc_cidm
! ... global variables
      USE global_param   ! dp,nlon,nlat,ishelf,iceberg
      implicit none

! ... subroutine arguments
      INTEGER,DIMENSION(1:nlon,1:nlat),INTENT(IN) :: iland
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(IN) :: hg,Hice
      INTEGER,DIMENSION(1:nlon,1:nlat),INTENT(OUT) :: ifloating
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(OUT) :: hi

! ... local variables
      integer :: i,j

!-----------------------------------------------------------------------
!     judge floating ice and calculate surface elevation
!-----------------------------------------------------------------------

      if (ishelf > 0) then   ! shelf-ice option
        do j=1,nlat
          do i=1,nlon
            if (iland(i,j) == 1) then
              hi(i,j) = hg(i,j) + Hice(i,j)
              ifloating(i,j) = 0
            elseif (iland(i,j) == -1) then
              hi(i,j) = sealevel
              ifloating(i,j) = 0
            else
              hi(i,j) = sealevel + iceberg*Hice(i,j)
              if (hi(i,j)-Hice(i,j) <= hg(i,j)) then   ! grounding
                hi(i,j) = hg(i,j) + Hice(i,j)
                ifloating(i,j) = 0
              else                                     ! floating
                ifloating(i,j) = 1
              endif
            endif
          enddo
        enddo
      else
        ifloating = 0
        WHERE (iland == 1)
          hi = hg + Hice
        elseWHERE
          hi = sealevel
        endWHERE
      endif

!-----------------------------------------------------------------------
!     lateral boundary conditions
!-----------------------------------------------------------------------

      call cidm_lbc_2d_real(hi)
      call cidm_lbc_2d_int(ifloating)

#endif
!=======================================================================
      end subroutine cidm_get_surf
!=======================================================================
