!=======================================================================
!     This subroutine sets lateral boundary conditions for an integer
!     vriable in 2D matrix (lon-lat) format.

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_lbc_2d_int(idata)

#if defined ubc_cidm
      USE global_param   ! nlon,nlat,igrid
      implicit none

! ... subroutine argument
      INTEGER,INTENT(INOUT),DIMENSION(1:nlon,1:nlat) :: idata

!-----------------------------------------------------------------------
!     east-west lateral boundary conditions
!-----------------------------------------------------------------------

      if (igrid == 1) then   ! cyclic
        idata(1,1:nlat)    = idata(nlon-1,1:nlat)
        idata(nlon,1:nlat) = idata(2,1:nlat)
      else                   ! no-flow
        idata(1,1:nlat)    = idata(2,1:nlat)
        idata(nlon,1:nlat) = idata(nlon-1,1:nlat)
      endif

!-----------------------------------------------------------------------
!     north-south no-flow lateral boundary conditions
!-----------------------------------------------------------------------

      idata(1:nlon,1)    = idata(1:nlon,2)
      idata(1:nlon,nlat) = idata(1:nlon,nlat-1)

#endif
!=======================================================================
      end subroutine cidm_lbc_2d_int
!=======================================================================

!=======================================================================
!     This subroutine sets lateral boundary conditions for a real
!     vriable in 2D matrix (lon-lat) format.

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_lbc_2d_real(data)

#if defined ubc_cidm
      USE global_param   ! dp,nlon,nlat,igrid
      implicit none

! ... subroutine argument
      REAL(KIND=dp),INTENT(INOUT),DIMENSION(1:nlon,1:nlat) :: data

!-----------------------------------------------------------------------
!     east-west lateral boundary conditions
!-----------------------------------------------------------------------

      if (igrid == 1) then   ! cyclic
        data(1,1:nlat)    = data(nlon-1,1:nlat)
        data(nlon,1:nlat) = data(2,1:nlat)
      else                   ! no-flow
        data(1,1:nlat)    = data(2,1:nlat)
        data(nlon,1:nlat) = data(nlon-1,1:nlat)
      endif

!-----------------------------------------------------------------------
!     north-south no-flow lateral boundary conditions
!-----------------------------------------------------------------------

      data(1:nlon,1)    = data(1:nlon,2)
      data(1:nlon,nlat) = data(1:nlon,nlat-1)

#endif
!=======================================================================
      end subroutine cidm_lbc_2d_real
!=======================================================================

!=======================================================================
!     This subroutine sets lateral boundary conditions for embm data
!     in 2D matrix (lon-lat) format.

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_lbc_embm(data)

#if defined ubc_cidm && defined uvic_embm
      USE global_param     ! dp,igrid
      USE cidm_mod_embm    ! iimt,jjmt
      implicit none

! ... subroutine arguments
      REAL(KIND=dp),INTENT(INOUT),DIMENSION(1:iimt,1:jjmt) :: data

!-----------------------------------------------------------------------
!     east-west lateral boundary conditions
!-----------------------------------------------------------------------

      if (igrid == 1) then   ! cyclic
        data(1,1:jjmt)    = data(iimt-1,1:jjmt)
        data(iimt,1:jjmt) = data(2,1:jjmt)
      else                   ! no-flow
        data(1,1:jjmt)    = data(2,1:jjmt)
        data(iimt,1:jjmt) = data(iimt-1,1:jjmt)
      endif

!-----------------------------------------------------------------------
!     north-south lateral boundary conditions
!-----------------------------------------------------------------------

      data(1:iimt,1)      = data(1:iimt,3)
      data(1:iimt,2)      = data(1:iimt,3)
      data(1:iimt,jjmt-1) = data(1:iimt,jjmt-2)
      data(1:iimt,jjmt)   = data(1:iimt,jjmt-2)

#endif
!=======================================================================
      end subroutine cidm_lbc_embm
!=======================================================================

!=======================================================================
!     This subroutine sets lateral boundary conditions for a variable
!     in 1D vector format.

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_lbc_1d(vector)

#if defined ubc_cidm
      USE global_param   ! ndsys,nlon,nlat
      implicit none

! ... subroutine argument
      REAL(KIND=dp), INTENT(INOUT), DIMENSION(1:ndsys) :: vector

! ... local variable
      REAL(KIND=dp), DIMENSION(1:nlon,1:nlat) :: matrix

!-----------------------------------------------------------------------
!     data transformation from 1d arrays to 2d arrays
!-----------------------------------------------------------------------

      call cidm_matrix(vector,matrix)

!-----------------------------------------------------------------------
!     set lateral boundary condition
!-----------------------------------------------------------------------

      call cidm_lbc_2d_real(matrix)

!-----------------------------------------------------------------------
!     data transformation from 2d arrays to 1d arrays
!-----------------------------------------------------------------------

      call cidm_vector(matrix,vector)

#endif
!=======================================================================
      end subroutine cidm_lbc_1d
!=======================================================================

!=======================================================================
!     This subroutine converts data format from 2D matrix (lon-lat) to
!     1D vector.

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_vector(matrix,vector)

#if defined ubc_cidm
      USE global_param   ! nlon,nlat
      implicit none

! ... subroutine arguments
      REAL(KIND=dp),INTENT(IN),DIMENSION(1:nlon,1:nlat) :: matrix
      REAL(KIND=dp),INTENT(OUT),DIMENSION(1:nlon*nlat) :: vector

! ... local
      integer :: i,j,k

      do j = 1,nlat
        do i = 1,nlon
          k = nlon*(j-1) + i
          vector(k) = matrix(i,j)
        enddo
      enddo

#endif
!=======================================================================
      end subroutine cidm_vector
!=======================================================================

!=======================================================================
!     This subroutine converts data format from 1D vector to 2D matrix
!     (lon-lat).

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_matrix(vector,matrix)

#if defined ubc_cidm
      USE global_param   ! nlon,nlat
      implicit none

! ... subroutine arguments
      REAL(KIND=dp),INTENT(IN),DIMENSION(1:nlon*nlat) :: vector
      REAL(KIND=dp),INTENT(OUT),DIMENSION(1:nlon,1:nlat) :: matrix

! ... local
      integer :: i,j,k

      do j = 1,nlat
        do i = 1,nlon
          k = nlon*(j-1) + i
          matrix(i,j) = vector(k)
        enddo
      enddo

#endif
!=======================================================================
      end subroutine cidm_matrix
!=======================================================================
