!*************************************************************************
!   Declare arrays for use in subgrid (hypsometric) mass balance

    MODULE geol_arrays

!**************************************************************************
      USE global_param
      implicit none
      SAVE

!**************************************************************************
      INTEGER, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 isfgeol,&       ! Surface geology map
                 ibgeol          ! Bedrock geology map

      ! Ice velocity fields
      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 vtk,&           ! Previous meridional sheet velocity (m/a)
                 vpk             ! Previous zonal sheet velocity (m/a)

      ! Cell attributes
      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 sedtype         ! Sediment type

      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 tconde,&        ! Crust thermal conductivity (W/m K)
                 tdiffe,&        ! Crust thermal diffusivity (m^2/s)
                 htce,&          ! Crust heat capacity (J/kg K)
                 pore,&          ! Crust porosity (bed TD)
                 wgnd,&          ! Vertical groundwater flow (m/a)
                 hconds,&        ! Hydraulic conductivity (m/a)
                 seddep,&        ! Sediment thickness (m)
                 sedpor,&        ! Sediment porosity
                 storage         ! Sediment storage (m)

!***************************************************************************
      ! Sediment transport
      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 silt,&          ! Basal debris layer (m)
                 siltk,&         ! Previous debris layer (m)
                 depos,&         ! Subice debris layer (m)
                 deposk,&        ! Previous debris layer (m)
                 cover,&         ! Bedrock/surface area
                 gouge           ! Striation depths

      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 siltvol,&       ! Net basal debris (m)
                 ducks,&         ! Subglacial particles
                 erode           ! Bedrock erodability

      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:), SAVE :: &
                 entrate,&       ! Unit entrainment rate (m/a)
                 fallout         ! Unit fallout rate (a^-1)

!**************************************************************************
   end MODULE geol_arrays
!**************************************************************************
