!*************************************************************************
!   Declare arrays for use in subgrid (hypsometric) mass balance

    MODULE hydrol_arrays

!**************************************************************************
      USE global_param
      implicit none
      SAVE

      REAL(dp), ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 moulin,&         ! Drainage from ice surface to bed (m/a)
                 river,&         ! Drainage from continents (m^3/a)
                 swater,&         ! Surface water sheet thickness (m)
                 wyflux,&        ! Meridional water flux (m^2/a)
                 wxflux          ! Zonal water flux (m^2/a)

      REAL(dp), ALLOCATABLE, DIMENSION(:), SAVE :: &
                 water,&         ! Water sheet thickness (m)
                 waterk,&         ! Previous sheet thickness (m)
                 dhwdt,&         ! Rate of change, water  (m/a)
                  resw,&                 ! Residuals in water iteration (m/a)
                  delw,&                 ! Step size, Newton iteration (m/a)
                   jacw                   ! Sparse matrix for water iteration

      INTEGER, ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 iriver,&        ! River outlet map, at shelf breaks (1/0)
                 ilake           ! Proglacial lake flag (1/0)

      INTEGER, ALLOCATABLE, DIMENSION(:), SAVE :: &
                 ijacw          ! Index matrix for jacw (water sheet iteration)

!**************************************************************************
   end MODULE hydrol_arrays
!**************************************************************************
