!***************************************************************************
!   Define hydrological parameters

    MODULE hydrol_param

!***************************************************************************
      USE global_param
      implicit none
      SAVE

!***************************************************************************
      REAL(KIND=dp), parameter :: href = c2
      REAL(KIND=dp), parameter :: fimpw = c1
      REAL(KIND=dp), parameter :: afimpw = c1 - fimpw

     ! Parameterization values, hydraulic conductivity
      REAL(KIND=dp), parameter :: kmin = -12._dp
      REAL(KIND=dp), parameter :: kmax = -6._dp
      REAL(KIND=dp), parameter :: kco1 = r2*(kmax + kmin)
      REAL(KIND=dp), parameter :: kco2 = kmax - kmin
      REAL(KIND=dp), parameter :: kco3 = -kco2/c3
      REAL(KIND=dp), parameter :: kco4 = -10._dp

      ! Parameterization values, pressure-thickness relationship
      REAL(KIND=dp), parameter :: phwco1 = 0.05_dp
      REAL(KIND=dp), parameter :: phwco2 = c1 + phwco1

      ! Surface water parameters
      REAL(KIND=dp), parameter :: viscw = 0.001787_dp                ! 0 deg C
      REAL(KIND=dp), parameter :: sheetco = -r3*rhow*grav/viscw
      INTEGER, parameter :: khsurf = 5
      REAL(KIND=dp), parameter :: darcyco = c10**khsurf                ! m/s
      REAL(KIND=dp), parameter :: diffwco = c3*c10**khsurf         ! m^2/s
      REAL(KIND=dp), parameter :: margin = -800._dp                ! m

!***************************************************************************
    end MODULE hydrol_param
!***************************************************************************
