!*************************************************************************
!   Declare arrays for use in subgrid (hypsometric) mass balance

    MODULE icetd_arrays

!**************************************************************************
      USE global_param
      implicit none
      SAVE

!***************************
      ! Temperature fields
      REAL(dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 tice,&          ! Ice sheet temperature (K)
                 ticek,&         ! Previous sheet temperature (K)
                 tt,tp,&         ! Interface v-grid sheet temperatures (K)
                 ttt,tpt,&       ! Interface sheet temperatures (K)
                 ticev           ! v-grid sheet temperature (K)

      REAL(dp), ALLOCATABLE, DIMENSION(:), SAVE :: &
                 tcolij,&        ! Local column of sheet temps (K)
                 tcolijk         ! Previous column of sheet temps (K)

      ! Temperature grid velocity fields
      REAL(dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 vtt,&           ! T-grid meridional velocity (m/a)
                 vpt             ! T-grid zonal velocity (m/a)

      ! Vertical fields
      REAL(dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 wvelt           ! T-grid vertical velocity (m/a)

!**************************************************************************
   end MODULE icetd_arrays
!**************************************************************************
