!****************************************************************************
!   Load initial temperature field

    subroutine loadtfld(tiso,tsole,hi,Hice)

!*****************************************************************************
      USE icetd_arrays
      implicit none
      REAL(dp), INTENT(IN) :: hi(nlon,nlat),Hice(nlon,nlat)
      REAL(dp), INTENT(INOUT) :: tiso,tsole(nlon,nlat)

      ! Local variables
      integer :: k,kd,i,j,ij,jj
      REAL(dp) :: tss,delz,tbed,tsurf,dtdz
      REAL(dp), EXTERNAL :: tlapse

!*****************************************************************************
      tss = 270.0_dp                ! Sea surface temperature
      tiso = 265._dp                ! Isothermal calculation temperature

      if (init < 3) then            ! Linear initial temperature field
        do i=2,nlon-1
          ij = i-1
          do j=2,nlat-1
            jj = j-1
            if (Hice(i,j) > zerop) then
              delz = Hice(i,j)/REAL(nvert)
              tbed = 260.0_dp
              tsurf = MIN(tlapse(tss,hi(i,j)),triplept)
              dtdz = (tbed-tsurf)/Hice(i,j)
              do k=1,nvertp
                ticev(k,ij,jj) = tbed-dtdz*delz*(k-1)  ! Positive sense
                tice(k,ij,jj) = tsurf+dtdz*delz*(k-1)  ! Negative sense
                ticek(k,ij,jj) = tice(k,ij,jj)
              enddo
            else
              do k=1,nvertp
                tice(k,ij,jj) = tnoice
                ticek(k,ij,jj) = tnoice
                ticev(k,ij,jj) = tnoice
              enddo
            endif
            tsole(i,j) = tice(nvertp,ij,jj)
          enddo
        enddo

      elseif (init == 3) then            ! Continuation run
        READ(30,*)
        READ(30,*) tice
        do jj=1,nlatp
          j = jj+1
          do ij=1,nlonp
            i = ij+1
            do k=1,nvertp
              kd = nvertp + 1 - k
              ticek(k,ij,jj) = tice(k,ij,jj)
              ticev(kd,ij,jj) = tice(k,ij,jj)
            enddo
            tsole(i,j) = tice(nvertp,ij,jj)
          enddo
        enddo
      endif

!***************************************************************************
    end subroutine loadtfld
!***************************************************************************
