!**********************************************************************
!   Calculate ice shelf geometry and velocities

    subroutine shelf(ub,vb,ubk,vbk,hi,Hice,hg,fpshtk,ftshtk,&
                     Bbar,pice,ifloating,time)

!**********************************************************************
      USE shelf_arrays
      USE icetd_arrays
      implicit none
      INTEGER, INTENT(IN) :: time
      INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: ifloating
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: hi,hg,Hice,pice
      REAL(dp), INTENT(IN), DIMENSION(nlon-1,nlatp) :: fpshtk,ubk
      REAL(dp), INTENT(IN), DIMENSION(nlonp,nlat-1) :: ftshtk,vbk
      REAL(dp), INTENT(INOUT), DIMENSION(nlon,nlat) :: Bbar
      REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub
      REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb

      ! Local variables
      integer :: i,ij,j,jj,ip,jp,k,kp
      REAL(dp) :: dudx,dvdy,dudy,dvdx,Bint,tcur,tbar,Aeff,thinice
      REAL(dp), EXTERNAL :: Binv

      Aeff = 3.e7_dp
      thinice = 20.0_dp

!**********************************************************************
      ! Initialize
      ioutlet = 0
      icefront = 0
      nfront = 0

      ! Zero basal velocities for initialization
      if (islid == 0) then                ! No grounded sliding
        ub = c0                                ! Zero all velocities
        vb = c0
      endif

      do j=3,nlatp
        jj = j-1
        jp = j+1
        do i=3,nlonp
          ij = i-1
          ip = i+1

!**********************************************************************
          if (ifloating(i,j) == 1) then                ! Floating

            ! Zero floating velocities only
            if (ifloatrt(i,jj) == 1)  ub(i,jj) = c0
            if (ifloathi(ij,j) == 1)  vb(ij,j) = c0

!***************************************************
            ! Calculate effective viscosity, \bar A

            if (Hice(i,j) < thinice) then           ! A = constant
               Bbar(i,j) = Aeff                           ! Pa yr
               CYCLE                                   ! next point
            endif

            ! Calculate strain rate invariant and effective viscosity
            ! Employ previous velocity field
            dudx = (ubk(i,jj) - ubk(ij,jj))/delx(j)
            dvdy = (vbk(ij,jj) - vbk(ij,j))/dy
            dvdx = (vbk(i,jj) + vbk(i,j) &
                   -vbk(ij-1,jj) - vbk(ij-1,j))/(c4*delx(j))
            dudy = (ubk(ij,jj-1) + ubk(i,jj-1) &
                         -ubk(ij,j) - ubk(i,j))/(c4*dy)
            strinv(i,j) = zerom + dudx**2 + dvdy**2 + dudx*dvdy &
                       + (dvdx**2 + dudy**2)/c4 + dudy*dvdx/c2

            ! Vertically-integrate for Glen stiffness parameter
            ! using Coulomb rheology from MacAyeal et al, 1982
            if ((itherm > 0).and.(itdcoup==1)) then     ! Thermal coupling
              Bint = c0
              do k=1,nvert
                ! Calculate vertically-integrated temperatures
                kp = k+1
                tcur = r2*(tice(ij,jj,k) + tice(ij,jj,kp))
                Bint = Bint + Binv(tcur)*delxi
              enddo
            else
              tbar = 260.0_dp                           ! Isothermal
              Bint = Binv(tbar)
            endif
            Bbar(i,j) = MAX(Bint*strinv(i,j)**strinvexp, Aeff)

!********************************************************
            ! Calculate marginal drag terms
            ! E-W drag from the northern and southern neighbours
            if ((Hice(i,jp) > thinice) .or. (hg(i,jp) > c0)) then
              if ((Hice(i,jj) > thinice) .or. (hg(i,jj) > c0)) then
                  taumar(1,i,j) = Aeff*(c2*(ubk(i,j) + ubk(ij,j)) - ubk(i,jp) &
                             - ubk(ij,jp) - ubk(i,jj) - ubk(ij,jj))/(c4*dy)
              else        ! No drag from the south
                  taumar(1,i,j) = Aeff*(ubk(i,j) + ubk(ij,j) &
                                        - ubk(i,jp) - ubk(ij,jp))/(c2*dy)
              endif
            else        ! No drag from the north
              if ((Hice(i,jj) > thinice) .or. (hg(i,jj) > c0)) then
                  taumar(1,i,j) = Aeff*(ubk(i,j) + ubk(ij,j) &
                                        - ubk(i,jj) - ubk(ij,jj))/(c2*dy)
              else        ! No drag
                  taumar(1,i,j) = c0
              endif
            endif

            ! N-S drag from the eastern and western neighbours
            if ((Hice(ip,j) > thinice) .or. (hg(ip,j) > c0)) then
              if ((Hice(ij,j) > thinice) .or. (hg(ij,j) > c0)) then
                  taumar(2,i,j) = Aeff*(c2*(vbk(i,j) + vbk(i,jj)) - vbk(ip,j) &
                            - vbk(ip,jj) - vbk(ij,j) - vbk(ij,jj))/(c4*delx(j))
              else        ! No drag from the west
                  taumar(2,i,j) = Aeff*(vbk(i,j) + vbk(i,jj) &
                                    - vbk(ip,j) - vbk(ip,jj))/(c2*delx(j))
              endif
            else        ! No drag from the east
              if ((Hice(i,jj) > thinice) .or. (hg(i,jj) > c0)) then
                  taumar(2,i,j) = Aeff*(vbk(i,j) + vbk(ij,jj) &
                                    - vbk(ij,j) - vbk(ij,jj))/(c2*delx(j))
              else        ! No drag
                  taumar(2,i,j) = c0
              endif
            endif

          endif                ! ifloating ifblock

        enddo
      enddo

!**********************************************************************
      ! Find floating outlet position, geometry, velocity

      call shelf_front(ub,vb,ubk,vbk,Hice,fpshtk,ftshtk,Bbar,pice,&
                       thinice,ifloating,time)

!**********************************************************************
      ! Interpolate floating velocites for interior shelf points
      ! Assign eastern and northern interface velocities here

      call shelf_vel(ub,vb,Hice,thinice,ifloating,time)

!***************************************************************************
    end subroutine shelf
!***************************************************************************
