!**********************************************************************
! Calculate ice shelf geometry and velocities

  subroutine shelf_vel(ub,vb,Hice,thinice,ifloating,time)

!**********************************************************************
    USE shelf_arrays
    implicit none
    INTEGER, INTENT(IN) :: time
    INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: ifloating
    REAL(dp), INTENT(IN) :: thinice
    REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: Hice
    REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub
    REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb

    ! Local variables
    integer :: i,ij,j,jj,ip,jp,k,kp,ioute,ioutw,joutn,jouts,&
               iheade,iheadw,jheadn,jheads,imid,length,iseek,jseek
    REAL(dp) :: Hrt,Hhi

!**********************************************************************
    ! Interpolate floating velocites for interior shelf points
    ! Assign eastern and northern interface velocities here

    do j=3,nlatp
      jj = j-1
      jp = j+1
      do i=3,nlonp
        ij = i-1
        ip = i+1

        if ((ifloating(i,j)==1).and.(ioutlet(i,j)==0)) then
          ! Search for outlet and head
          ioute = 0 ; ioutw = 0 ; joutn = 0 ; jouts = 0
          iheade = 0 ; iheadw = 0 ; jheadn = 0 ; jheads = 0
          Hrt = r2*(Hice(i,j) + Hice(ip,j))
          Hhi = r2*(Hice(i,j) + Hice(i,jp))

!************************************************************
          if (Hice(i,j) < thinice) then
            ! If ice is thin, assign zero flux
            ub(i,jj) = c0
            vb(ij,j) = c0
            CYCLE

          else

!************************************************************
            ! EW sweep and zonal velocity assignment
            do iseek = ip,nlon-1        ! sweep east
              if ((icefront(1,iseek,j)==1).or.(Hice(iseek,j) < zerop)) then
                ! Outlet cell
                ioute = iseek
                EXIT
              elseif (ifloating(iseek,j) == 0) then
                ! Grounded ice cell: head of shelf
                iheade = iseek
                EXIT
              endif
            enddo
            if (iseek == nlon) then                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, eastward'
              STOP
            endif

            do iseek = ij,2,-1               ! sweep west
              if ((icefront(3,iseek,j)==1).or.(Hice(iseek,j) < zerop)) then
                ! Outlet cell
                ioutw = iseek
                EXIT
              elseif (ifloating(iseek,j) == 0) then
                ! Grounded ice cell: head of shelf
                iheadw = iseek
                EXIT
              endif
            enddo
            if (iseek == 1) then                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, westward'
              STOP
            endif

!***************************************************
            ! Assign E-W velocities
            if (ioute > 0) then  ! Eastern outlet
              if (ioutw > 0) then        ! spreading E-W
                length = INT((ioute-ioutw)/2)
                imid = ioutw + length
                if (i >= imid) then
                  ub(i,jj) = ub(ioute,jj)*(c1-DBLE(ioute-i)/DBLE(length))
                  if ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) then
                    ub(ij,jj) = ub(ioute,jj)*(c1-DBLE(ioute-ij)/DBLE(length))
                  endif
                else
                  ub(i,jj) = ub(ioutw-1,jj)*(c1-DBLE(i-ioutw)/DBLE(length))
                  if ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) then
                    ub(ij,jj) = ub(ioutw-1,jj)*(c1-DBLE(ij-ioutw)/DBLE(length))
                  endif
                endif
              else                         ! simple eastward flow
                length = ioute - iheadw
                ub(i,jj) = ub(ioute,jj)*(c1-DBLE(ioute-i)/DBLE(length))
                if ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) then
                  ub(ij,jj) = ub(ioute,jj)*(c1-DBLE(ioute-ij)/DBLE(length))
                endif
              endif

            else             ! Eastern head
              if (ioutw > 0) then        ! western outlet
                length = iheade - ioutw
                ub(i,jj) = ub(ioutw-1,jj)*(c1-DBLE(i-ioutw)/DBLE(length))
                if ((ifloating(ij,j)==1).and.(icefront(3,ij,j)==1)) then
                  ub(ij,jj) = ub(ioutw-1,jj)*(c1-DBLE(ij-ioutw)/DBLE(length))
                endif
              else                        ! grounded on both sides
                ub(i,jj) = c0
                ub(ij,jj) = c0
              endif
            endif

!******************************************************************
            ! NS sweep and zonal velocity assignment
            do jseek = jp,nlat-1           ! sweep north
              if ((icefront(2,i,jseek)==1).or.(Hice(i,jseek) < zerop)) then
                ! Outlet cell
                joutn = jseek
                EXIT
              elseif (ifloating(i,jseek) == 0) then
                ! Grounded ice cell: head of shelf
                jheadn = jseek
                EXIT
              endif
            enddo
            if (jseek == nlat) then                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, northward'
              STOP
            endif

            do jseek = jj,2,-1               ! sweep south
              if ((icefront(4,i,jseek)==1).or.(Hice(i,jseek) < zerop)) then
                ! Outlet cell
                jouts = jseek
                EXIT
              elseif (ifloating(i,jseek) == 0) then
                ! Grounded ice cell: head of shelf
                jheads = jseek
                EXIT
              endif
            enddo
            if (jseek == 1) then                ! Problem
              WRITE(45,*) ' Problem here: point ', i,j, 'time = ', time
              WRITE(45,*) ' No floating outlet or head found, southward'
              STOP
            endif

!***************************************************
            ! Assign N-S velocities
            if (joutn > 0) then     ! northern outlet
              if (jouts > 0) then        ! spreading N-S
                length = INT((joutn-jouts)/2)
                imid = jouts + length
                if (j >= imid) then
                  vb(ij,j) = vb(ij,joutn)*(c1-DBLE(joutn-j)/DBLE(length))
                  if ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) then
                    vb(ij,jj) = vb(ij,joutn)*(c1-DBLE(joutn-jj)/DBLE(length))
                  endif
                else
                  vb(ij,j) = vb(ij,jouts-1)*(c1-DBLE(j-jouts)/DBLE(length))
                  if ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) then
                    vb(ij,jj) = vb(ij,jouts-1)*(c1-DBLE(jj-jouts)/DBLE(length))
                  endif
                endif
              else                         ! simple northward flow
                length = joutn - jheads
                vb(ij,j) = vb(ij,joutn)*(c1-DBLE(joutn-j)/DBLE(length))
                if ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) then
                  vb(ij,jj) = vb(ij,joutn)*(c1-DBLE(joutn-jj)/DBLE(length))
                endif
              endif

            else             ! northern head
              if (jouts > 0) then                ! southern outlet
                length = jheadn - jouts
                vb(ij,j) = vb(ij,jouts-1)*(c1-DBLE(j-jouts)/DBLE(length))
                if ((ifloating(i,jj)==1).and.(icefront(4,i,jj)==1)) then
                  vb(ij,jj) = vb(ij,jouts-1)*(c1-DBLE(jj-jouts)/DBLE(length))
                endif
              else                                ! grounded to N and S
                vb(ij,jj) = c0
                vb(ij,j) = c0
              endif
            endif

!**************************************************************************
          endif                !! Velocity assignment

!**************************************************************************
        endif                ! ifloating ifblock

      enddo
    enddo

!**********************************************************************
    do jj=1,nlatp
      ub(1,jj) = c0
      ub(nlon-1,jj) = c0
    enddo

    do ij=1,nlonp
      vb(ij,1) = c0
      vb(ij,nlat-1) = c0
    enddo

!***************************************************************************
  end subroutine shelf_vel
!***************************************************************************
