!***************************************************************************
!   Calculates vertical velocity field from integration of
!   the continuity equation, over scaled vertical co-ord system

    subroutine wfield(vt,vp,wvel,hg,hi,Hice,Hicek,dhgdt,bmelt)

!***************************************************************************
      USE global_param
      implicit none
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: bmelt,dhgdt,Hice,&
                                                    Hicek,hg,hi
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlat-1) :: vt
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlon-1,nlatp) :: vp
      REAL(dp), INTENT(OUT), DIMENSION(nvertp,nlonp,nlatp) :: wvel

      ! Local variables
      integer :: i,j,ij,jj,iwint
      REAL(KIND=dp) :: ubase,vbase,dhidx,dhidy,dhhdx,dhhdy,dxd,dyd

!***************************************************************************
      ! Sheet ice vertical velocity
      do j=2,nlat-1
        jj = j-1
        dxd = delx(j)                 ! Local definitions for
        dyd = dy*sine(j)              !  divergence operator
        do i=2,nlon-1
          ij = i-1
          if (Hice(i,j) > zerop) then
            ! Lower boundary velocity (uplift - basal melt)
            ubase = r2*(vp(1,i,jj) + vp(1,ij,jj))
            vbase = r2*(vt(1,ij,j) + vt(1,ij,jj))
            wvel(1,ij,jj) = dhgdt(i,j) - bmelt(i,j)  &
                           + ubase*(hg(i+1,j)-hg(ij,j))/(c2*delx(j)) &
                           + vbase*(hg(i,jj)-hg(i,j+1))/(dydy)

            ! Vertical integration
            iwint = 1              ! Sheet ice flag: linear interpolant
            dhidx = (hi(i+1,j)-hi(ij,j))/(c2*dxd)    ! Grid terms
            dhidy = (hi(i,jj)-hi(i,j+1))/(dydy)
            dhhdx = (Hice(i+1,j)-Hice(ij,j))/(c2*dxd)
            dhhdy = (Hice(i,jj)-Hice(i,j+1))/(dydy)
            call wint(iwint,Hice(i,j),wvel,vp,vt,dhidx,dhidy,&
                      dhhdx,dhhdy,dxd,dyd,ubase,vbase,i,j,ij,jj)
          endif

        enddo
      enddo

!***************************************************************************
    end subroutine wfield
!***************************************************************************

!***************************************************************************
!   Vertical integrator for ice vertical velocity.  Uses continuity
!   equation Div V = 0 and integrates up from the bed.  Different
!   integrators available; this may be desired for sheet (high shear)
!   versus stream/shelf ice.

    subroutine wint(iwint,Hsij,wvel,vp,vt,dhidx,dhidy,&
                    dhhdx,dhhdy,dxd,dyd,ubase,vbase,i,j,ij,jj)

!***************************************************************************
      USE global_param
      implicit none
      INTEGER, INTENT(IN) :: iwint,i,j,ij,jj
      REAL(KIND=dp), INTENT(IN) :: vt(nvertp,nlonp,nlat-1),&
                                   vp(nvertp,nlon-1,nlatp),&
                                   Hsij,dxd,dyd,dhidx,dhidy,dhhdx,dhhdy,&
                                   ubase,vbase
      REAL(KIND=dp), INTENT(INOUT) :: wvel(nvertp,nlonp,nlatp)

      ! Local variables
      integer :: k,kj
      REAL(KIND=dp) :: zsum,zetacur,dudxcur,dvdycur,ucur,vcur,&
                       gridx,gridy,gridtm,lnzeta,uprev,vprev

!***************************************************************************
      if (iwint == 1) then            ! Sheet ice, linear interpolant

!!         zsum = c0
         uprev = ubase
         vprev = vbase
         do k=2,nvertp
           kj = k-1
           zetacur = r2*(zeta(kj)+zeta(k))
           lnzeta = LOG(zetacur)/aa
           ucur = r2*(vp(k,i,jj) + vp(k,ij,jj))
           vcur = r2*(vt(k,ij,j) + vt(k,ij,jj))
           dudxcur = (vp(kj,i,jj) + vp(k,i,jj) &        ! average over cell
                     -vp(kj,ij,jj) - vp(k,ij,jj))/(c2*dxd)
           dvdycur = (sinehi(jj)*(vt(kj,ij,jj) + vt(k,ij,jj)) &
                     -sinehi(j)* (vt(kj,ij,j) + vt(k,ij,j)))/(c2*dyd)
           gridx = dhidx - lnzeta*dhhdx
           gridy = dhidy - lnzeta*dhhdy
!!           gridtm = (ucur-ubase)*gridx + (vcur-vbase)*gridy
!!           zsum = zsum - Hsij/aa*delzeta/zetacur*(dudxcur+dvdycur)
!!           wvel(k,ij,jj) =  wvel(1,ij,jj) - zsum + gridtm
           gridtm = (ucur-uprev)*gridx + (vcur-vprev)*gridy
           zsum = -Hsij/aa*delzeta/zetacur*(dudxcur+dvdycur)
           wvel(k,ij,jj) =  wvel(kj,ij,jj) - zsum + gridtm
           uprev = ucur
           vprev = vcur
         enddo

      elseif (iwint == 2) then      ! Sheet ice, spline interpolant
         zsum = c0

      endif                  ! End iwint ifblock

!***************************************************************************
    end subroutine wint
!***************************************************************************
