#if defined time_mean_sbc_data && defined restorst && !defined uvic_replacst
      subroutine atmos

!----------------------------------------------------------------------
!     simple data atmosphere

!     based on code by: R. C. Pacanowski and M. Eby
!----------------------------------------------------------------------

      implicit none

# include "param.h"
# include "csbc.h"
# if defined uvic_save_flxadj && defined uvic_embm
#  include "atm.h"
# endif

      character(32) :: stamp

      integer i, j

      real damp1, damp2, sss, sst
      common /catmos/ sst(imt,jmt), sss(imt,jmt)

!----------------------------------------------------------------------
!       restore surface tracers to prescribed data using a newtonian
!       damping term with a restoring time scale of "dampts" (days)
!       (converted to a surface tracer flux by factor "damp").
!----------------------------------------------------------------------

      damp1 = dampdz(1)*secday/dampts(1)
      damp2 = dampdz(2)*secday/dampts(2)
      if (isst .ne. 0 .and. ihflx .ne. 0) then
        do j=1,jmt
          do i=2,imtm1
            sbc(i,j,ihflx) = damp1*(sst(i,j) - sbc(i,j,isst))
#  if defined uvic_save_flxadj && defined uvic_embm
            flxadj(i,j,1) = sbc(i,j,ihflx)
#  endif
          enddo
        enddo
      endif
      do j=1,jmt
        do i=2,imtm1
          sbc(i,j,isflx) = damp2*(sss(i,j) - sbc(i,j,isss))
#  if defined uvic_save_flxadj && defined uvic_embm
          flxadj(i,j,2) = sbc(i,j,isflx)
#  endif
        enddo
      enddo

      return
      end
#elif defined time_varying_sbc_data
      subroutine atmos

!----------------------------------------------------------------------
!     simple data atmosphere

!     based on code by: R. C. Pacanowski and M. Eby
!----------------------------------------------------------------------

      implicit none

# include "param.h"
# include "csbc.h"
# include "ctdbc.h"
# include "tmngr.h"
# include "switch.h"
# include "ndcon.h"
# if defined uvic_save_flxadj && defined uvic_embm &&  defined  restorst
#  include "atm.h"
# endif

      integer i, iou, j, je, js, m, n

      real damp1, damp2, realdays, wnext
      real c10, c100, C2K, p001, p035

      c10 = 10.
      c100 = 100.
      C2K = 273.15
      p001 = 0.001
      p035 = 0.035

!-----------------------------------------------------------------------
!     determine the disk pointers, time weight interpolation factor,
!     and whether or not it is time to bring in new S.B.C. from disk
!     based on the time (days) in MOM since dec 31, 1899 midnight.

!     express model time in days after start of S.B.C. by adding time
!     of I.C. to current model time then subtract time at start of
!     S.B.C.. Note that "itemptime" was allocated in settmngr and is
!     only needed as a temporary.
!     need to add "dt" to the model time because the call to
!     atmos precedes the time stepping loop which calls mom, so the
!     model time has not yet been incremented when atmos executes.
!-----------------------------------------------------------------------

      do n=1,ntdbc
        call addtime (initial, imodeltime, itemptime)
        call addtime (itemptime, idt, itemptime)
        call subtime (itemptime, isbcstart(n), itemptime)
        daysbc(n) = realdays(itemptime)
      enddo

!-----------------------------------------------------------------------
!     determine the disk pointers, time weight interpolation factor,
!     and whether or not it is time to bring in new S.B.C. from disk
!     based on the time (days) in MOM since dec 31, 1899 midnight.
!-----------------------------------------------------------------------

      do n=1,ntdbc
        call timeinterp (daysbc(n), n, tdrec(1,n), aprec(1,n)
     &,    ntdrec(n), period(n), method, inextd(n), iprevd(n)
     &,    wprev(n), rdtdbc(n), inextm(n), iprevm(n))
# if defined uvic_sbc_in_memory
        rdtdbc(n) = .false.
        iprevm(n) = iprevd(n)
        inextm(n) = inextd(n)
# endif
      enddo

!-----------------------------------------------------------------------
!     read in data for each S.B.C. when necessary
!-----------------------------------------------------------------------

      n = 1
      do m=1,numsbc

        if ( m .eq. itaux ) then
!         x component of windstress
          call get_tdsbc (n, 'taux_mth.nc', 'taux', itaux
     &,     rdtdbc(n), c10, c0)

        elseif ( m .eq. itauy ) then
!         y component of windstress
          call get_tdsbc (n, 'tauy_mth.nc', 'tauy', itauy
     &,     rdtdbc(n), c10, c0)

# if defined uvic_read_my_stf
        elseif ( m .eq. ihflx ) then
!         heat flux
          call get_tdsbc (n, 'hflx_mth.nc', 'hflx', ihflx
     &,     rdtdbc(n), c1, c0)

          elseif ( m .eq. isflx ) then
!         fresh water flux
          call get_tdsbc (n, 'sflx_mth.nc', 'sflx', isflx
     &,     rdtdbc(n), c1, c0)
# elif defined uvic_replacst
        elseif ( m .eq. isst ) then
!         replace sst and let model calculate fluxes
          call get_tdsbc (n, 'sst_mth.nc', 'sst', isst
     &,     rdtdbc(n), c1, -C2K)

        elseif ( m .eq. isss ) then
!         replace sss and let model calculate fluxes
          call get_tdsbc (n, 'sss_mth.nc', 'sss', isss
     &,     rdtdbc(n), p001, -p035)
# elif defined  restorst
        elseif ( m .eq. ihflx ) then
!         set fluxes for restoring sst
          call get_tdsbc (n, 'sst_mth.nc', 'sst', ihflx
     &,     rdtdbc(n), c1, -C2K)

        elseif ( m .eq. isflx ) then
!         set fluxes for restoring sss
          call get_tdsbc (n, 'sss_mth.nc', 'sss', isflx
     &,     rdtdbc(n), p001, -p035)

          damp1 = dampdz(1)*secday/dampts(1)
          damp2 = dampdz(2)*secday/dampts(2)
          do j=1,jmt
            do i=1,imt
              sbc(i,j,ihflx) =  damp1*(sbc(i,j,ihflx) - sbc(i,j,isst))
              sbc(i,j,isflx) = damp2*(sbc(i,j,isflx) - sbc(i,j,isss))
#  if defined uvic_save_flxadj && defined uvic_embm
              flxadj(i,j,1) = sbc(i,j,ihflx)
              flxadj(i,j,2) = sbc(i,j,isflx)
#  endif
            enddo
          enddo

# endif
# if defined uvic_embm
        elseif ( m .eq. iws ) then
!         surface wind speed
          call get_tdsbc (n, 'ws_mth.nc', 'ws', iws
     &,     rdtdbc(n), c100, c0)
# endif
# if defined uvic_embm_astress &&  defined uvic_embm
        elseif ( m .eq. iwa ) then
!         surface wind angle
          call get_tdsbc (n, 'wa_mth.nc', 'wa', iwa
     &,     rdtdbc(n), c1, c0)

# endif
# if defined uvic_embm_adv_q &&  defined uvic_embm
        elseif ( m .eq. iwx ) then
!         x component of advecting wind
          call get_tdsbc (n, 'wx_mth.nc', 'wx', iwx
     &,     rdtdbc(n), c100, c0)

        elseif ( m .eq. iwy ) then
!         y component of advecting wind
          call get_tdsbc (n, 'wy_mth.nc', 'wy', iwy
     &,     rdtdbc(n), c100, c0)

# endif
# if defined shortwave
        elseif ( m .eq. ipsw ) then
!         penetrating shortwave radiation
          call get_tdsbc (n, 'psw_mth.nc', 'psw', ipsw
     &,     rdtdbc(n), c1, c0)
# endif
# if defined uvic_mtlm
        elseif ( m .eq. idtr ) then
!         diurnal temperature range
          call get_tdsbc (n, 'dtr_mth.nc', 'dtr', idtr
     &,     rdtdbc(n), c1, c0)
# endif
        endif
# if defined show_details

        if (rdtdbc(n)) then
          write (stdout,'(/tr1,a,i2,a,i6,a,a,a,i3,a,a,a,a32)')
     &      '==> Reading S.B.C. #',n, ' from rec ',inextd(n)
     &,     '[ending at ', rstamp2,'] into index ',inextm(n),'  for '
     &,     ftmp(1:len_trim(ftmp)), ' at MOM time',stamp
        endif
# endif

      enddo

      return
      end

      subroutine get_tdsbc (n, file, name, index, read, scalar, offset)

      implicit none

# include "param.h"
# include "csbc.h"
# include "ctdbc.h"

      character (*) :: file, name
      character (120) :: fname, new_file_name
      integer i, index, iou, j, n, ib(10), ic(10)
      logical read, exists
      real offset, scalar, wnext

      if (read) then
        fname = new_file_name (file)
        inquire (file=trim(fname), exist=exists)
        if (.not. exists) then
          print*, "Error => ", trim(fname), " does not exist."
          stop 'get_tdsbc in atmos.f'
        endif
        obc(:,:,n,inextm(n)) = c0
        ib(:) = 1
        ib(3) = inextd(n)
        ic(:) = imt
        ic(2) = jmt
        ic(3) = 1
        call openfile (fname, iou)
        call getvara (name, iou, imt*jmt, ib, ic, obc(1,1,n,inextm(n))
     &,   scalar, offset)
        call closefile (iou)
      endif
      wnext = c1-wprev(n)
      do j=1,jmt
        do i=1,imt
          sbc(i,j,index) = wprev(n)*obc(i,j,n,iprevm(n))
     &                   + wnext*obc(i,j,n,inextm(n))
        enddo
      enddo
      n = n + 1

      return
      end
#else
      subroutine atmos

      return
      end
#endif
