!======================= include file "csbc.h" =========================

!     surface boundary conditions (S.B.C.)

!     numsbc   = total number of surface boundary conditions
!     indices and names set in UVic_ESCM.F:
!       itaux  = x component of wind stress (dynes cm-2)
!       itauy  = y component of wind stress (dynes cm-2)
!       iwx    = x component of wind for moisture advection (cm s-1)
!       iwy    = y component of wind for moisture advection (cm s-1)
!       iws    = surface wind speed (cm s-1)
!       iwa    = surface wind angle (degrees)
!       ihflx  = heat flux (cal cm-2 s-1)
!       isflx  = salt flux (g cm-2 s-1)
!       icalb  = surface coalbedo (%/100)
!       iro    = surface runoff (g cm-2 s-1)
!       ipsw   = penitrating shortwave (cal cm-2 s-1)
!       isst   = ocean model SST (C)
!       isss   = ocean model SSS (PSU*0.001-0.035)
!       isu    = x component of ocean first layer velocity (cm s-1)
!       isv    = y component of ocean first layer velocity (cm s-1)
!       igu    = x component of ocean second layer velocity (cm s-1)
!       igv    = y component of ocean second layer velocity (cm s-1)
!       icflx  = flux of carbon (umol cm-2 s-1)
!       issc   = sea surface concentration of carbon (umol cm-3)
!       iat    = surface air temperature (C)
!       irh    = surface relative humidity (%/100)
!       ipr    = precipitation as rain (g cm-2 s-1)
!       ips    = precipitation as snow (g cm-2 s-1)
!       iaws   = averaged surface wind speed (cm s-1)
!       iswr   = surface shortwave radiation (g s-3)
!       ilwr   = surface longwave radiation (g s-3)
!       isens  = surface sensible heat flux (g s-3)
!       ievap  = surface evaporation (g cm-2 s-1)
!       idtr   = diurnal temperature range (C)
!       inpp   = net primary production
!       isr    = soil resparation
!     mapsbc   = surface boundary conditions names
!     sbc      = surface boundary condition data.

!     ntspas   = the number of ocean time steps per atmosphere segment
!     ntspls   = the number of ocean time steps per land segment
!     ntspos   = the number of ocean time steps per ocean segment
!     dtatm    = atmosphere time step (s)
!     dtlnd    = land time step (s)
!     dtocn    = ocean time step (s)
!     dtatm    = atmosphere boundary condition averaging time (s)
!     dtlnd    = land boundary condition averaging time (s)
!     dtocn    = ocean boundary condition averaging time (s)
!     dampts   = time scale for damping surface tracers (days) to data
!     dampdz   = ocean level thickness for converting newtonian damping
!                to a surface flux
!     land_map = map with indices for coupling to land arrays

      integer numsbc
      parameter (numsbc = 8
#if defined uvic_carbon
     &                  + 2
#endif
#if defined uvic_embm
     &                  + 1
#endif
#if defined uvic_embm_astress && defined uvic_embm
     &                  + 1
#endif
#if defined uvic_embm_adv_q && defined uvic_embm
     &                  + 2
#endif
#if defined shortwave
     &                  + 1
#endif
#if defined uvic_ice_evp
     &                  + 4
#endif
#if defined uvic_mtlm
     &                  + 10
#endif
#if defined uvic_mtlm && defined uvic_carbon
     &                  + 2
#endif
     &                     )

      integer itaux, itauy, iwx, iwy, iws, iwa, ihflx, isflx, icalb
      integer iro, ipsw, isst, isss, isu, isv, igu, igv, icflx, issc
      integer iat, irh, ipr, ips, iaws, iswr, ilwr, isens, ievap, idtr
      integer inpp, isr

      common /csbc_i/ itaux, itauy, iwx, iwy, iws, iwa, ihflx, isflx
      common /csbc_i/ icalb, iro, ipsw, isst, isss, isu, isv, igu, igv
      common /csbc_i/ icflx, issc, iat, irh, ipr, ips, iaws, iswr
      common /csbc_i/ ilwr, isens, ievap, idtr, inpp, isr

      character(20) :: mapsbc
      common /csbc_c/ mapsbc(numsbc)

      real sbc
      common /csbc_r/ sbc(imt,jmt,numsbc)

      integer ntspas, ntspls, ntspos
      common /csbc_i/ ntspas, ntspls, ntspos

      real dtatm, dtlnd, dtocn, atatm, atlnd, atocn
      common /csbc_r/ dtlnd, dtatm, dtocn, atatm, atlnd, atocn

      real dampts, dampdz
      common /csbc_r/ dampts(nt), dampdz(nt)
#if defined llnl_plume
      common /csbc_r/ subflux(imt,jmt,nt), subz(imt,jmt)
#endif
#if defined uvic_mtlm
      integer land_map

      common /csbc_i/ land_map(imt,jmt)
#endif
