#if defined time_mean_sbc_data
      subroutine setatm

!-----------------------------------------------------------------------
!     set up for simple data atmosphere (just for sbc)

!     based on code by: R. C. Pacanowski and M. Eby
!-----------------------------------------------------------------------

      implicit none

!     before adding a surface boundary condition
!      1. check numsbc is large enough and add index (in csbc.h)
!      2. add index definition to UVic_ESCM (eq. itaux)
!      3. add code below

      integer i, iou, j, k, m, n

# include "param.h"
# include "csbc.h"
# if defined uvic_embm
#  include "atm.h"
# endif
# if defined restorst
      real sst, sss
      common /catmos/ sst(imt,jmt), sss(imt,jmt)
# endif
      real c10, c100, C2K, p001, p035

      c10 = 10.
      c100 = 100.
      C2K = 273.15
      p001 = 0.001
      p035 = 0.035

      do n=1,numsbc

        if ( n .eq. itaux ) then
          print*, 'x component of windstress'
          call get_sbc ('taux_ann.nc', 'taux', itaux, c10, c0)
# if defined uvic_ice_evp || defined uvic_embm_astress
          taux(:,:) = sbc(:,:,itaux)
# endif

        elseif ( n .eq. itauy ) then
          print*, 'y component of windstress'
          call get_sbc ('tauy_ann.nc', 'tauy', itauy, c10, c0)
# if defined uvic_ice_evp || defined uvic_embm_astress
          tauy(:,:) = sbc(:,:,itauy)
# endif

# if defined uvic_read_my_stf
        elseif ( n .eq. ihflx ) then
          print*, 'heat flux'
          call get_sbc ('hflx_ann.nc', 'hflx', ihflx, c1, c0)

        elseif ( n .eq. isflx ) then
          print*, 'salt flux'
          call get_sbc ('sflx_ann.nc', 'sflx', isflx, c1, c0)

# elif defined uvic_replacst
        elseif ( n .eq. isst ) then
          print*, 'sea surface temperature'
          call get_sbc ('sst_ann.nc', 'sst', isst, c1, -C2K)

        elseif ( n .eq. isss ) then
          print*, 'sea surface salinity'
          call get_sbc ('sss_ann.nc', 'sss', isss, p001, -p035)

# elif defined restorst
        elseif ( n .eq. ihflx ) then
          print*, 'data for restoring sst'
          call get_sbc ('sst_ann.nc', 'sst', ihflx, c1, -C2K)
          sst(:,:) = sbc(:,:,ihflx)
          sbc(:,:,ihflx) = 0.0

        elseif ( n .eq. isflx ) then
          print*, 'data for restoring sss'
          call get_sbc ('sss_ann.nc', 'sss', isflx, p001, -p035)
          sss(:,:) = sbc(:,:,isflx)
          sbc(:,:,isflx) = 0.0

# endif
# if defined uvic_embm
        elseif ( n .eq. iws ) then
          print*, 'surface wind speed'
          call get_sbc ('ws_ann.nc', 'ws', iws, c100, c0)

# endif
# if defined uvic_embm_astress &&  defined uvic_embm
        elseif ( n .eq. iwa ) then
          print*, 'surface wind angle'
          call get_sbc ('ws_ann.nc', 'wa', iwa, c1, c0)

# endif
# if defined uvic_embm_adv_q &&  defined uvic_embm
        elseif ( n .eq. iwx ) then
          print*, 'x component of advecting wind'
          call get_sbc ('wx_ann.nc', 'wx', iwx, c100, c0)

        elseif ( n .eq. iwy ) then
          print*, 'y component of advecting wind'
          call get_sbc ('wy_ann.nc', 'wy', iwy, c100, c0)

# endif
# if defined shortwave
        elseif ( n .eq. ipsw ) then
          print*, 'penetrating shortwave radiation'
          call get_sbc ('psw_ann.nc', 'psw', ipsw, c1, c0)

# endif
# if defined uvic_mtlm
        elseif ( n .eq. idtr ) then
          print*, 'diurnal temperature range'
          call get_sbc ('dtr_ann.nc', 'dtr', idtr, c1, c0)

# endif
        endif

      enddo

      return
      end

      subroutine get_sbc (file, name, index, scalar, offset)

      implicit none

# include "param.h"
# include "csbc.h"

      character (*) :: file, name
      character(120) :: fname, new_file_name
      integer index, iou, ib(10), ic(10)
      logical exists
      real offset, scalar

      fname = new_file_name (file)
      inquire (file=trim(fname), exist=exists)
      if (.not. exists) then
        print*, "Error => ", trim(fname), " does not exist."
        stop 'get_tdsbc in atmos.f'
      endif
      sbc(:,:,index) = c0
      ib(:) = 1
      ic(:) = imt
      ic(2) = jmt
      call openfile (fname, iou)
      call getvara (name, iou, imt*jmt, ib, ic, sbc(1,1,index)
     &, scalar, offset)
      call closefile (iou)

      return
      end

#elif defined time_varying_sbc_data
      subroutine setatm

!-----------------------------------------------------------------------
!     set up for simple time varying data atmosphere (just for sbc)

!     based on code by: R. C. Pacanowski and M. Eby
!-----------------------------------------------------------------------

      implicit none

!     this is set up only for periodic monthly data.

!     before adding a surface boundary condition
!      1. check numsbc and ntdbc are large enough (in csbc.h & ctdbc.h)
!      2. add index definition to UVic_ESCM (eq. itaux)
!      3. add code below and to atmos.F

      integer i, id, im, iou, j, k, m, n

# include "param.h"
# include "csbc.h"
# if defined uvic_embm
#  include "atm.h"
# endif
# include "calendar.h"
# include "ctdbc.h"
# include "tmngr.h"
# include "switch.h"

      real c10, c100, C2K, p001, p035, realdays

      c10 = 10.
      c100 = 100.
      C2K = 273.15
      p001 = 0.001
      p035 = 0.035

      do n=1,ntdbc
        ntdrec(n) = 12
        period(n) = .true.
        do m=1, ntdrec(n)
          k = m + 1
          aprec(m,n) = daypm(m)
          if (.not. eqyear .and. nint(aprec(m,n)) .eq. 28) then
            aprec(m,n) = aprec(m,n) + 0.2425
            print*, '=>Warning: adding 0.2425 days to feb for leap year'
          endif
!         create time stamp for the end of each month
          if (k .gt. 12) then
            call mkstmp (dstamp(m,n), 2, 1, 1, 0, 0, 0)
          else
            call mkstmp (dstamp(m,n), 1, k, 1, 0, 0, 0)
          endif
        enddo

        call timeinterpi (ntdrec(n), dstamp(1,n), aprec(1,n), tdrec(1,n)
     &,                  isbcstart(n), period(n))

        call addtime (initial, imodeltime, itemptime)
        call subtime (itemptime, isbcstart(n), itemptime)
        daysbc(n) = realdays(itemptime)
        iprevm(n) = 1
        inextm(n) = 2
        method    = 3
        call timeinterp (daysbc(n), n, tdrec(1,n), aprec(1,n), ntdrec(n)
     &,      period(n), method, inextd(n), iprevd(n), wprev(n)
     &,      rdtdbc(n), inextm(n), iprevm(n))
      enddo

      euler2 = .false.

!     load previous and next data for all boundary conditions
# if defined uvic_sbc_in_memory
!     this is set up only for monthly data.
      do k=1,12
# else
      do k=1,2
# endif
        n = 1
        do m=1,numsbc

          if (n .le. ntdbc) then

            rdtdbc(n) = .true.
# if defined uvic_sbc_in_memory
            id = k
            im = k
# else
            id = iprevd(n)
            im = iprevm(n)
            if (k .eq. 2) then
              id = inextd(n)
              im = inextm(n)
           endif
# endif

            if ( m .eq. itaux ) then
              if (k .eq. 1) print*, 'x component of windstress'
              call get_sbc (n, 'taux_mth.nc', 'taux', id, im, c10, c0)

            elseif ( m .eq. itauy ) then
              if (k .eq. 1) print*, 'y component of windstress'
              call get_sbc (n, 'tauy_mth.nc', 'tauy', id, im, c10, c0)

# if defined uvic_read_my_stf
              if (k .eq. 1) print*, 'heat flux'
            elseif ( m .eq. ihflx ) then
              call get_sbc (n, 'hflx_mth.nc', 'hflx', id, im, c1, c0)

            elseif ( m .eq. isflx ) then
              if (k .eq. 1) print*, 'salt flux'
              call get_sbc (n, 'sflx_mth.nc', 'sflx', id, im, c1, c0)

# elif defined uvic_replacst
            elseif ( m .eq. isst ) then
              if (k .eq. 1) print*, 'sea surface temperature'
              call get_sbc (n, 'sst_mth.nc', 'sst', id, im, c1, -C2K)

            elseif ( m .eq. isss ) then
              if (k .eq. 1) print*, 'sea surface salinity'
              call get_sbc (n, 'sss_mth.nc', 'sss', id, im, p001, -p035)

# elif defined restorst
            elseif ( m .eq. ihflx ) then
              if (k .eq. 1) print*, 'data for restoring sst'
              call get_sbc (n, 'sst_mth.nc', 'sst', id, im, c1, -C2K)

            elseif ( m .eq. isflx ) then
              if (k .eq. 1) print*, 'data for restoring sss'
              call get_sbc (n, 'sss_mth.nc', 'sss', id, im, p001, -p035)

# endif
# if defined uvic_embm
            elseif ( m .eq. iws ) then
              if (k .eq. 1) print*, 'surface wind speed'
              call get_sbc (n, 'ws_mth.nc', 'ws', id, im, c100, c0)

# endif
# if defined uvic_embm_astress &&  defined uvic_embm
            elseif ( m .eq. iwa ) then
              if (k .eq. 1) print*, 'surface wind angle'
              call get_sbc (n, 'wa_mth.nc', 'wa', id, im, c1, c0)

# endif
# if defined uvic_embm_adv_q &&  defined uvic_embm
            elseif ( m .eq. iwx ) then
              if (k .eq. 1) print*, 'x component of advecting wind'
              call get_sbc (n, 'wx_mth.nc', 'wx', id, im, c100, c0)

            elseif ( m .eq. iwy ) then
              if (k .eq. 1) print*, 'y component of advecting wind'
              call get_sbc (n, 'wy_mth.nc', 'wy', id, im, c100, c0)

# endif
# if defined shortwave
            elseif ( m .eq. ipsw ) then
              if (k .eq. 1) print*, 'penetrating shortwave radiation'
              call get_sbc (n, 'psw_mth.nc', 'psw', id, im, c1, c0)

# endif
# if defined uvic_mtlm
            elseif ( m .eq. idtr ) then
              if (k .eq. 1) print*, 'diurnal temperature range'
              call get_sbc (n, 'dtr_mth.nc', 'dtr', id, im, c1, c0)

# endif
            endif

          endif

        enddo
      enddo

      return
      end

      subroutine get_sbc (n, file, name, id, im, scalar, offset)

      implicit none

# include "param.h"
# include "csbc.h"
# include "ctdbc.h"

      character (*) :: file, name
      character(120) :: fname, new_file_name
      integer id, im, iou, n, ib(10), ic(10)
      logical exists
      real offset, scalar

      fname = new_file_name (file)
      inquire (file=trim(fname), exist=exists)
      if (.not. exists) then
        print*, "Error => ", trim(fname), " does not exist."
        stop 'get_sbc in setatm.f'
      else
        ib(:) = 1
        ib(3) = id
        ic(:) = imt
        ic(2) = jmt
        ic(3) = 1
        call openfile (fname, iou)
        call getvara (name, iou, imt*jmt, ib, ic, obc(1,1,n,im)
     &,   scalar, offset)
        call closefile (iou)
      endif
      n = n + 1

      return
      end

#else
      subroutine setatm
      return
      end

#endif
