!======================= include file "cembm.h" ========================

!     parameters for use in the energy balance model (also see atm.h)

!     addflux    = logical flag for adding only even mode fluxes
!     nats       = number of atmospheric time steps since mixing
!     namix      = time steps between mixing (set in atmos.in)
!     lf         = time step flag (1=>leapfrog, 2=>forward)
!     niats      = number of ice advection sub time steps
!     nivts      = time steps between recalculating ice velocities
!     nivc       = time step counter for nivts
!     ns         = number of subcycles for advection and diffusion
!     pyear      = default paleo calendar year (-/+ = BC/AD)
!     dts        = time step (2*dtatm=>leapfrog, dtatm=>forward)
!     co2ccn     = CO2 concentration
!     co2flx     = CO2 flux
!     co2ccni    = initial CO2 concentration
!     anthro     = radiative forcing by CO2
!     co2yri     = last year of initial CO2 concentration
!     co2yrf     = first year of final CO2 concentration
!     co2rate    = rate of increase (linear or exponential)
!     co2for     = CO2 forcing term (in units of heat flux)
!     scatter    = proportion of solar scattered by the atmosphere
!     solarconst = solar constant (g/s**3)
!     cssh       = constant used in calculation of ssh (g/g)
!     cdatm      = drag coefficient (dimensionless)
!     cpatm      = atmospheric heat capacity (cm**2/s**2/K)
!     sht        = scale height for temperature
!     shq        = scale height for specific humidity
!     shc        = scale height for carbon
!     rhoatm     = density of air at sea surface (g/cm**3)
!     esatm      = atmosphere emissivity times Stefan's constant
!     rhoocn     = representative sea surface density
!     esocn      = ocean emissivity times Stefan's constant
!     vlocn      = latent heat of vaporization of water
!     socn       = constant ocean salinity
!     cdice      = drag coefficient (dimensionless)
!     dampice    = time scale for freezing first layer under ice (days)
!     rhoice     = ice density (g/cm**3)
!     rhosno     = snow density (g/cm**3)
!     esice      = ice emissivity times Stefan's constant
!     slice      = latent heat of sublimation of ice
!     flice      = latent heat of fusion of ice (cm**2/s**2)
!     condice    = ice conductivity (g*cm/s**3/K)
!     tsno       = air temperature for accumulating snow
!     hsno_max   = maximum snow depth
!     totaltime  = total time for long term averages
!     dtoih      = total net heat flux through top of atmosphere
!     rlapse     = lapse rate (K/cm)
!     diffactor  = temperature(precip) diffusion factor
!     soilmax    = soil water field capacity (cm)
!     eslnd      = land emissivity time Stefan's constant
!     pass       = atmospheric transmission coefficient (%/100)
!     cs_alb     = clear sky atmospheric albedo (%/100)
!     ice_calb   = ice coalbedo (%/100)
!     sno_calb   = snow coalbedo (%/100)
!     pcfactor   = precip - cloud correlation factor ( %/100)
!     rfactor    = lapse rate reduction factor ( %/100)
!     orbit_yr   = obital forcing year (-/+ = BC/AD)
!     solar_yr   = solar forcing year (-/+ = BC/AD)
!     co2_yr     = co2 forcing year (-/+ = BC/AD)
!     co2_yr     = ice sheet forcing year (-/+ = BC/AD)

      logical addflux

      common /cembm_l/ addflux

      integer nats, namix, lf, niats, nivts, nivc, ns

      common /cembm_i/ nats, namix, lf, niats, nivts, nivc, ns

      real pyear, dts, co2ccn, co2flx,co2ccni, anthro, co2yri,  co2yrf
      real co2rate, co2for, scatter, solarconst, cssh, cdatm, cpatm
      real rhoatm, esatm, rhoocn, esocn, vlocn, socn, cdice, dampice
      real rhoice, sht, shq, shc, rhosno, esice, slice, flice, condice
      real tsno, hsno_max, totaltime, dtoih, rlapse, diffactor, soilmax
      real eslnd, pass, cs_alb, ice_calb, sno_calb, pcfactor, rfactor
      real orbit_yr, solar_yr, co2_yr, ice_yr

      common /cembm_r/ pyear, dts, co2ccn, co2flx, co2ccni, anthro
      common /cembm_r/ co2yri, co2yrf, co2rate, co2for, scatter
      common /cembm_r/ solarconst, cssh, cdatm, cpatm, rhoatm, esatm
      common /cembm_r/ rhoocn, esocn, vlocn, socn, cdice, dampice
      common /cembm_r/ rhoice, sht, shq, shc, rhosno, esice, slice
      common /cembm_r/ flice, condice, tsno, hsno_max, totaltime, dtoih
      common /cembm_r/ rlapse, diffactor, soilmax, eslnd, pass, cs_alb
      common /cembm_r/ ice_calb, sno_calb, pcfactor, rfactor
      common /cembm_r/ orbit_yr, solar_yr, co2_yr, ice_yr

!     ntatsa      = time step counter for time averaging
!     ntatia      = number of time averaged time step integrals
!     tai_sat    = average integrated elevated surface air temperature
!     tai_shum    = average integrated surface specific humidity
!     tai_precip  = average integrated precipitation
!     tai_ohice   = total integrated sea ice volume
!     tai_oaice   = total integrated sea ice area
!     tai_hsno    = total integrated snow volume
!     tai_lhice   = total integrated land ice volume
!     tai_laice   = total integrated land ice area (includes snow)
!     tai_co2ccn  = average integrated CO2 concentration
!     tai_maxit   = average maximum iterations for atmospheric solver
!     tai_nsat   = average northern hemisphere surface air temperature
!     tai_ssat   = average southern hemisphere surface air temperature
!     tai_nshum   = average northern hemisphere surface specific humidity
!     tai_sshum   = average southern hemisphere surface specific humidity
!     tai_nprecip = average northern hemisphere precipitation
!     tai_sprecip = average southern hemisphere precipitation
!     tai_nohice  = total northern hemisphere sea ice volume
!     tai_sohice  = total southern hemisphere sea ice volume
!     tai_noaice  = total northern hemisphere sea ice area
!     tai_soaice  = total southern hemisphere sea ice area
!     tai_nhsno   = total northern hemisphere snow volume
!     tai_shsno   = total southern hemisphere snow volume
!     tai_nlhice  = total northern hemisphere land ice volume
!     tai_slhice  = total southern hemisphere land ice volume
!     tai_nlaice  = total northern hemisphere land ice area
!     tai_slaice  = total southern hemisphere land ice area

      integer ntatsa, ntatia

      common /cembm_i/ ntatsa, ntatia

      real tai_sat, tai_shum, tai_precip, tai_ohice, tai_oaice
      real tai_hsno, tai_lhice, tai_laice, tai_co2ccn, tai_maxit
      real tai_nsat, tai_ssat, tai_nshum, tai_sshum, tai_nprecip
      real tai_sprecip, tai_nohice, tai_sohice, tai_noaice, tai_soaice
      real tai_nhsno, tai_shsno, tai_nlhice, tai_slhice, tai_nlaice
      real tai_slaice

      common /cembm_r/ tai_sat, tai_shum, tai_precip, tai_ohice
      common /cembm_r/ tai_oaice, tai_hsno, tai_lhice, tai_laice
      common /cembm_r/ tai_co2ccn, tai_maxit, tai_nsat, tai_ssat
      common /cembm_r/ tai_nshum, tai_sshum, tai_nprecip, tai_sprecip
      common /cembm_r/ tai_nohice, tai_sohice, tai_noaice, tai_soaice
      common /cembm_r/ tai_nhsno, tai_shsno, tai_nlhice, tai_slhice
      common /cembm_r/ tai_nlaice, tai_slaice
