      subroutine embm_tsi_out (fname, ntrec, timunit, expnam, avgper
     &,                        relyr, stamp, sat, shum, precip
     &,                        v_oice, a_oice, v_snow, v_lice, a_lice
     &,                        co2ccn, scan
#  if defined uvic_tai_ns
     &,                        nsat, ssat, nshum, sshum, nprecip
     &,                        sprecip, v_noice, v_soice, a_noice
     &,                        a_soice, v_nsnow, v_ssnow, v_nlice
     &,                        v_slice, a_nlice, a_slice
#  endif
     &                        )
!=======================================================================
!     output routine for atmospheric time step integrals

!   inputs:
!     fname     = file name
!     ntrec     = number of time record (zero if not defined)
!     timunit   = time unit
!     expnam    = experiment name
!     avgper    = length of averaging period
!     relyr     = time in years
!     stamp     = time stamp
!     sat, ... = data to be written

!   outputs:
!     ntrec     = number of time record in file

!   local variables
!     iou       = io unit (ncid)

!     based on code by: M. Eby
!=======================================================================
#if defined uvic_embm

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(120) :: name, title, new_file_name

      integer id(1), id_time, iou, ntrec
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real sat, shum, precip, v_oice, a_oice, v_snow, v_lice
      real a_lice, co2ccn, scan, nsat, ssat, nshum, sshum
      real nprecip, sprecip, v_noice, v_soice, a_noice
      real a_soice, v_nsnow, v_ssnow, v_nlice
      real v_slice, a_nlice, a_slice, avgper, relyr, tmp
      real c0, c1, c100, c400, c1e3, c1e4, c1e6, c1e20, C2K, p1

      logical defined

      c0 = 0.
      c1 = 1.
      c100 = 100.
      c400 = 400.
      c1e3 = 1.e3
      c1e4 = 1.e4
      c1e6 = 1.e6
      c1e20 = 1.e20
      C2K = 273.15
      p1 = 0.1

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      defined = .true.
      name = new_file_name (fname)
      if (ntrec .eq. 0) defined = .false.
      call opennext (name, relyr, ntrec, iou)

      if (.not. defined .or. ntrec .eq. 0) then

        if (ntrec .ne. 1) then
          call closefile (iou)
          call opennew (name, iou)
          ntrec = 1
        endif

!-----------------------------------------------------------------------
!       start definitions
!-----------------------------------------------------------------------
        call redef (iou)

!-----------------------------------------------------------------------
!       set global attributes
!-----------------------------------------------------------------------
        if (avgper .gt. 1.e-6) then
          title = 'Time Average Time Step Integrals'
        else
          title = 'Time Step Integrals'
        endif
        call putglobal (iou, name, title, expnam, timunit)

!-----------------------------------------------------------------------
!       define dimensions
!-----------------------------------------------------------------------
        call defdim ('time', iou, 0, id_time)
        id(1) = id_time

!-----------------------------------------------------------------------
!       define 1d data (t)
!-----------------------------------------------------------------------
        call defvar ('time', iou, 1, id, c0, c0, 'T', 'D'
     &,   'time since initial condition', 'time', trim(timunit))
        call defvar ('year', iou, 1, id, c0, c0, ' ', 'F'
     &,   'year', ' ',' ')
        call defvar ('month', iou, 1, id, c0, c0, ' ', 'F'
     &,   'month', ' ',' ')
        call defvar ('day', iou, 1, id, c0, c0, ' ', 'F'
     &,   'day', ' ',' ')
        call defvar ('hour', iou, 1, id, c0, c0, ' ', 'F'
     &,   'hour', ' ',' ')
        call defvar ('minute', iou, 1, id, c0, c0, ' ', 'F'
     &,   'minute', ' ',' ')
        call defvar ('second', iou, 1, id, c0, c0, ' ', 'F'
     &,   'second', ' ',' ')
        if (avgper .gt. 1.e-6) then
          call defvar ('period', iou, 1, id, c0, c0, ' ', 'F'
     &,     'averaging period', ' ',' ')
        endif
        call defvar ('sat', iou, 1, id, c100, c400, ' ', 'F'
     &,   'global average surface air temperature', ' ', 'K')
        call defvar ('shum', iou, 1, id, -c100, c100, ' ', 'F'
     &,   'global average surface specific humidity', ' ', '1')
        call defvar ('precip', iou, 1, id, -c100, c100, ' '
     &,   'F', 'global average precipitation', ' ','kg m-2 s-1')
        call defvar ('co2ccn', iou, 1, id, c0, c1e3, ' '
     &,   'F', 'global average CO2 concentration', ' ','ppm')
        call defvar ('maxit', iou, 1, id, c0, c1e3, ' '
     &,   'F', 'maximum atmosphere solver iterations', ' ','')
#  if defined uvic_ice
        call defvar ('snow_volume', iou, 1, id, c0, c1e20, ' '
     &,   'F', 'global snow volume', ' ', 'm3')
        call defvar ('sea_ice_volume', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'global sea ice volume', ' ', 'm3')
        call defvar ('sea_ice_area', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'global sea ice area', ' ', 'm2')
        call defvar ('land_ice_volume', iou, 1, id, c0
     &,    c1e20, ' ', 'F', 'global land ice volume', ' ', 'm3')
        call defvar ('land_ice_area', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'global land ice area', ' ', 'm2')
#  endif
#  if defined uvic_tai_ns
        call defvar ('n_sat', iou, 1, id, c100, c400, ' '
     &,   'F', 'NH average surface air temperature', ' ', 'K')
        call defvar ('s_sat', iou, 1, id, c100, c400, ' '
     &,   'F', 'SH average surface air temperature', ' ', 'K')
        call defvar ('n_shum', iou, 1, id, -c100, c100, ' '
     &,   'F', 'NH average surface specific humidity', ' ', '1')
        call defvar ('s_shum', iou, 1, id, -c100, c100, ' '
     &,   'F', 'SH average surface specific humidity', ' ', '1')
        call defvar ('n_precip', iou, 1, id, -c100, c100, ' '
     &,   'F', 'NH average precipitation', ' ','kg m-2 s-1')
        call defvar ('s_precip', iou, 1, id, -c100, c100, ' '
     &,   'F', 'SH average precipitation', ' ','kg m-2 s-1')
#   if defined uvic_ice
        call defvar ('n_snow_volume', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'NH snow volume', ' ', 'm3')
        call defvar ('s_snow_volume', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'SH snow volume', ' ', 'm3')
        call defvar ('n_sea_ice_volume', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'NH sea ice volume', ' ', 'm3')
        call defvar ('s_sea_ice_volume', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'SH sea ice volume', ' ', 'm3')
        call defvar ('n_sea_ice_area', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'NH sea ice area', ' ', 'm2')
        call defvar ('s_sea_ice_area', iou, 1, id, c0, c1e20
     &,   ' ', 'F', 'SH sea ice area', ' ', 'm2')
        call defvar ('n_land_ice_volume', iou, 1, id, c0
     &,    c1e20, ' ', 'F', 'NH land ice volume', ' ', 'm3')
        call defvar ('s_land_ice_volume', iou, 1, id, c0
     &,    c1e20, ' ', 'F', 'SH land ice volume', ' ', 'm3')
        call defvar ('n_land_ice_area', iou, 1, id, c0
     &,    c1e20, ' ', 'F', 'NH land ice area', ' ', 'm2')
        call defvar ('s_land_ice_area', iou, 1, id, c0
     &,    c1e20, ' ', 'F', 'SH land ice area', ' ', 'm2')
#   endif
#  endif

!-----------------------------------------------------------------------
!       end definitions
!-----------------------------------------------------------------------
        call enddef (iou)
        if (ntrec .eq. 0 ) ntrec = 1

      endif

!-----------------------------------------------------------------------
!     write 1d data (t)
!-----------------------------------------------------------------------
      call putvars ('time', iou, ntrec, relyr, c1, c0)
      call rdstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      tmp = nyear
      call putvars ('year', iou, ntrec, tmp, c1, c0)
      tmp = nmonth
      call putvars ('month', iou, ntrec, tmp, c1, c0)
      tmp = nday
      call putvars ('day', iou, ntrec, tmp, c1, c0)
      tmp = nhour
      call putvars ('hour', iou, ntrec, tmp, c1, c0)
      tmp = nmin
      call putvars ('minute', iou, ntrec, tmp, c1, c0)
      tmp = nsec
      call putvars ('second', iou, ntrec, tmp, c1, c0)
      if (avgper .gt. 1.e-6) then
        call putvars ('period', iou, ntrec, avgper, c1, c0)
      endif
      call putvars ('sat', iou, ntrec, sat, c1, -C2K)
      call putvars ('shum', iou, ntrec, shum, c1, c0)
      call putvars ('precip', iou, ntrec, precip, p1, c0)
      call putvars ('co2ccn', iou, ntrec, co2ccn, c1, c0)
      call putvars ('maxit', iou, ntrec, scan, c1, c0)
#  if defined uvic_ice
      call putvars ('sea_ice_volume', iou, ntrec, v_oice, c1e6, c0)
      call putvars ('sea_ice_area', iou, ntrec, a_oice, c1e4, c0)
      call putvars ('snow_volume', iou, ntrec, v_snow, c1e6, c0)
      call putvars ('land_ice_volume', iou, ntrec, v_lice, c1e6, c0)
      call putvars ('land_ice_area', iou, ntrec, a_lice, c1e4, c0)
#  endif
#  if defined uvic_tai_ns
      call putvars ('n_sat', iou, ntrec, nsat, c1, -C2K)
      call putvars ('s_sat', iou, ntrec, ssat, c1, -C2K)
      call putvars ('n_shum', iou, ntrec, nshum, c1, c0)
      call putvars ('s_shum', iou, ntrec, sshum, c1, c0)
      call putvars ('n_precip', iou, ntrec, nprecip, p1, c0)
      call putvars ('s_precip', iou, ntrec, sprecip, p1, c0)
#   if defined uvic_ice
      call putvars ('n_sea_ice_volume', iou, ntrec, v_noice, c1e6, c0)
      call putvars ('s_sea_ice_volume', iou, ntrec, v_soice, c1e6, c0)
      call putvars ('n_sea_ice_area', iou, ntrec, a_noice, c1e4, c0)
      call putvars ('s_sea_ice_area', iou, ntrec, a_soice, c1e4, c0)
      call putvars ('n_snow_volume', iou, ntrec, v_nsnow, c1e6, c0)
      call putvars ('s_snow_volume', iou, ntrec, v_ssnow, c1e6, c0)
      call putvars ('n_land_ice_volume', iou, ntrec, v_nlice, c1e6, c0)
      call putvars ('s_land_ice_volume', iou, ntrec, v_slice, c1e6, c0)
      call putvars ('n_land_ice_area', iou, ntrec, a_nlice, c1e4, c0)
      call putvars ('s_land_ice_area', iou, ntrec, a_slice, c1e4, c0)
#   endif
#  endif

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)
#endif

      return
      end
