      subroutine calc_astress (is, ie, js, je)

!=======================================================================
!     calculate anomolous pressure and geostrophic wind

!     based on code by: A. Fanning and M. Eby
!=======================================================================
#if defined uvic_embm_astress && defined uvic_embm

      implicit none

# include "param.h"
# include "atm.h"
# include "grdvar.h"

      integer i, ie, is, j, je, js, n

      real b, bc(11), rd, s, sc(11), tclm, tmdl

!     fit to ECMWF data
      data bc/  2.59709E-03, -5.76312E-06,  1.10314E-07,  9.27774E-09
     &,        -1.77340E-10, -3.05476E-12,  6.56141E-14,  3.68229E-16
     &,        -8.69663E-18, -1.51366E-20,  3.88660E-22 /

      data sc/ -4.74336E-06,  2.03583E-08, -3.47492E-10, -3.30436E-11
     &,         5.88653E-13,  1.10427E-14, -2.24471E-16, -1.34262E-18
     &,         3.01447E-20,  5.54779E-23, -1.35603E-24 /

!     fit to NCEP data
!      data bc/  2.55395e-03, -5.62127e-06,  2.31210e-07,  8.82642e-09
!     &,        -2.94558e-10, -2.89406e-12,  1.05941e-13,  3.29985e-16
!     &,        -1.39957e-17, -1.25170e-20,  6.27082e-22 /

!      data sc/ -4.60028e-06,  1.97907e-08, -7.63178e-10, -3.13384e-11
!     &,         9.97370e-13,  1.04143e-14, -3.65328e-16, -1.19479e-18
!     &,         4.85947e-20,  4.54453e-23, -2.18230e-24 /

!-----------------------------------------------------------------------
!     calculate sea level pressure (slp) from temperature
!     use the equation of state for an ideal gas, P=rho*R*T, and
!     assume a linear relationship between density and temperature
!     rho = s*T_c + b, where s in g/cm3/K, b in g/cm3 are latitudinal
!     dependent parameters and T_c is the temperature in Celsius
!     for the pressure anomoly use dP = R*(s*d(T**2) + b*dT)
!-----------------------------------------------------------------------

      rd = 287.0e4              ! ideal gas constant in cm^2/K/s^2
      do j=js,je
        do i=is,ie
          s = 0.
          b = 0.
          do n=1,11
            s = s + sc(n)*tlat(i,j)**(n-1)
            b = b + bc(n)*tlat(i,j)**(n-1)
          enddo
          tmdl = rtbar(i,j) + 273.15
          tclm = tbar(i,j) + 273.15
          apress(i,j) = rd*(s*(tmdl**2 - tclm**2) + b*(tmdl - tclm))
        enddo
      enddo
      call embmbc (apress)
      call geowind (0.8, awx, awy, is, ie, js, je)
#endif

      return
      end

      subroutine add_astress (is, ie, js, je)

!=======================================================================
!     update winds

!     based on code by: A. Fanning and M. Eby
!=======================================================================
#if defined uvic_embm_astress && defined uvic_embm

      implicit none

# include "param.h"
# include "atm.h"
# include "cembm.h"
# include "csbc.h"

      integer i, ie, is, j, je, js

      real drag, tmag, x, y, s

      drag = cdatm*rhoatm
      do j=js,je
        do i=is,ie
!         advection winds
# if defined uvic_embm_adv_q
          sbc(i,j,iwx) = sbc(i,j,iwx) + awx(i,j)
          sbc(i,j,iwy) = sbc(i,j,iwy) + awy(i,j)
# endif
!         wind speed
          x = cos(sbc(i,j,iwa))*sbc(i,j,iws) + awx(i,j)
          y = sin(sbc(i,j,iwa))*sbc(i,j,iws) + awy(i,j)
          sbc(i,j,iws) = sqrt(x**2 + y**2)
!         wind stress
          tmag = sqrt(sqrt(sbc(i,j,itaux)**2
     &         + sbc(i,j,itauy)**2)/drag) + epsln
          x = sbc(i,j,itaux)/drag/tmag + awx(i,j)
          y = sbc(i,j,itauy)/drag/tmag + awy(i,j)
          s = sqrt(x**2 + y**2)
          sbc(i,j,itaux) = drag*x*s
          sbc(i,j,itauy) = drag*y*s
        enddo
      enddo
#endif

      return
      end

      subroutine geowind (contr, ugr, vgr, is, ie, js, je)

!=======================================================================
!     calculate the geostrophic velocities on uv grid (cm/s)

!     based on code by: A. Fanning and M. Eby
!=======================================================================
#if defined uvic_embm_astress && defined uvic_embm

      implicit none

# include "param.h"
# include "coord.h"
# include "grdvar.h"
# include "scalar.h"
# include "cembm.h"
# include "atm.h"

      integer i, ie, is, j, je, js

      real adpdx, adpdy, angle, const, contr, cosa, diag0, diag1
      real rlat, rnot, sina, ug, vg
      real ugr(is:ie,js:je), vgr(is:ie,js:je)

      angle = 20.0/radian   ! turning angle (from Gill 1982 p.328)
      rnot = 1.0/3600.0     ! time scale for equatorial damping (1 hr)

      cosa = cos(angle)
      sina = sin(angle)

      do j=js,je-1
        do i=is,ie-1
            diag1 = 0.
            diag0 = 0.
            diag1 = diag1 + apress(i+1,j+1) - apress(i,j)
            diag0 = diag0 + apress(i,j+1) - apress(i+1,j)
            adpdy  = (diag1 + diag0)*dyu2r(j)
            adpdx  = (diag1 - diag0)*dxu2r(i)*cstr(j)
            rlat = rnot*exp(-((ulat(i,j)/15.0)**2.0))
            const = contr/(rhoatm*(rlat**2 + fcor(i,j)**2))
            sina = sign(sina, ulat(i,j))
            vg =  const*(fcor(i,j)*adpdx - rlat*adpdy)
            ug = -const*(rlat*adpdx + fcor(i,j)*adpdy)
            ugr(i,j) = ug*cosa - vg*sina
            vgr(i,j) = ug*sina + vg*cosa
        enddo
      enddo

      call embmbc (ugr)
      call embmbc (vgr)

#endif

      return
      end
