      subroutine mom_tsi_out (fname, ntrec, timunit, expnam, avgper
     &,                       relyr, stamp, ektot, tbar1, tbar2
     &,                       travar1, travar2, dtabs1, dtabs2, scan
#if defined uvic_carbon
     &,                       tbar_dic
#endif
#if defined uvic_npzd
     &,                       tbar_n, tbar_p, tbar_z, tbar_d, tbar_npzd
#endif
#if defined uvic_tai_otsf
     &,                       otmax, otmin
#endif
#if defined uvic_tai_slh
     &,                       slh
#endif
     &                       )
!=======================================================================
!     output routine for ocean time step integrals

!   inputs:
!     fname      = file name
!     ntrec      = number of time record (zero if not defined)
!     timunit    = time unit
!     expnam     = experiment name
!     avgper     = length of averaging period
!     relyr      = time in years
!     stamp      = time stamp
!     ektot, ... = data to be written

!   outputs:
!     ntrec      = number of time record in file

!   local variables
!     iou        = io unit (ncid)

!     based on code by: M. Eby
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, stamp
      character(120) :: name, title, file_stamp, new_file_name

      integer id(1), id_time, iou, ntrec
      integer nyear, nmonth, nday, nhour, nmin, nsec

      real ektot, tbar1, tbar2, travar1, travar2, dtabs1, dtabs2, scan
      real tbar_dic, tbar_n, tbar_p, tbar_z, tbar_d, tbar_npzd
      real otmax, otmin, slh, avgper, relyr, tmp
      real c0, c1, c100, c400, c1e3, c1e6, c1e20, C2K, p001, p035

      logical defined

      c0 = 0.
      c1 = 1.
      c100 = 100.
      c400 = 400.
      c1e3 = 1.e3
      c1e6 = 1.e6
      c1e20 = 1.e20
      C2K = 273.15
      p001 = 0.001
      p035 = 0.035

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      defined = .true.
      name = new_file_name (fname)
      if (ntrec .eq. 0) defined = .false.
      call opennext (name, relyr, ntrec, iou)

      if (.not. defined .or. ntrec .eq. 0) then

        if (ntrec .ne. 1) then
          call closefile (iou)
          call opennew (name, iou)
          ntrec = 1
        endif

!-----------------------------------------------------------------------
!       start definitions
!-----------------------------------------------------------------------
        call redef (iou)

!-----------------------------------------------------------------------
!       set global attributes
!-----------------------------------------------------------------------
        if (avgper .gt. 1.e-6) then
          title = 'Time Average Time Step Integrals'
        else
          title = 'Time Step Integrals'
        endif
        call putglobal (iou, name, title, expnam, timunit)

!-----------------------------------------------------------------------
!       define dimensions
!-----------------------------------------------------------------------
        call defdim ('time', iou, 0, id_time)
        id = id_time

!-----------------------------------------------------------------------
!       define 1d data (t)
!-----------------------------------------------------------------------
        call defvar ('time', iou, 1, id, c0, c0, 'T', 'D'
     &,   'time since initial condition', 'time', trim(timunit))
        call defvar ('year', iou, 1, id, c0, c0, ' ', 'F'
     &,   'year', ' ',' ')
        call defvar ('month', iou, 1, id, c0, c0, ' ', 'F'
     &,   'month', ' ',' ')
        call defvar ('day', iou, 1, id, c0, c0, ' ', 'F'
     &,   'day', ' ',' ')
        call defvar ('hour', iou, 1, id, c0, c0, ' ', 'F'
     &,   'hour', ' ',' ')
        call defvar ('minute', iou, 1, id, c0, c0, ' ', 'F'
     &,   'minute', ' ',' ')
        call defvar ('second', iou, 1, id, c0, c0, ' ', 'F'
     &,   'second', ' ',' ')
        if (avgper .gt. 1.e-6) then
          call defvar ('period', iou, 1, id, c0, c0, ' ', 'F'
     &,     'averaging period', ' ',' ')
        endif
        call defvar ('ke', iou, 1, id, c0, c1e6, ' ', 'F'
     &,   'Kinetic energy per unit volume', ' ', 'J m-3')
        call defvar ('tbar', iou, 1, id, c100, c400, ' ', 'F'
     &,   'Global average T', ' ', 'K')
        call defvar ('sbar', iou, 1, id, c0, c100, ' ', 'F'
     &,   'Global average S', ' ', '1e-3')
        call defvar ('tvar', iou, 1, id, c0, c1e20, ' ', 'F'
     &,   'Variance of T', ' ', 'K2')
        call defvar ('svar', iou, 1, id, c0, c1e20, ' ', 'F'
     &,   'Variance of S', ' ', '1e-6')
        call defvar ('abs_chg_t', iou, 1, id, c0, c1e20, ' '
     &,   'F', '|dT/dt|', ' ', 'K s-1')
        call defvar ('abs_chg_s', iou, 1, id, c0, c1e20, ' '
     &,   'F', '|dS/dt|', ' ', '1e-3 s-1')
        call defvar ('scans', iou, 1, id, c0, c1e6, ' ', 'F'
     &,   'elliptic solver iterations', ' ', '1')
#if defined uvic_carbon
        call defvar ('dicbar', iou, 1, id, c0, c100, ' ', 'F'
     &,   'Global average dic', ' ', 'mol m-3')
#endif
#if defined uvic_npzd
        call defvar ('nbar', iou, 1, id, c0, c100, ' ', 'F'
     &,   'Global average N', ' ', 'mol m-3')
        call defvar ('pbar', iou, 1, id, c0, c100, ' ', 'F'
     &,   'Global average P', ' ', 'mol m-3')
        call defvar ('zbar', iou, 1, id, c0, c100, ' ', 'F'
     &,   'Global average Z', ' ', 'mol m-3')
        call defvar ('dbar', iou, 1, id, c0, c100, ' ', 'F'
     &,   'Global average D', ' ', 'mol m-3')
        call defvar ('npzdbar', iou, 1, id, c0, c100, ' ', 'F'
     &,   'Global average NPZD', ' ', 'mol m-3')
#endif
#if defined uvic_tai_otsf
        call defvar ('motsf_max', iou, 1, id, c0, c1e20, ' '
     &,   'F', 'maximum meridional overturning streamfunction', ' '
     &,   'm3 s-1')
        call defvar ('motsf_min', iou, 1, id, c0, c1e20, ' '
     &,   'F', 'minimum meridional overturning streamfunction', ' '
     &,   'm3 s-1')
#endif
#if defined uvic_tai_slh
        call defvar ('slh', iou, 1, id, c0, c1e20, ' '
     &,   'F', 'relative sea level height', ' '
     &,   'm')
#endif

!-----------------------------------------------------------------------
!       end definitions
!-----------------------------------------------------------------------
        call enddef (iou)
        if (ntrec .eq. 0) ntrec = 1

      endif

!-----------------------------------------------------------------------
!     write 1d data (t)
!-----------------------------------------------------------------------
      call putvars ('time', iou, ntrec, relyr, c1, c0)
      call rdstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      tmp = nyear
      call putvars ('year', iou, ntrec, tmp, c1, c0)
      tmp = nmonth
      call putvars ('month', iou, ntrec, tmp, c1, c0)
      tmp = nday
      call putvars ('day', iou, ntrec, tmp, c1, c0)
      tmp = nhour
      call putvars ('hour', iou, ntrec, tmp, c1, c0)
      tmp = nmin
      call putvars ('minute', iou, ntrec, tmp, c1, c0)
      tmp = nsec
      call putvars ('second', iou, ntrec, tmp, c1, c0)
      if (avgper .gt. 1.e-6) then
        call putvars ('period', iou, ntrec, avgper, c1, c0)
      endif
      call putvars ('ke', iou, ntrec, ektot, c100, c0)
      call putvars ('tbar', iou, ntrec, tbar1, c1, -C2K)
      call putvars ('sbar', iou, ntrec, tbar2, p001, -p035)
      tmp = 0.0
      if (travar1 .gt. 0.0) tmp = (sqrt(travar1)+273.15)**2
      call putvars ('tvar', iou, ntrec, tmp, c1, c0)
      tmp = 0.0
      if (travar2 .gt. 0.0) tmp = (sqrt(travar2)*1000.+35.)**2
      call putvars ('svar', iou, ntrec, tmp, c1, c0)
      tmp = dtabs1
      call putvars ('abs_chg_t', iou, ntrec, dtabs1, c1, c0)
      tmp = dtabs2
      call putvars ('abs_chg_s', iou, ntrec, dtabs2, p001, c0)
      call putvars ('scans', iou, ntrec, scan, c1, c0)
#if defined uvic_carbon
      call putvars ('dicbar', iou, ntrec, tbar_dic, c1, c0)
#endif
#if defined uvic_npzd
      call putvars ('nbar', iou, ntrec, tbar_n, c1e3, c0)
      call putvars ('pbar', iou, ntrec, tbar_p, c1e3, c0)
      call putvars ('zbar', iou, ntrec, tbar_z, c1e3, c0)
      call putvars ('dbar', iou, ntrec, tbar_d, c1e3, c0)
      call putvars ('npzdbar', iou, ntrec, tbar_npzd, c1e3, c0)
#endif
#if defined uvic_tai_otsf
      call putvars ('motsf_max', iou, ntrec, otmax, c1e6, c0)
      call putvars ('motsf_min', iou, ntrec, otmin, c1e6, c0)
#endif
#if defined uvic_tai_slh
      call putvars ('slh', iou, ntrec, slh, c100, c0)
#endif

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end
