!******************************************************************************
!   Crunch thermal balance terms for ice sheet ice at (k,ij,jj). Includes
!   strain heating strntm, vertical diffusion difftm, heat advection uadtm,
!   vadtm and (wadtmm,wadtm,wadtmp), grid transformation terms grttm,
!   uadgrtm, vadgrtm, and areal source terms srctm, dastm.
!   Units: either a^{-1} or deg C/a.

!   Vertical velocity field wvelt(nvertp) is positive upwards, but
!   uses k=1 at the ice surface and k=nvert at the bed.  Equations
!   solved at cell interfaces.

!   Semi-implicit solver with degree of implicitness fimp.
!   Make all explicit (RHS) terms in system AT^{m+1} = BT^m + c
!   positive by definition; also all independent terms in c.
!   Optimized discretization herein uses upstream differences for
!   the advection terms and a chain-rule balance over temperature
!   (rather than Patankar's energy balance, which is conceptually
!   favourable but numerically jaded).  idisc=4/5 toggles between
!   centred and upstream differences for the vertical terms.

    subroutine calct0(hi,tiso,tice,ticek,wvelt,vtt,vpt,ttt,tpt,tcolijk,&
                      bmelt,Hsij,delhx,delhhx,delhy,delhhy,uadco,vadco,&
                      gradij,dhidt,dhhdt,uadtm,vadtm,uadgrtm,vadgrtm,&
                      wadtmm,wadtm,wadtmp,grttmm,grttm,grttmp,strntm,&
                      difftm,difftmc,dkdttm,basaltm,kice,qgeo,htslid,&
                      imelt,ratemelt,tmelt,gradrt,gradlt,gradhi,gradlo,&
                      Hrt,Hlt,Hhi,Hlo,delz,cice,ktempl,i,j,k,ij,jj)

!****************************************************************************
      USE global_param
      implicit none
      INTEGER, INTENT(IN) :: i,j,k,ij,jj
      INTEGER, INTENT(INOUT) :: imelt,ktempl
      REAL(dp), INTENT(IN), DIMENSION(nvertp) :: tcolijk
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlatp) :: tice,ticek,wvelt
      REAL(dp), INTENT(IN), DIMENSION(2:nvertp,nlonp,nlat-1) :: ttt
      REAL(dp), INTENT(IN), DIMENSION(2:nvertp,nlon-1,nlatp) :: tpt
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlat-1) :: vtt
      REAL(dp), INTENT(IN), DIMENSION(nvertp,nlon-1,nlatp) :: vpt
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: hi
      REAL(dp), INTENT(IN) :: tiso,Hsij,delhx,delhhx,delhy,delhhy,gradij,&
                              uadco,vadco,dhidt,dhhdt,qgeo,htslid,gradrt,&
                              gradlt,gradhi,gradlo,delz,Hrt,Hlt,Hhi,Hlo
      REAL(dp), INTENT(INOUT) :: uadtm,vadtm,uadgrtm,vadgrtm,strntm,&
                                 grttm,grttmm,grttmp,basaltm,wadtmm,cice,&
                                 wadtm,wadtmp,difftm,difftmc,dkdttm,&
                                 kice,ratemelt,tmelt,bmelt(nlon,nlat)
      ! Local variables
      integer :: kj
      REAL(dp) :: dkdt,dtdxi,wadco,gridco,wgrid,uflux,vflux,dxidx,dxidy,&
                  water,qice,ebalance,ttest,tmcorr,depth,tcell,meltcrit,&
                  strn2,strn3,tcell2,tcell3,depth2,depth3,tmcorr2,tmcorr3,&
                  depthrt,depthlt,depthhi,depthlo,strnrt,strnlt,strnhi,&
                  strnlo,ticert,ticelt,ticehi,ticelo

      REAL(dp), EXTERNAL :: B

!*****************************************************************************
      kj = k-1
      if (k == nvertp) then             !! Basal boundary
        dtdxi = (c3*tcolijk(k) -c4*tcolijk(kj) +tcolijk(k-2))/(c2*delz)
      else
        dtdxi = (tcolijk(k+1)-tcolijk(kj))/(c2*delz)
      endif

!*****************************************************************************
      !! Implicit terms: wdiff, wadv, wgrid
      !! Arbitrate RHS signs for all terms

      ! Diffusion terms
      if (itdptvar == 0) then                ! Constant ice properties
        difftm = tdiffi/delz**2
        dkdttm = c0
        cice = htci
        kice = tcondi
      elseif (itdptvar == 1) then           ! T-dependent ice properties
        kice = kice1*EXP(kice2*tcolijk(k))*year
        cice = cice1 + cice2*tcolijk(k)
        difftm = kice/(rhoi*cice*delz**2)
        dkdt = kice3*EXP(kice2*tcolijk(k))*year
        dkdttm = dkdt*dtdxi**2/(rhoi*cice)
      endif

      !! Vertical advection terms
      wgrid = dhidt - xi(k)*dhhdt
      gridco = wgrid/(c2*delz)

      !! Grid terms (spatial)
      uflux = r2*(vpt(k,i,jj) + vpt(k,ij,jj))
      vflux = r2*(vtt(k,ij,jj)*sinehi(jj) + vtt(k,ij,j)*sinehi(j))
      dxidx = delhx - xi(k)*delhhx
      dxidy = delhy - xi(k)*delhhy

!*****************************************************************************
!*****************************************************************************
      if (k == nvertp) then             !! Basal boundary

        ! Diffusion term; incorporate basal heat flux
        difftmc = c2*(qgeo+htslid)/(rhoi*cice*delz)

        ! vertical advection and grid correction terms
        wadtm = wvelt(k,ij,jj)
        grttm  = -wgrid

        ! Grid terms (spatial)
        uadgrtm = -uflux*dxidx
        vadgrtm = -vflux*dxidy

        ! Sum basal terms
        basaltm = (qgeo+htslid)/kice*(grttm +wadtm + uadgrtm +vadgrtm)

        ! Strain dissipation
        if (itdcoup == 1) then          ! thermomechanic coupling

          if (istrn == 1) then                  ! Simpson's rule
            depth = Hsij*(p75 + p25*xi(kj))
            tcell = p75*tcolijk(k) + p25*tcolijk(kj)
            depth2 = Hsij*r2*(c1 + xi(kj))
            tcell2 = r2*(tcolijk(k) + tcolijk(kj))
            depth3 = Hsij
            tcell3 = tcolijk(k)
          elseif (istrn == 2) then             ! Interface average
            depthrt = Hrt*(p75 + p25*xi(kj))
            depthlt = Hlt*(p75 + p25*xi(kj))
            depthhi = Hhi*(p75 + p25*xi(kj))
            depthlo = Hlo*(p75 + p25*xi(kj))
            ticert = p75*tpt(k,i,jj) + p25*tpt(kj,i,jj)
            ticelt = p75*tpt(k,ij,jj) + p25*tpt(kj,ij,jj)
            ticehi = p75*ttt(k,ij,j) + p25*ttt(kj,ij,j)
            ticelo = p75*ttt(k,ij,jj) + p25*ttt(kj,ij,jj)
          endif

        else
          depth = Hsij*(p75 + p25*xi(kj))
        endif

!*****************************************************************************
      else                              !! Interior point

        ! Vertical advection terms
        if (idisc == 4) then              ! centre-differenced
          wadtmp = wvelt(k,ij,jj)/(c2*delz)     ! advection
          wadtm = c0
          wadtmm = -wadtmp
          grttmp = -gridco                        ! grid terms
          grttm = c0
          grttmm = gridco

        elseif (idisc == 5) then         ! upstreamed
          wadco = wvelt(k,ij,jj)/delz
          if (wadco <= c0) then                        ! advection
            wadtmp = c0
            wadtm = wadco
            wadtmm = -wadco
          else
            wadtmp = wadco
            wadtm = -wadco
            wadtmm = c0
          endif
          if (gridco <= c0) then                ! grid terms
            grttmp = c0
            grttm = -gridco
            grttmm = gridco
          else
            grttmp = -gridco
            grttm = gridco
            grttmm = c0
          endif
        endif                            ! End idisc ifblock

        ! Grid terms (spatial)
        uadgrtm = -uflux*dxidx/(c2*delz)
        vadgrtm = -vflux*dxidy/(c2*delz)

        ! Strain dissipation
        ! Strain dissipation
        if (itdcoup == 1) then          ! thermomechanic coupling

          if (istrn == 1) then                  ! Simpson's rule
            depth = Hsij*xi(k)
            tcell = tcolijk(k)
            if (k == nvert) then
              depth2 = Hsij*r2*(xi(k) + xi(kj))
              tcell2 = r2*(tcolijk(k) + tcolijk(kj))
              depth3 = Hsij*r2*(xi(k) + xi(k+1))
              tcell3 = r2*(tcolijk(k) + tcolijk(k+1))
            endif
          elseif (istrn == 2) then             ! Interface average
            depthrt = Hrt*xi(k)
            depthlt = Hlt*xi(k)
            depthhi = Hhi*xi(k)
            depthlo = Hlo*xi(k)
            ticert = tpt(k,i,jj)
            ticelt = tpt(k,ij,jj)
            ticehi = ttt(k,ij,j)
            ticelo = ttt(k,ij,jj)
          endif

        else
          depth = Hsij*xi(k)
        endif

!*****************************************************************************
      endif                              !! End k ifblock

!**************************************************************
      !! Explicit terms: uadv, vadv, strain

      ! Zonal advection (upstreamed, transformed)
      if (ij == 1) then              ! Default Wward
        uadtm = uadco*uflux*(-ticek(k,i+1,jj) &
                           + c4*ticek(k,i,jj) - c3*tcolijk(k))
      elseif (ij == nlonp) then     ! Default Eward
        uadtm = uadco*uflux*(c3*tcolijk(k) &
                        - c4*ticek(k,ij-1,jj) + ticek(k,ij-2,jj))
      else
        if (uflux > zerop) then                  ! Eward flow
          ! Ensure that there are two upstream cells
          if (hi(i-2,j) > hi(ij,j)) then                ! 3-pt upstream
            uadtm = uadco*uflux*(c3*tcolijk(k) &
                         - c4*ticek(k,ij-1,jj) + ticek(k,ij-2,jj))
          else                                          ! 2-pt upstream
            uadtm = c2*uadco*uflux*(tcolijk(k) - ticek(k,ij-1,jj))
          endif
        elseif (uflux < -zerop) then            ! Wward flow
          ! Ensure that there are two upstream cells
          if (hi(i+2,j) > hi(i+1,j)) then               ! 3-pt upstream
            uadtm = uadco*uflux*(-c3*tcolijk(k) &
                         + c4*ticek(k,i,jj) - ticek(k,i+1,jj))
          else                                          ! 2-pt upstream
            uadtm = c2*uadco*uflux*(ticek(k,i,jj)-tcolijk(k))
          endif
        else                                        ! Inconsequential flow
          uadtm = uadco*uflux*(ticek(k,i,jj)-ticek(k,ij-1,jj))  ! CD
        endif
      endif

      ! Meridional advection (upstreamed, transformed)
      if (jj == 1) then                          ! Sward flow
        vadtm = vadco*vflux*(c3*tcolijk(k) &
                        - c4*ticek(k,ij,j) + ticek(k,ij,j+1))
      elseif (jj == nlatp) then                 ! Nward flow
        vadtm = vadco*vflux*(-ticek(k,ij,jj-2) &
                        + c4*ticek(k,ij,jj-1) -c3*tcolijk(k))
      else
        if (vflux > zerop) then               ! Sward flow
          if (hi(i,j+2) > hi(i,j+1)) then               ! 3-pt upstream
            vadtm = vadco*vflux*(c3*tcolijk(k) &
                        - c4*ticek(k,ij,j) + ticek(k,ij,j+1))
          else                                          ! 2-pt upstream
            vadtm = c2*vadco*vflux*(tcolijk(k)-ticek(k,ij,j))
          endif
        elseif (vflux < -zerop) then         ! Nward flow
          if (hi(i,j-2) > hi(i,jj)) then                ! 3-pt upstream
            vadtm = vadco*vflux*(-ticek(k,ij,jj-2) &
                        + c4*ticek(k,ij,jj-1) - c3*tcolijk(k))
          else                                          ! 2-pt upstream
            vadtm = c2*vadco*vflux*(ticek(k,ij,jj-1)-tcolijk(k))
          endif
        else                                     ! Inconsequential flow
          vadtm = vadco*vflux*(ticek(k,ij,jj-1)-ticek(k,ij,j))   ! CD
        endif
      endif

!**************************************************************************
      ! Strain dissipation
      if (itdcoup == 0) then            ! Dynamics uncoupled from TD
        strntm = c2*Biso/(rhoi*cice)  &
                  *(rhoi*grav*depth)**gnp1*gradij**(gnp1/c2)
      else
        if (istrn == 1) then
          ! Apply quadratic Simpson's rule
          tmcorr = tcell + fptdep*depth
          strntm = c2*B(tmcorr)*1.67_dp/(rhoi*cice)  &
                      *(rhoi*grav*depth)**gnp1*gradij**(gnp1/c2)
          if ((k==nvert).or.(k==nvertp)) then
            tmcorr2 = tcell2 + fptdep*depth2
            strn2 = c2*B(tmcorr2)*1.67_dp/(rhoi*cice)  &
                      *(rhoi*grav*depth2)**gnp1*gradij**(gnp1/c2)
            tmcorr3 = tcell3 + fptdep*depth3
            strn3 = c2*B(tmcorr3)*1.67_dp/(rhoi*cice)  &
                      *(rhoi*grav*depth3)**gnp1*gradij**(gnp1/c2)
            strntm = r6*(c4*strntm + strn2 + strn3)
          endif

        elseif (istrn == 2) then
          ! Average strain heating at the interfaces
          strnrt = c2*B(ticert)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthrt)**gnp1*gradrt**(gnp1/c2)
          strnlt = c2*B(ticelt)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthlt)**gnp1*gradlt**(gnp1/c2)
          strnhi = c2*B(ticehi)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthhi)**gnp1*gradhi**(gnp1/c2)
          strnlo = c2*B(ticelo)*1.67_dp/(rhoi*cice)  &
                  *(rhoi*grav*depthlo)**gnp1*gradlo**(gnp1/c2)

          strntm = p25*(strnrt + strnlt + strnhi + strnlo)

        endif
      endif

!**************************************************************************
      ! Treat temperate layer: may include several cells
      imelt = 0
      tmelt = triplept - fptdep*Hsij*xi(k)
      water = c0                  ! Temporary--til we find water
      ttest = tcolijk(k) - tmelt
      meltcrit = 0.001_dp

      if ((tcolijk(k) >= tmelt) .or. (ABS(ttest)< meltcrit)) then   ! pmp

        if (k == nvertp) then
          qice = kice*dtdxi
          ebalance = strntm + uadtm + vadtm + difftmc + dkdttm + basaltm &
                      + c2*difftm*(-tcolijk(k)+tcolijk(kj))    ! Deg C/a
          if (ebalance >= c0) then                  ! Melting, specify T_pmp
            imelt = 1
            ratemelt = (qgeo+htslid-qice)/(rhoi*tlat)
            bmelt(i,j) = bmelt(i,j) + ratemelt    ! Sum over temperate layer
            ktempl = MIN(ktempl,k-1)

          else
            if (water > c0) then                  ! Refreezing, specify T_pmp
              imelt = 1
              ratemelt = (qgeo+htslid-qice)/(rhoi*tlat)
              bmelt(i,j) = bmelt(i,j) + ratemelt  ! Sum over temperate layer
              ktempl = MIN(ktempl,kj)
            else                                  ! Cooling, full solution
              imelt = 0
            endif
          endif

        else                  ! Internal temperate layer
          ebalance = strntm + uadtm + vadtm + dkdttm &
                    + (wadtm+grttm-c2*difftm)*tcolijk(k) &
                    + (wadtmm+grttmm+difftm-uadgrtm-vadgrtm)*tcolijk(kj) &
                    + (wadtmp+grttmp+difftm+uadgrtm+vadgrtm)*tcolijk(k+1)
          if (ebalance >= c0) then           ! Melting, specify T_pmp
            imelt = 1
            ratemelt = ebalance*cice*delz/tlat
            bmelt(i,j) = bmelt(i,j) + ratemelt  ! Sum over temperate layer
            ktempl = MIN(ktempl,kj)
          else                          ! Cooling, full solution
            imelt = 0
          endif
        endif

      endif

!***************************************************************************
    end subroutine calct0
!***************************************************************************
