!=======================================================================
!     set geometric contants based on code by S. Marshall

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_geom

! ... global
      USE global_vars

      implicit none

! ... local
      integer :: i,j,im1,jm1
      REAL(KIND=dp) :: lathi

!-----------------------------------------------------------------------
!     time steps in years
!-----------------------------------------------------------------------

      ntime    = INT(etime - stime)
      idelt    = ANINT(delt)
      ideltt   = INT(deltt)
      idelth   = INT(delth)
      ideltg   = INT(deltg)
      if ((irebound > 0) .and. (irebound < 2)) deltb = delt
      ideltb   = INT(deltb)
      ihydnest = INT(hydnest)

!-----------------------------------------------------------------------
!     calculate grid cell dimensions
!-----------------------------------------------------------------------

      delphi   = delphid*degtrad   ! (rad)
      deltheta = delthed*degtrad   ! (rad)
      dx       = erad*delphi       ! (m)
      dy       = erad*deltheta     ! (m)
      dxy      = dx*dy             ! (m^2)
      dxdx     = c2*dx             ! (m^2)
      dydy     = c2*dy             ! (m^2)

!-----------------------------------------------------------------------
!     geometric constants at the centre of the cell
!-----------------------------------------------------------------------

! ... longitude dependent
      do i=1,nlon
        im1 = i-1
        lon(i)  = phimin + (DBLE(im1)+r2)*delphid
      enddo

! ... latitude dependent
      do j=1,nlat
        jm1 = j-1
        lat(j) = themin + (DBLE(jm1)+r2)*delthed   ! latitude (degree)
        clat(j) = (c90 - lat(j))*degtrad           ! co-latitude (rad)
        sine(j) = SIN(clat(j))
        delx(j) = dx*sine(j)                       ! (m)
        area(j) = delx(j)*dy                       ! (m^2)
      enddo

!-----------------------------------------------------------------------
!     geometric constants at the north-south interface of the cell
!-----------------------------------------------------------------------

      if (igrid == 1) then
        do j=1,nlat-1
          lathi = themin + (DBLE(j)*delthed)  ! latitude (degree)
          clathi(j) = (c90 - lathi)*degtrad   ! co-latitude (rad)
          sinehi(j) = SIN(clathi(j))
          delxhi(j) = dx*sinehi(j)            ! (m)
        enddo
        call cidm_geom_bc(clathi)
        call cidm_geom_bc(sinehi)
        call cidm_geom_bc(delxhi)
      else
        do j=0,nlat
          lathi = themin + (DBLE(j)*delthed)  ! latitude (degree)
          clathi(j) = (c90 - lathi)*degtrad   ! co-latitude (rad)
          sinehi(j) = SIN(clathi(j))
          delxhi(j) = dx*sinehi(j)            ! (m)
        enddo
      endif

!-----------------------------------------------------------------------
!     geometric constants for ice dynamics at the centre of the cell
!-----------------------------------------------------------------------

      do j=1,nlat
        jm1 = j-1
        Bjvect(j) = (-COS(clathi(jm1)) + COS(clathi(j)))/deltheta
        Cjvect(j) = (LOG((c1-COS(clathi(jm1)))/sinehi(jm1))            &
                     -LOG((c1-COS(clathi(j)))/sinehi(j)))/deltheta
      enddo

!-----------------------------------------------------------------------
!     numerical boundary and physical domain for ice dynamics
!-----------------------------------------------------------------------

! ... boundary points
      idomain = 0

! ... interior points
      idomain(2:nlon-1,2:nlat-1) = 1

!=======================================================================
      end subroutine cidm_geom
!=======================================================================

!=======================================================================
!     set north-south no-flow boundary conditions

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_geom_bc(data)

      USE global_param   ! nlat
      implicit none

      REAL(KIND=dp),INTENT(INOUT),DIMENSION(0:nlat) :: data

!-----------------------------------------------------------------------
!     set no-flow North-South boundary condition
!-----------------------------------------------------------------------

      data(0)      = data(1)
      data(nlat)   = data(nlat-1)

!=======================================================================
      end subroutine cidm_geom_bc
!=======================================================================

!=======================================================================
!     set geometric contants in the atmosphere model

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_geom_embm

! ... global
      USE cidm_mod_embm   ! mi,mj,imint,jmint,iimt,jjmt
      implicit none

! ... local
      integer :: i,j

!-----------------------------------------------------------------------
!     embm tracer grids
!-----------------------------------------------------------------------

! ... longitude dependent
      do i=1,iimt
        xt(i) = xt_min + dxt*DBLE(imint-1) + dxt*DBLE(i-1)/DBLE(mi)
      enddo

! ... latitude dependent
      do j=1,jjmt
        yt(j) = yt_min + dyt*DBLE(jmint-1) + dyt*DBLE(j-1)/DBLE(mj)
      enddo

!=======================================================================
      end subroutine cidm_geom_embm
!=======================================================================
